/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Launcher;
import hudson.LauncherDecorator;
import hudson.console.ConsoleLogFilter;
import hudson.model.Computer;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.PasswordParameterValue;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.Secret;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.flow.GraphListener;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graph.StepNode;
import org.jenkinsci.plugins.workflow.log.TaskListenerDecorator;
import org.jenkinsci.plugins.workflow.steps.EnvironmentExpander;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.support.actions.EnvironmentAction;
import org.jenkinsci.plugins.workflow.support.actions.LogStorageAction;

public abstract class DefaultStepContext
extends StepContext {
    private static final Logger LOGGER = Logger.getLogger(DefaultStepContext.class.getName());
    private transient TaskListener listener;

    public final <T> T get(Class<T> key) throws IOException, InterruptedException {
        StepNode stepNode;
        T value = null;
        if (Run.class.isAssignableFrom(key)) {
            value = this.castOrNull(key, this.getExecution().getOwner().getExecutable());
        } else if (Job.class.isAssignableFrom(key)) {
            value = this.castOrNull(key, this.get(Run.class).getParent());
        } else if (FlowExecution.class.isAssignableFrom(key)) {
            value = this.castOrNull(key, this.getExecution());
        } else if (FlowNode.class.isAssignableFrom(key)) {
            value = this.castOrNull(key, this.getNode());
        } else if (StepDescriptor.class.isAssignableFrom(key) && (stepNode = this.castOrNull(StepNode.class, this.getNode())) != null) {
            value = this.castOrNull(key, stepNode.getDescriptor());
        }
        if (value != null) {
            return value;
        }
        value = this.doGet(key);
        if (key == EnvVars.class) {
            Run run = this.get(Run.class);
            EnvironmentAction a = run == null ? null : (EnvironmentAction)run.getAction(EnvironmentAction.class);
            TaskListener taskListener = this.getListener(true);
            EnvVars customEnvironment = a != null ? a.getEnvironment() : run.getEnvironment(taskListener);
            return key.cast(EnvironmentExpander.getEffectiveEnvironment((EnvVars)customEnvironment, (EnvVars)((EnvVars)value), (EnvironmentExpander)this.get(EnvironmentExpander.class), (StepContext)this, (TaskListener)taskListener));
        }
        if (key == Launcher.class) {
            return key.cast(this.makeLauncher((Launcher)value));
        }
        if (value != null) {
            return value;
        }
        if (key == TaskListener.class) {
            return key.cast(this.getListener(false));
        }
        if (key == EnvironmentExpander.class) {
            return key.cast((Object)new PasswordParameterEnvironmentExpander(this.get(Run.class)));
        }
        if (Node.class.isAssignableFrom(key)) {
            Computer c = this.get(Computer.class);
            Node n = null;
            if (c != null) {
                n = c.getNode();
            }
            return this.castOrNull(key, n);
        }
        return null;
    }

    private synchronized TaskListener getListener(boolean allowInactive) throws IOException, InterruptedException {
        if (this.listener == null) {
            final FlowNode node = this.getNode();
            if (!node.isActive()) {
                if (allowInactive) {
                    return this.getExecution().getOwner().getListener();
                }
                throw new IOException("cannot start writing logs to a finished node " + String.valueOf(node) + " " + node.getDisplayFunctionName() + " in " + String.valueOf(node.getExecution()));
            }
            this.listener = LogStorageAction.listenerFor(node, TaskListenerDecorator.merge((TaskListenerDecorator)TaskListenerDecorator.fromConsoleLogFilter((ConsoleLogFilter)this.get(ConsoleLogFilter.class)), (TaskListenerDecorator)this.get(TaskListenerDecorator.class)));
            LOGGER.log(Level.FINE, "opened log for {0}", node.getDisplayFunctionName());
            if (this.listener instanceof AutoCloseable) {
                node.getExecution().addListener((GraphListener)new GraphListener.Synchronous(){

                    public void onNewHead(FlowNode newNode) {
                        if (!node.isActive()) {
                            node.getExecution().removeListener((GraphListener)this);
                            LOGGER.log(Level.FINE, "closing log for {0}", node.getDisplayFunctionName());
                            try {
                                ((AutoCloseable)DefaultStepContext.this.listener).close();
                            }
                            catch (Exception x) {
                                LOGGER.log(Level.WARNING, null, x);
                            }
                        }
                    }
                });
            }
        }
        return this.listener;
    }

    private <T> T castOrNull(Class<T> key, Object o) {
        if (key.isInstance(o)) {
            return key.cast(o);
        }
        return null;
    }

    @CheckForNull
    private Launcher makeLauncher(@CheckForNull Launcher contextual) throws IOException, InterruptedException {
        LauncherDecorator decorator;
        Launcher launcher = contextual;
        Node n = this.get(Node.class);
        if (launcher == null) {
            if (n == null) {
                return null;
            }
            launcher = n.createLauncher(this.get(TaskListener.class));
        }
        if ((decorator = this.get(LauncherDecorator.class)) != null && n != null) {
            launcher = decorator.decorate(launcher, n);
        }
        return launcher;
    }

    @CheckForNull
    protected abstract <T> T doGet(Class<T> var1) throws IOException, InterruptedException;

    @NonNull
    protected abstract FlowExecution getExecution() throws IOException;

    @NonNull
    protected abstract FlowNode getNode() throws IOException;

    private static class PasswordParameterEnvironmentExpander
    extends EnvironmentExpander {
        private static final long serialVersionUID = 1L;
        private final Set<String> passwordParameterVariables;

        public PasswordParameterEnvironmentExpander(Run<?, ?> run) {
            ParametersAction action = (ParametersAction)run.getAction(ParametersAction.class);
            this.passwordParameterVariables = action != null ? (Set<Object>)action.getParameters().stream().filter(e -> e instanceof PasswordParameterValue && !((Secret)e.getValue()).getPlainText().isEmpty()).map(ParameterValue::getName).collect(Collectors.toCollection(HashSet::new)) : Collections.emptySet();
        }

        public void expand(EnvVars ev) {
        }

        public Set<String> getSensitiveVariables() {
            return this.passwordParameterVariables;
        }
    }
}

