/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.concurrent;

import java.util.logging.Logger;
import jenkins.util.SystemProperties;

public final class WithThreadName
implements AutoCloseable {
    private final String original;
    private static final boolean enabled = SystemProperties.getBoolean((String)(WithThreadName.class.getName() + ".enabled"), (boolean)true);
    private static final Logger LOGGER = Logger.getLogger(WithThreadName.class.getName());

    public WithThreadName(String suffix) {
        if (!enabled) {
            this.original = null;
            LOGGER.fine(() -> "SKIP: Neutered WithThreadName(\"" + (suffix == null ? "(null)" : suffix) + "\")");
            return;
        }
        Thread t = Thread.currentThread();
        this.original = t.getName();
        t.setName(this.original + suffix);
    }

    @Override
    public void close() {
        if (!enabled) {
            LOGGER.fine(() -> "SKIP: Neutered WithThreadName.close()");
            return;
        }
        Thread.currentThread().setName(this.original);
    }
}

