/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.actions;

import hudson.Extension;
import hudson.model.Action;
import hudson.model.Item;
import hudson.security.AccessControlled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.TransientActionFactory;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graphanalysis.DepthFirstScanner;
import org.jenkinsci.plugins.workflow.support.actions.Messages;
import org.jenkinsci.plugins.workflow.support.actions.WorkspaceActionImpl;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public final class WorkspaceRunAction
implements Action {
    private static final Logger LOGGER = Logger.getLogger(WorkspaceRunAction.class.getName());
    private final FlowExecutionOwner.Executable build;
    public final FlowExecutionOwner owner;

    WorkspaceRunAction(FlowExecutionOwner.Executable build, FlowExecutionOwner owner) {
        this.build = build;
        this.owner = owner;
    }

    private boolean hasNoWorkspacePermission() {
        return this.build instanceof AccessControlled && !((AccessControlled)this.build).hasPermission(Item.WORKSPACE);
    }

    public String getIconFileName() {
        return this.hasNoWorkspacePermission() ? null : "folder.png";
    }

    public String getDisplayName() {
        return this.hasNoWorkspacePermission() ? null : Messages.workspaces();
    }

    public String getUrlName() {
        return this.hasNoWorkspacePermission() ? null : "ws";
    }

    public List<WorkspaceActionImpl> getActions() {
        FlowExecution exec;
        try {
            exec = this.owner.get();
        }
        catch (IOException x) {
            LOGGER.log(Level.WARNING, null, x);
            return Collections.emptyList();
        }
        ArrayList<WorkspaceActionImpl> r = new ArrayList<WorkspaceActionImpl>();
        for (FlowNode node : new DepthFirstScanner().allNodes(exec)) {
            r.addAll(node.getActions(WorkspaceActionImpl.class));
        }
        Collections.reverse(r);
        return r;
    }

    @Extension
    public static final class Factory
    extends TransientActionFactory<FlowExecutionOwner.Executable> {
        public Class<FlowExecutionOwner.Executable> type() {
            return FlowExecutionOwner.Executable.class;
        }

        public Collection<? extends Action> createFor(FlowExecutionOwner.Executable target) {
            FlowExecutionOwner owner = target.asFlowExecutionOwner();
            if (owner == null) {
                return Collections.emptySet();
            }
            return Collections.singleton(new WorkspaceRunAction(target, owner));
        }
    }
}

