/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.Functions;
import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import jenkins.model.CauseOfInterruption;
import jenkins.model.InterruptedBuildAction;

public final class FlowInterruptedException
extends InterruptedException {
    private static final long serialVersionUID = 630482382622970136L;
    @NonNull
    private final Result result;
    @NonNull
    private final List<CauseOfInterruption> causes;
    private Boolean actualInterruption = true;

    @Deprecated
    public FlowInterruptedException(@NonNull Result result, CauseOfInterruption ... causes) {
        this(result, true, causes);
    }

    public FlowInterruptedException(@NonNull Result result, boolean actualInterruption, CauseOfInterruption ... causes) {
        this.result = result;
        this.causes = Arrays.asList(causes);
        this.actualInterruption = actualInterruption;
    }

    @NonNull
    public Result getResult() {
        return this.result;
    }

    @NonNull
    public List<CauseOfInterruption> getCauses() {
        return this.causes;
    }

    public boolean isActualInterruption() {
        return this.actualInterruption;
    }

    public void setActualInterruption(boolean actualInterruption) {
        this.actualInterruption = actualInterruption;
    }

    private Object readResolve() {
        if (this.actualInterruption == null) {
            this.actualInterruption = true;
        }
        return this;
    }

    @Override
    public String getMessage() {
        return this.causes.stream().map(CauseOfInterruption::getShortDescription).collect(Collectors.joining(", "));
    }

    public void handle(Run<?, ?> run, TaskListener listener) {
        HashSet boundCauses = new HashSet();
        for (InterruptedBuildAction a : run.getActions(InterruptedBuildAction.class)) {
            boundCauses.addAll(a.getCauses());
        }
        LinkedHashSet<CauseOfInterruption> diff = new LinkedHashSet<CauseOfInterruption>(this.causes);
        diff.removeAll(boundCauses);
        if (!diff.isEmpty()) {
            run.addAction((Action)new InterruptedBuildAction(diff));
            for (CauseOfInterruption cause : diff) {
                cause.print(listener);
            }
        }
        FlowInterruptedException.print(this.getCause(), run, listener);
        for (Throwable t : this.getSuppressed()) {
            FlowInterruptedException.print(t, run, listener);
        }
    }

    private static void print(@CheckForNull Throwable t, Run<?, ?> run, @NonNull TaskListener listener) {
        if (t instanceof AbortException) {
            listener.getLogger().println(t.getMessage());
        } else if (t instanceof FlowInterruptedException) {
            ((FlowInterruptedException)t).handle(run, listener);
        } else if (t != null) {
            Functions.printStackTrace((Throwable)t, (PrintStream)listener.getLogger());
        }
    }
}

