/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.Serializable;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;

@FunctionalInterface
@Restricted(value={Beta.class})
public interface FailureHandler
extends Serializable {
    @NonNull
    public Throwable handle(@NonNull StepContext var1, @NonNull Throwable var2);

    @NonNull
    public static Throwable apply(@NonNull StepContext ctx, @NonNull Throwable t) {
        try {
            FailureHandler h = ctx.get(FailureHandler.class);
            if (h == null) {
                return t;
            }
            return h.handle(ctx, t);
        }
        catch (Throwable x) {
            t.addSuppressed(x);
            return t;
        }
    }

    public static FailureHandler merge(@CheckForNull FailureHandler original, @NonNull FailureHandler subsequent) {
        if (original == null) {
            return subsequent;
        }
        return (ctx, t) -> subsequent.handle(ctx, original.handle(ctx, t));
    }
}

