/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.ExtensionPoint;
import java.io.IOException;

public interface DynamicContext
extends ExtensionPoint {
    @CheckForNull
    public <T> T get(Class<T> var1, DelegatedContext var2) throws IOException, InterruptedException;

    public static abstract class Typed<T>
    implements DynamicContext {
        @NonNull
        protected abstract Class<T> type();

        @CheckForNull
        protected abstract T get(DelegatedContext var1) throws IOException, InterruptedException;

        public final <U> U get(Class<U> key, DelegatedContext context) throws IOException, InterruptedException {
            Class<T> type = this.type();
            if (key.isAssignableFrom(type)) {
                return key.cast(this.get(context));
            }
            if (type.isAssignableFrom(key)) {
                T t = this.get(context);
                if (key.isInstance(t)) {
                    return key.cast(t);
                }
                return null;
            }
            return null;
        }
    }

    public static interface DelegatedContext {
        @Nullable
        public <T> T get(Class<T> var1) throws IOException, InterruptedException;
    }
}

