/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import com.google.common.util.concurrent.FutureCallback;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Launcher;
import hudson.LauncherDecorator;
import hudson.console.ConsoleLogFilter;
import hudson.model.AbstractBuild;
import hudson.model.Node;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import org.jenkinsci.plugins.workflow.steps.BodyExecution;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;

public abstract class BodyInvoker {
    public abstract BodyInvoker withContext(Object var1);

    public BodyInvoker withContexts(Object ... overrides) {
        return this.withContexts(Arrays.asList(overrides));
    }

    public BodyInvoker withContexts(Collection<?> overrides) {
        for (Object o : overrides) {
            this.withContext(o);
        }
        return this;
    }

    public abstract BodyInvoker withDisplayName(@NonNull String var1);

    public abstract BodyInvoker withCallback(BodyExecutionCallback var1);

    public final BodyInvoker withCallback(FutureCallback<Object> callback) {
        return this.withCallback(BodyExecutionCallback.wrap(callback));
    }

    public abstract BodyExecution start();

    public static ConsoleLogFilter mergeConsoleLogFilters(@CheckForNull ConsoleLogFilter original, @NonNull ConsoleLogFilter subsequent) {
        if (original == null) {
            return subsequent;
        }
        return new MergedFilter(original, subsequent);
    }

    public static LauncherDecorator mergeLauncherDecorators(@CheckForNull LauncherDecorator original, @NonNull LauncherDecorator subsequent) {
        if (original == null) {
            return subsequent;
        }
        return new MergedLauncherDecorator(original, subsequent);
    }

    private static final class MergedFilter
    extends ConsoleLogFilter
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final ConsoleLogFilter original;
        private final ConsoleLogFilter subsequent;

        MergedFilter(ConsoleLogFilter original, ConsoleLogFilter subsequent) {
            this.original = original;
            this.subsequent = subsequent;
        }

        public OutputStream decorateLogger(AbstractBuild _ignore, OutputStream logger) throws IOException, InterruptedException {
            return this.subsequent.decorateLogger(_ignore, this.original.decorateLogger(_ignore, logger));
        }
    }

    private static final class MergedLauncherDecorator
    extends LauncherDecorator
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final LauncherDecorator original;
        private final LauncherDecorator subsequent;

        MergedLauncherDecorator(LauncherDecorator original, LauncherDecorator subsequent) {
            this.original = original;
            this.subsequent = subsequent;
        }

        public Launcher decorate(Launcher launcher, Node node) {
            return this.subsequent.decorate(this.original.decorate(launcher, node), node);
        }
    }
}

