/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.multibranch;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.scm.SCM;
import hudson.util.FormValidation;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;

public class ResolveScmStep
extends Step {
    @NonNull
    private final SCMSource source;
    @NonNull
    private final List<String> targets;
    private boolean ignoreErrors;

    @DataBoundConstructor
    public ResolveScmStep(@NonNull SCMSource source, @NonNull List<String> targets) {
        this.source = source;
        this.targets = new ArrayList<String>(targets);
    }

    @NonNull
    public SCMSource getSource() {
        return this.source;
    }

    @NonNull
    public List<String> getTargets() {
        return Collections.unmodifiableList(this.targets);
    }

    public boolean isIgnoreErrors() {
        return this.ignoreErrors;
    }

    @DataBoundSetter
    public void setIgnoreErrors(boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(context, this);
    }

    public String toString() {
        return "ResolveScmStep{source=" + String.valueOf(this.source) + ", targets=" + String.valueOf(this.targets) + ", ignoreErrors=" + this.ignoreErrors + "}";
    }

    public static class Execution
    extends SynchronousStepExecution<SCM> {
        private static final long serialVersionUID = 1L;
        @NonNull
        private final transient SCMSource source;
        @NonNull
        private final List<String> targets;
        private boolean ignoreErrors;

        Execution(StepContext context, ResolveScmStep step) {
            super(context);
            this.source = step.getSource();
            this.targets = new ArrayList<String>(step.getTargets());
            this.ignoreErrors = step.isIgnoreErrors();
        }

        protected SCM run() throws Exception {
            StepContext context = this.getContext();
            TaskListener listener = (TaskListener)context.get(TaskListener.class);
            assert (listener != null);
            PrintStream out = listener.getLogger();
            out.printf("Checking for first existing branch from %s...%n", this.targets);
            SCMRevision fetch = ((ObserverImpl)this.source.fetch((SCMHeadObserver)new ObserverImpl(this.targets), listener)).result();
            if (fetch == null) {
                if (this.ignoreErrors) {
                    out.println("Could not find any matching branch");
                    return null;
                }
                throw new AbortException("Could not find any matching branch");
            }
            out.printf("Found %s at revision %s%n", fetch.getHead().getName(), fetch);
            return this.source.build(fetch.getHead(), fetch);
        }
    }

    private static class ObserverImpl
    extends SCMHeadObserver {
        private final Map<String, SCMRevision> revision = new LinkedHashMap<String, SCMRevision>();

        public ObserverImpl(@NonNull List<String> heads) {
            heads.getClass();
            for (String head : heads) {
                if (head == null || head.isBlank()) continue;
                this.revision.put(head, null);
            }
        }

        @CheckForNull
        public SCMRevision result() {
            for (SCMRevision r : this.revision.values()) {
                if (r == null) continue;
                return r;
            }
            return null;
        }

        public void observe(@NonNull SCMHead head, @NonNull SCMRevision revision) {
            if (this.revision.containsKey(head.getName())) {
                this.revision.put(head.getName(), revision);
            }
        }

        public boolean isObserving() {
            return this.revision.values().iterator().next() == null;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<Class<?>> getRequiredContext() {
            return Collections.singleton(TaskListener.class);
        }

        public String getFunctionName() {
            return "resolveScm";
        }

        @NonNull
        public String getDisplayName() {
            return "Resolves an SCM from an SCM Source and a list of candidate target branch names";
        }

        public Step newInstance(@CheckForNull StaplerRequest2 req, @NonNull JSONObject formData) throws Descriptor.FormException {
            assert (req != null) : "see contract for method, it's never null but has to claim it could be";
            JSONObject src = formData.getJSONObject("source");
            src.put("id", (Object)"_");
            SCMSource source = (SCMSource)req.bindJSON(SCMSource.class, src);
            ArrayList<String> targets = new ArrayList<String>();
            Object t = formData.get("targets");
            if (t instanceof JSONObject) {
                JSONObject o = (JSONObject)t;
                targets.add(o.getString("target"));
            } else if (t instanceof JSONArray) {
                JSONArray a = (JSONArray)t;
                for (int i = 0; i < a.size(); ++i) {
                    JSONObject o = a.getJSONObject(i);
                    targets.add(o.getString("target"));
                }
            }
            ResolveScmStep step = new ResolveScmStep(source, targets);
            if (formData.optBoolean("ignoreErrors", false)) {
                step.setIgnoreErrors(true);
            }
            return step;
        }

        public FormValidation doCheckTarget(@QueryParameter String value) {
            if (value != null && !value.isBlank()) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)"You must supply a target branch name to resolve");
        }
    }
}

