/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.multibranch;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Run;
import java.util.Optional;
import jenkins.branch.BranchProperty;
import jenkins.branch.BranchPropertyDescriptor;
import jenkins.branch.BranchPropertyStrategy;
import jenkins.branch.JobDecorator;
import jenkins.branch.MultiBranchProject;
import jenkins.scm.api.SCMSource;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.workflow.flow.DurabilityHintProvider;
import org.jenkinsci.plugins.workflow.flow.FlowDurabilityHint;
import org.jenkinsci.plugins.workflow.flow.GlobalDefaultFlowDurabilityLevel;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.multibranch.BranchJobProperty;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

@Restricted(value={NoExternalUse.class})
public class DurabilityHintBranchProperty
extends BranchProperty {
    private final FlowDurabilityHint hint;

    public FlowDurabilityHint getHint() {
        return this.hint;
    }

    @DataBoundConstructor
    public DurabilityHintBranchProperty(@NonNull FlowDurabilityHint hint) {
        this.hint = hint;
    }

    public final <P extends Job<P, B>, B extends Run<P, B>> JobDecorator<P, B> jobDecorator(Class<P> clazz) {
        return null;
    }

    @Symbol(value={"durabilityHint"})
    @Extension
    public static class DescriptorImpl
    extends BranchPropertyDescriptor
    implements DurabilityHintProvider {
        @NonNull
        public String getDisplayName() {
            return "Pipeline branch speed/durability override";
        }

        public FlowDurabilityHint[] getDurabilityHintValues() {
            return FlowDurabilityHint.values();
        }

        public static FlowDurabilityHint getDefaultDurabilityHint() {
            return GlobalDefaultFlowDurabilityLevel.getDefaultDurabilityHint();
        }

        public int ordinal() {
            return 200;
        }

        @CheckForNull
        public FlowDurabilityHint suggestFor(@NonNull Item x) {
            if (x instanceof WorkflowJob && x.getParent() instanceof MultiBranchProject && ((WorkflowJob)x).getProperty(BranchJobProperty.class) != null) {
                Optional<BranchProperty> props;
                BranchPropertyStrategy bps;
                SCMSource source;
                MultiBranchProject mp = (MultiBranchProject)x.getParent();
                WorkflowJob job = (WorkflowJob)x;
                BranchJobProperty bjp = (BranchJobProperty)job.getProperty(BranchJobProperty.class);
                String sourceId = bjp.getBranch().getSourceId();
                if (sourceId != null && (source = mp.getSCMSource(sourceId)) != null && (bps = mp.getBranchPropertyStrategy(source)) != null && (props = bps.getPropertiesFor(bjp.getBranch().getHead()).stream().filter(bp -> bp instanceof DurabilityHintBranchProperty).findFirst()).isPresent()) {
                    return ((DurabilityHintBranchProperty)props.get()).getHint();
                }
            }
            return null;
        }
    }
}

