/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.job.console;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.MarkupText;
import hudson.Util;
import hudson.console.ConsoleAnnotationDescriptor;
import hudson.console.ConsoleAnnotator;
import hudson.console.ConsoleNote;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.workflow.actions.LabelAction;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.BlockEndNode;
import org.jenkinsci.plugins.workflow.graph.BlockStartNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={Beta.class})
public class NewNodeConsoleNote
extends ConsoleNote<WorkflowRun> {
    private static final Logger LOGGER = Logger.getLogger(NewNodeConsoleNote.class.getName());
    private static final String CONSOLE_NOTE_PREFIX = "[Pipeline] ";
    @NonNull
    private final String id;
    @CheckForNull
    private final String enclosing;
    @CheckForNull
    private final String start;
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void print(FlowNode node, TaskListener listener) {
        PrintStream logger;
        PrintStream printStream = logger = listener.getLogger();
        synchronized (printStream) {
            try {
                listener.annotate((ConsoleNote)new NewNodeConsoleNote(node));
            }
            catch (IOException x) {
                LOGGER.log(Level.WARNING, null, x);
            }
            logger.println(CONSOLE_NOTE_PREFIX + node.getDisplayFunctionName());
        }
    }

    private NewNodeConsoleNote(FlowNode node) {
        this.id = node.getId();
        if (node instanceof BlockEndNode) {
            this.enclosing = null;
            this.start = ((BlockEndNode)node).getStartNode().getId();
        } else {
            Iterator it = node.iterateEnclosingBlocks().iterator();
            this.enclosing = it.hasNext() ? ((BlockStartNode)it.next()).getId() : null;
            this.start = node instanceof BlockStartNode ? node.getId() : null;
        }
    }

    public ConsoleAnnotator<?> annotate(WorkflowRun context, MarkupText text, int charPos) {
        try {
            StringBuilder startTag = NewNodeConsoleNote.startTagFor(context, this.id, this.start, this.enclosing);
            text.addMarkup(0, text.length(), startTag.toString(), "</span>");
        }
        catch (RuntimeException x) {
            LOGGER.log(Level.WARNING, "problem in " + String.valueOf((Object)context), x);
        }
        return null;
    }

    @Restricted(value={NoExternalUse.class})
    public static StringBuilder startTagFor(@NonNull WorkflowRun context, @NonNull String id, @CheckForNull String start, @CheckForNull String enclosing) {
        FlowExecution execution;
        StringBuilder startTag = new StringBuilder("<span class=\"pipeline-new-node\" nodeId=\"").append(id);
        if (start != null) {
            startTag.append("\" startId=\"").append(start);
        }
        if (enclosing != null) {
            startTag.append("\" enclosingId=\"").append(enclosing);
        }
        if ((execution = context.getExecution()) != null) {
            try {
                LabelAction a;
                FlowNode node = execution.getNode(id);
                if (node != null && (a = (LabelAction)node.getAction(LabelAction.class)) != null) {
                    String displayName = a.getDisplayName();
                    assert (displayName != null);
                    startTag.append("\" label=\"").append(Util.escape((String)displayName));
                }
            }
            catch (IOException x) {
                LOGGER.log(Level.FINE, x, () -> "unloadable " + String.valueOf((Object)context));
            }
        }
        startTag.append("\">");
        return startTag;
    }

    @Extension
    public static final class DescriptorImpl
    extends ConsoleAnnotationDescriptor {
    }
}

