/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.steps;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.Node;
import hudson.remoting.Channel;
import hudson.slaves.WorkspaceList;
import java.io.IOException;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.workflow.flow.ErrorCondition;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;
import org.jenkinsci.plugins.workflow.steps.MissingContextVariableException;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.support.steps.AgentOfflineException;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;
import org.kohsuke.stapler.DataBoundConstructor;

@Restricted(value={Beta.class})
public final class AgentErrorCondition
extends ErrorCondition {
    @DataBoundConstructor
    public AgentErrorCondition() {
    }

    public boolean test(Throwable t, StepContext context) throws IOException, InterruptedException {
        Class type;
        if (t instanceof AgentOfflineException) {
            return true;
        }
        if (t instanceof FlowInterruptedException) {
            if (((FlowInterruptedException)t).getCauses().stream().anyMatch(Retryable.class::isInstance)) {
                return true;
            }
        }
        if (Channel.isClosedChannelException((Throwable)t)) {
            return true;
        }
        return t instanceof MissingContextVariableException && ((type = ((MissingContextVariableException)t).getType()) == FilePath.class || type == WorkspaceList.Lease.class || type == Computer.class || type == Executor.class || type == Node.class || type == Launcher.class);
    }

    public static interface Retryable {
    }

    @Symbol(value={"agent"})
    @Extension
    public static final class DescriptorImpl
    extends ErrorCondition.ErrorConditionDescriptor {
        public String getDisplayName() {
            return "Agent errors";
        }
    }
}

