/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps.durable_task;

import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.FilePath;
import hudson.Functions;
import hudson.Launcher;
import hudson.Util;
import hudson.init.Terminator;
import hudson.model.Action;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.ItemListener;
import hudson.remoting.ChannelClosedException;
import hudson.slaves.ComputerListener;
import hudson.slaves.OfflineCause;
import hudson.util.DaemonThreadFactory;
import hudson.util.FormValidation;
import hudson.util.NamingThreadFactory;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.CauseOfInterruption;
import jenkins.model.Jenkins;
import jenkins.tasks.filters.EnvVarsFilterableBuilder;
import jenkins.util.Timer;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.plugins.durabletask.Controller;
import org.jenkinsci.plugins.durabletask.DurableTask;
import org.jenkinsci.plugins.durabletask.Handler;
import org.jenkinsci.plugins.workflow.FilePathUtils;
import org.jenkinsci.plugins.workflow.actions.LabelAction;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionList;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.log.OutputStreamTaskListener;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.support.concurrent.Timeout;
import org.jenkinsci.plugins.workflow.support.concurrent.WithThreadName;
import org.jenkinsci.plugins.workflow.support.steps.ExecutorStepExecution;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public abstract class DurableTaskStep
extends Step
implements EnvVarsFilterableBuilder {
    private static final Logger LOGGER = Logger.getLogger(DurableTaskStep.class.getName());
    private static final int MAX_LABEL_LENGTH = 100;
    private boolean returnStdout;
    private String encoding;
    private boolean returnStatus;
    private String label;
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="public & mutable only for tests")
    public static long WATCHING_RECURRENCE_PERIOD = 300000L;
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="public & mutable only for tests")
    public static boolean USE_WATCHING = Boolean.getBoolean(DurableTaskStep.class.getName() + ".USE_WATCHING");
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="public & mutable for script console access")
    public static long REMOTE_TIMEOUT = Integer.parseInt(System.getProperty(DurableTaskStep.class.getName() + ".REMOTE_TIMEOUT", "20"));
    private static ScheduledThreadPoolExecutor threadPool;

    protected abstract DurableTask task();

    public boolean isReturnStdout() {
        return this.returnStdout;
    }

    @DataBoundSetter
    public void setReturnStdout(boolean returnStdout) {
        this.returnStdout = returnStdout;
    }

    public String getEncoding() {
        return this.encoding;
    }

    @DataBoundSetter
    public void setEncoding(String encoding) {
        this.encoding = Util.fixEmpty((String)encoding);
    }

    public boolean isReturnStatus() {
        return this.returnStatus;
    }

    @DataBoundSetter
    public void setReturnStatus(boolean returnStatus) {
        this.returnStatus = returnStatus;
    }

    @DataBoundSetter
    public void setLabel(String label) {
        this.label = Util.fixEmptyAndTrim((String)label);
    }

    public String getLabel() {
        return this.label;
    }

    public StepExecution start(StepContext context) throws Exception {
        if (this.label != null) {
            ((FlowNode)context.get(FlowNode.class)).addAction((Action)new LabelAction(this.label.length() > 100 ? this.label.substring(0, 100) : this.label));
        }
        return new Execution(context, this);
    }

    private static synchronized ScheduledExecutorService threadPool() {
        if (USE_WATCHING) {
            return Timer.get();
        }
        if (threadPool == null) {
            threadPool = new ScheduledThreadPoolExecutor(25, (ThreadFactory)new NamingThreadFactory((ThreadFactory)new DaemonThreadFactory(), DurableTaskStep.class.getName()));
            threadPool.setKeepAliveTime(1L, TimeUnit.MINUTES);
            threadPool.allowCoreThreadTimeOut(true);
        }
        return threadPool;
    }

    @Terminator
    public static synchronized void shutDownThreadPool() {
        if (threadPool != null) {
            threadPool.shutdownNow();
            threadPool = null;
        }
    }

    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="recurrencePeriod is set in onResume, not deserialization")
    public static final class Execution
    extends AbstractStepExecutionImpl
    implements Runnable,
    ExecutionRemotable {
        private static final long MIN_RECURRENCE_PERIOD = 250L;
        private static final long MAX_RECURRENCE_PERIOD = 15000L;
        private static final float RECURRENCE_PERIOD_BACKOFF = 1.2f;
        private transient TaskListener newlineSafeTaskListener;
        private final transient DurableTaskStep step;
        private transient FilePath ws;
        private transient long recurrencePeriod;
        private volatile transient ScheduledFuture<?> task;
        private volatile transient ScheduledFuture<?> stopTask;
        private Controller controller;
        public String node;
        private String remote;
        private boolean returnStdout;
        private boolean returnStatus;
        private boolean watching;
        private transient boolean awaitingAsynchExit;
        private volatile transient Throwable causeOfStoppage;
        private transient long removedNodeDiscovered;
        private static final long serialVersionUID = 1L;

        Execution(StepContext context, DurableTaskStep step) {
            super(context);
            this.step = step;
        }

        public boolean start() throws Exception {
            this.returnStdout = this.step.returnStdout;
            this.returnStatus = this.step.returnStatus;
            StepContext context = this.getContext();
            this.ws = (FilePath)context.get(FilePath.class);
            if (this.ws == null) {
                throw new AbortException("No workspace currently accessible");
            }
            this.node = FilePathUtils.getNodeName((FilePath)this.ws);
            DurableTask durableTask = this.step.task();
            if (this.returnStdout) {
                durableTask.captureOutput();
            }
            TaskListener listener = this.listener();
            if (this.step.encoding != null) {
                durableTask.charset(Charset.forName(this.step.encoding));
            } else {
                durableTask.defaultCharset();
            }
            Launcher launcher = (Launcher)context.get(Launcher.class);
            launcher.prepareFilterRules((Run)context.get(Run.class), (EnvVarsFilterableBuilder)this.step);
            LOGGER.log(Level.FINE, "launching task against {0} using {1}", new Object[]{this.ws.getChannel(), launcher});
            try {
                this.controller = durableTask.launch((EnvVars)context.get(EnvVars.class), this.ws, launcher, listener);
                LOGGER.log(Level.FINE, "launched task");
            }
            catch (Exception x) {
                LOGGER.log(Level.FINE, "failed to launch task", x);
                throw x;
            }
            this.remote = this.ws.getRemote();
            if (USE_WATCHING) {
                try {
                    this.controller.watch(this.ws, (Handler)new HandlerImpl(this, this.ws, listener), listener);
                    this.watching = true;
                }
                catch (UnsupportedOperationException x) {
                    LOGGER.log(Level.WARNING, null, x);
                }
            }
            this.setupTimer(this.watching ? WATCHING_RECURRENCE_PERIOD : 250L);
            return false;
        }

        @CheckForNull
        private FilePath getWorkspace() throws IOException, InterruptedException {
            boolean directory;
            if (this.ws == null) {
                this.ws = FilePathUtils.find((String)this.node, (String)this.remote);
                if (this.ws == null) {
                    Node agent;
                    Jenkins j = Jenkins.getInstanceOrNull();
                    if (!(this.node.isEmpty() || j == null || (agent = j.getNode(this.node)) != null && agent.getChannel() != null)) {
                        this.offline(null);
                        return null;
                    }
                    this.removedNodeDiscovered = 0L;
                    LOGGER.log(Level.FINE, "Jenkins is not running, no such node {0}, or it is offline", this.node);
                    return null;
                }
                if (this.removedNodeDiscovered != 0L) {
                    this.removedNodeDiscovered = 0L;
                    this.listener().getLogger().println(this.node + " is back online");
                }
                if (this.watching) {
                    try {
                        this.controller.watch(this.ws, (Handler)new HandlerImpl(this, this.ws, this.listener()), this.listener());
                        this.recurrencePeriod = WATCHING_RECURRENCE_PERIOD;
                    }
                    catch (UnsupportedOperationException x) {
                        this.getContext().onFailure((Throwable)x);
                    }
                    catch (Exception x) {
                        this.getWorkspaceProblem(x);
                        return null;
                    }
                }
            }
            try (Timeout timeout = Timeout.limit((long)REMOTE_TIMEOUT, (TimeUnit)TimeUnit.SECONDS);){
                directory = this.ws.isDirectory();
            }
            catch (Exception x) {
                this.getWorkspaceProblem(x);
                return null;
            }
            if (!directory) {
                throw new AbortException("missing workspace " + this.remote + " on " + this.node);
            }
            LOGGER.log(Level.FINER, "{0} seems to be online so using {1}", new Object[]{this.node, this.remote});
            return this.ws;
        }

        private void offline(@CheckForNull Throwable x) throws FlowInterruptedException {
            if (!ExecutorStepExecution.RemovedNodeCause.ENABLED) {
                return;
            }
            if (this.removedNodeDiscovered == 0L) {
                LOGGER.fine(() -> "discovered that " + this.node + " has been removed/offline");
                this.removedNodeDiscovered = System.nanoTime();
                this.listener().getLogger().println(this.node + " seems to be removed or offline " + (String)(x != null ? "(" + String.valueOf(x) + ")" : "") + "; will wait for " + Util.getTimeSpanString((long)ExecutorStepExecution.TIMEOUT_WAITING_FOR_NODE_MILLIS) + " for it to come back online");
            } else if (System.nanoTime() - this.removedNodeDiscovered < TimeUnit.MILLISECONDS.toNanos(ExecutorStepExecution.TIMEOUT_WAITING_FOR_NODE_MILLIS)) {
                LOGGER.fine(() -> "rediscovering that " + this.node + " has been removed/offline");
            } else {
                LOGGER.fine(() -> "rediscovering that " + this.node + " has been removed/offline and timeout has expired");
                this.listener().getLogger().println(this.node + " has been removed or offline for " + Util.getTimeSpanString((long)ExecutorStepExecution.TIMEOUT_WAITING_FOR_NODE_MILLIS) + "; assuming it is not coming back, and terminating shell step");
                throw new FlowInterruptedException(Result.ABORTED, false, new CauseOfInterruption[]{new ExecutorStepExecution.RemovedNodeTimeoutCause()});
            }
        }

        private void getWorkspaceProblem(Exception x) throws FlowInterruptedException {
            LOGGER.log(Level.FINE, this.node + " is evidently offline now", x);
            this.ws = null;
            this.recurrencePeriod = 250L;
            this.offline(x);
        }

        @NonNull
        private synchronized TaskListener listener() {
            if (this.newlineSafeTaskListener == null) {
                this.newlineSafeTaskListener = new NewlineSafeTaskListener(this._listener());
            }
            return this.newlineSafeTaskListener;
        }

        @NonNull
        private TaskListener _listener() {
            TaskListener l;
            StepContext context = this.getContext();
            try {
                l = (TaskListener)context.get(TaskListener.class);
                if (l != null) {
                    LOGGER.log(Level.FINEST, "JENKINS-34021: DurableTaskStep.Execution.listener present in {0}", context);
                } else {
                    LOGGER.log(Level.WARNING, "JENKINS-34021: TaskListener not available upon request in {0}", context);
                    l = TaskListener.NULL;
                }
            }
            catch (Exception x) {
                LOGGER.log(Level.FINE, "JENKINS-34021: could not get TaskListener in " + String.valueOf(context), x);
                l = TaskListener.NULL;
                this.recurrencePeriod = 0L;
            }
            return l;
        }

        @NonNull
        private Launcher launcher() throws IOException, InterruptedException {
            StepContext context = this.getContext();
            Launcher l = (Launcher)context.get(Launcher.class);
            if (l == null) {
                throw new IOException("JENKINS-37486: Launcher not present in " + String.valueOf(context));
            }
            return l;
        }

        public void stop(@NonNull Throwable cause) throws Exception {
            this.causeOfStoppage = cause;
            FilePath workspace = this.getWorkspace();
            if (workspace != null) {
                this.listener().getLogger().println("Sending interrupt signal to process");
                LOGGER.log(Level.FINE, "stopping process", cause);
                this.stopTask = Timer.get().schedule(() -> {
                    this.stopTask = null;
                    if (this.recurrencePeriod > 0L) {
                        this.recurrencePeriod = 0L;
                        this.listener().getLogger().println("After " + REMOTE_TIMEOUT + "s process did not stop");
                        this.getContext().onFailure(cause);
                        try {
                            FilePath taskWorkspace = this.getWorkspace();
                            if (taskWorkspace != null) {
                                this.controller.cleanup(taskWorkspace);
                            }
                        }
                        catch (IOException | InterruptedException x) {
                            Functions.printStackTrace((Throwable)x, (PrintStream)this.listener().getLogger());
                        }
                    }
                }, REMOTE_TIMEOUT, TimeUnit.SECONDS);
                this.controller.stop(workspace, this.launcher());
            } else {
                this.listener().getLogger().println("Could not connect to " + this.node + " to send interrupt signal to process");
                this.recurrencePeriod = 0L;
                super.stop(cause);
            }
        }

        public String getStatus() {
            if (this.controller == null) {
                return "not yet started";
            }
            StringBuilder b = new StringBuilder();
            try (Timeout timeout = Timeout.limit((long)2L, (TimeUnit)TimeUnit.SECONDS);){
                FilePath workspace = this.getWorkspace();
                if (workspace != null) {
                    b.append(this.controller.getDiagnostics(workspace, this.launcher()));
                } else {
                    b.append("waiting to reconnect to ").append(this.remote).append(" on ").append(this.node);
                }
            }
            catch (IOException | InterruptedException x) {
                b.append("failed to look up workspace ").append(this.remote).append(" on ").append(this.node).append(": ").append(x);
            }
            b.append("; recurrence period: ").append(this.recurrencePeriod).append("ms");
            ScheduledFuture<?> t = this.task;
            if (t != null) {
                b.append("; check task scheduled; cancelled? ").append(t.isCancelled()).append(" done? ").append(t.isDone()).append(" delay ").append(t.getDelay(TimeUnit.MILLISECONDS)).append("ms");
            }
            if ((t = this.stopTask) != null) {
                b.append("; stop task scheduled; cancelled? ").append(t.isCancelled()).append(" done? ").append(t.isDone()).append(" delay ").append(t.getDelay(TimeUnit.MILLISECONDS)).append("ms");
            }
            return b.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.task = null;
            try (WithThreadName naming = new WithThreadName(": checking " + this.remote + " on " + this.node);){
                this.check();
            }
            catch (Exception x) {
                LOGGER.log(Level.WARNING, null, x);
            }
            finally {
                if (this.recurrencePeriod > 0L) {
                    this.task = DurableTaskStep.threadPool().schedule(this, this.recurrencePeriod, TimeUnit.MILLISECONDS);
                }
            }
        }

        @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="silly rule")
        private void check() {
            block28: {
                FilePath workspace;
                if (this.recurrencePeriod == 0L) {
                    return;
                }
                try {
                    workspace = this.getWorkspace();
                }
                catch (IOException | InterruptedException x) {
                    this.recurrencePeriod = 0L;
                    if (this.causeOfStoppage == null) {
                        this.getContext().onFailure((Throwable)x);
                    }
                    return;
                }
                if (workspace == null) {
                    this.recurrencePeriod = Math.min((long)((float)this.recurrencePeriod * 1.2f), 15000L);
                    return;
                }
                TaskListener listener = this.listener();
                try (Timeout timeout = Timeout.limit((long)REMOTE_TIMEOUT, (TimeUnit)TimeUnit.SECONDS);){
                    if (this.watching) {
                        Integer exitCode = this.controller.exitStatus(workspace, this.launcher(), listener);
                        if (exitCode == null) {
                            LOGGER.log(Level.FINE, "still running in {0} on {1}", new Object[]{this.remote, this.node});
                        } else if (this.recurrencePeriod == 0L) {
                            LOGGER.fine(() -> "late check in " + this.remote + " on " + this.node + " ignored");
                        } else if (this.awaitingAsynchExit) {
                            this.recurrencePeriod = 0L;
                            listener.getLogger().println("script apparently exited with code " + exitCode + " but asynchronous notification was lost");
                            this.handleExit(exitCode, () -> this.controller.getOutput(workspace, this.launcher()));
                        } else {
                            LOGGER.log(Level.FINE, "exited with {0} in {1} on {2}; expect asynchronous exit soon", new Object[]{exitCode, this.remote, this.node});
                            this.awaitingAsynchExit = true;
                        }
                    } else {
                        if (this.controller.writeLog(workspace, (OutputStream)listener.getLogger())) {
                            this.getContext().saveState();
                            this.recurrencePeriod = 250L;
                        } else {
                            this.recurrencePeriod = Math.min((long)((float)this.recurrencePeriod * 1.2f), 15000L);
                        }
                        Integer exitCode = this.controller.exitStatus(workspace, this.launcher(), listener);
                        if (exitCode == null) {
                            LOGGER.log(Level.FINE, "still running in {0} on {1}", new Object[]{this.remote, this.node});
                        } else {
                            if (this.controller.writeLog(workspace, (OutputStream)listener.getLogger())) {
                                LOGGER.log(Level.FINE, "last-minute output in {0} on {1}", new Object[]{this.remote, this.node});
                            }
                            this.handleExit(exitCode, () -> this.controller.getOutput(workspace, this.launcher()));
                            this.recurrencePeriod = 0L;
                            this.controller.cleanup(workspace);
                        }
                    }
                }
                catch (Exception x) {
                    LOGGER.log(Level.FINE, "could not check " + String.valueOf(workspace), x);
                    this.ws = null;
                    try {
                        this.offline(x);
                    }
                    catch (FlowInterruptedException x2) {
                        if (this.causeOfStoppage != null) break block28;
                        this.getContext().onFailure((Throwable)x2);
                    }
                }
            }
        }

        @Override
        public void exited(int exitCode, byte[] output) throws Exception {
            if (((CheckForTerminating)((Object)ExtensionList.lookupSingleton(CheckForTerminating.class))).terminating) {
                throw new IllegalStateException("Will not handle process exits during shutdown; build should recheck when resumed");
            }
            this.recurrencePeriod = 0L;
            try {
                this.getContext().get(TaskListener.class);
            }
            catch (IOException | InterruptedException x) {
                LOGGER.log(Level.FINE, "asynchronous exit notification with code " + exitCode + " in " + this.remote + " on " + this.node + " ignored since step already seems dead", x);
                return;
            }
            LOGGER.log(Level.FINE, "asynchronous exit notification with code {0} in {1} on {2}", new Object[]{exitCode, this.remote, this.node});
            if (this.returnStdout && output == null) {
                this.getContext().onFailure((Throwable)new IllegalStateException("expected output but got none"));
                return;
            }
            if (!this.returnStdout && output != null) {
                this.getContext().onFailure((Throwable)new IllegalStateException("did not expect output but got some"));
                return;
            }
            this.handleExit(exitCode, () -> output);
        }

        private void handleExit(int exitCode, OutputSupplier output) throws IOException, InterruptedException {
            Throwable originalCause = this.causeOfStoppage;
            if (this.returnStatus && originalCause == null || exitCode == 0) {
                this.getContext().onSuccess(this.returnStatus ? Integer.valueOf(exitCode) : (this.returnStdout ? new String(output.produce(), StandardCharsets.UTF_8) : null));
            } else {
                if (this.returnStdout) {
                    this._listener().getLogger().write(output.produce());
                }
                if (originalCause != null) {
                    this._listener().getLogger().println("script returned exit code " + exitCode);
                    this.getContext().onFailure(originalCause);
                } else {
                    this.getContext().onFailure((Throwable)new AbortException("script returned exit code " + exitCode));
                }
            }
            this.listener().getLogger().close();
        }

        @Override
        public void problem(Exception x) {
            Functions.printStackTrace((Throwable)x, (PrintStream)this.listener().getLogger());
        }

        public void onResume() {
            this.ws = null;
            this.setupTimer(250L);
        }

        private void setupTimer(long initialRecurrencePeriod) {
            this.recurrencePeriod = initialRecurrencePeriod;
            this.task = DurableTaskStep.threadPool().schedule(this, this.recurrencePeriod, TimeUnit.MILLISECONDS);
        }

        private static final class NewlineSafeTaskListener
        extends OutputStreamTaskListener.Default {
            private static final long serialVersionUID = 1L;
            private final TaskListener delegate;
            private transient OutputStream out;

            NewlineSafeTaskListener(TaskListener delegate) {
                this.delegate = delegate;
            }

            public synchronized OutputStream getOutputStream() {
                if (this.out == null) {
                    this.out = new FilterOutputStream(OutputStreamTaskListener.getOutputStream((TaskListener)this.delegate)){
                        boolean nl;
                        {
                            super(out);
                            this.nl = true;
                        }

                        @Override
                        public void write(int b) throws IOException {
                            super.write(b);
                            this.nl = b == 10;
                        }

                        @Override
                        public void write(@NonNull byte[] b, int off, int len) throws IOException {
                            super.write(b, off, len);
                            if (len > 0) {
                                this.nl = b[off + len - 1] == 10;
                            }
                        }

                        @Override
                        public void close() throws IOException {
                            LOGGER.log(Level.FINE, "calling close with nl={0}", this.nl);
                            if (!this.nl) {
                                super.write(10);
                            }
                            this.flush();
                        }

                        public String toString() {
                            return "NewlineSafeTaskListener.output[" + String.valueOf(this.out) + "]";
                        }
                    };
                }
                return this.out;
            }
        }

        @FunctionalInterface
        private static interface OutputSupplier {
            public byte[] produce() throws IOException, InterruptedException;
        }

        @Extension
        public static final class CheckForTerminating
        extends ItemListener {
            boolean terminating;

            public void onBeforeShutdown() {
                this.terminating = true;
            }
        }
    }

    @Extension
    public static final class AgentReconnectionListener
    extends ComputerListener {
        public void onOffline(Computer c, OfflineCause cause) {
            if (Jenkins.get().isTerminating()) {
                LOGGER.fine(() -> "Skipping check on " + c.getName() + " during shutdown");
                return;
            }
            this.check(c);
        }

        public void onOnline(Computer c, TaskListener listener) throws IOException, InterruptedException {
            if (!FlowExecutionList.get().isResumptionComplete()) {
                LOGGER.fine(() -> "Skipping check on " + c.getName() + " before builds are ready");
                return;
            }
            this.check(c);
        }

        private void check(Computer c) {
            String name = c.getName();
            StepExecution.acceptAll(Execution.class, exec -> {
                if (exec.watching && exec.node.equals(name)) {
                    LOGGER.fine(() -> "Online/offline event on " + name + ", checking current status of " + exec.remote + " soon");
                    DurableTaskStep.threadPool().schedule(exec::check, 15L, TimeUnit.SECONDS);
                }
            });
        }
    }

    private static class HandlerImpl
    extends Handler {
        private static final long serialVersionUID = 1L;
        private final ExecutionRemotable execution;
        private final TaskListener listener;

        HandlerImpl(Execution execution, FilePath workspace, TaskListener listener) {
            this.execution = (ExecutionRemotable)workspace.getChannel().export(ExecutionRemotable.class, (Object)execution);
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void output(@NonNull InputStream stream) throws Exception {
            PrintStream ps = this.listener.getLogger();
            OutputStream os = OutputStreamTaskListener.getOutputStream((TaskListener)this.listener);
            try {
                PrintStream printStream = ps;
                synchronized (printStream) {
                    IOUtils.copy((InputStream)stream, (OutputStream)os);
                }
                LOGGER.finest(() -> "print to " + String.valueOf(os) + " succeeded");
            }
            catch (ChannelClosedException x) {
                LOGGER.log(Level.FINE, null, x);
                throw x;
            }
            catch (Exception x) {
                LOGGER.log(Level.FINE, null, x);
                try {
                    this.execution.problem(x);
                }
                catch (Exception x2) {
                    LOGGER.log(Level.FINE, null, x2);
                    throw x;
                }
            }
        }

        public void exited(int code, byte[] output) throws Exception {
            this.listener.getLogger().close();
            this.execution.exited(code, output);
        }
    }

    static interface ExecutionRemotable {
        public void exited(int var1, byte[] var2) throws Exception;

        public void problem(Exception var1);
    }

    public static abstract class DurableTaskStepDescriptor
    extends StepDescriptor {
        @Restricted(value={DoNotUse.class})
        public FormValidation doCheckEncoding(@QueryParameter String encoding) {
            if (encoding.isEmpty()) {
                return FormValidation.ok();
            }
            try {
                Charset.forName(encoding);
            }
            catch (Exception x) {
                return FormValidation.error((Throwable)x, (String)"Unrecognized encoding");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckReturnStatus(@QueryParameter boolean returnStdout, @QueryParameter boolean returnStatus) {
            if (returnStdout && returnStatus) {
                return FormValidation.error((String)"You may not select both returnStdout and returnStatus.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckLabel(@QueryParameter String label) {
            if (label != null && label.length() > 100) {
                return FormValidation.error((String)"Label size exceeds maximum of 100 characters.");
            }
            return FormValidation.ok();
        }

        public final Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(FilePath.class, EnvVars.class, Launcher.class, TaskListener.class);
        }
    }
}

