/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import com.cloudbees.groovy.cps.Continuable;
import com.cloudbees.groovy.cps.impl.CpsCallableInvocation;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import groovy.lang.Closure;
import hudson.Main;
import hudson.model.TaskListener;
import hudson.remoting.SingleLaneExecutorService;
import hudson.security.ACL;
import hudson.util.DaemonThreadFactory;
import hudson.util.ExceptionCatchingThreadFactory;
import hudson.util.NamingThreadFactory;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.security.ImpersonatingExecutorService;
import jenkins.util.ContextResettingExecutorService;
import jenkins.util.ErrorLoggingExecutorService;
import jenkins.util.InterceptingExecutorService;
import org.codehaus.groovy.runtime.GroovyCategorySupport;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.CpsThread;
import org.jenkinsci.plugins.workflow.cps.CpsThreadGroup;
import org.jenkinsci.plugins.workflow.cps.persistence.IteratorHack;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.springframework.security.core.Authentication;

class CpsVmExecutorService
extends InterceptingExecutorService {
    private static final List<Class> CATEGORIES = ImmutableList.builder().addAll((Iterable)Continuable.categories).add(IteratorHack.class).build();
    private static final ExecutorService threadPool = new ContextResettingExecutorService((ExecutorService)new ImpersonatingExecutorService((ExecutorService)new ErrorLoggingExecutorService(Executors.newCachedThreadPool(CpsVmExecutorService.categoryThreadFactory((ThreadFactory)new ExceptionCatchingThreadFactory((ThreadFactory)new NamingThreadFactory((ThreadFactory)new DaemonThreadFactory(), "CpsVmExecutorService"))))), ACL.SYSTEM2));
    private CpsThreadGroup cpsThreadGroup;
    static boolean FAIL_ON_MISMATCH = Main.isUnitTest;
    static ThreadLocal<CpsThreadGroup> CURRENT = new ThreadLocal();
    static ThreadLocal<ClassLoader> ORIGINAL_CONTEXT_CLASS_LOADER = new ThreadLocal();
    private static final Logger LOGGER = Logger.getLogger(CpsVmExecutorService.class.getName());

    private static ThreadFactory categoryThreadFactory(ThreadFactory core) {
        return r -> core.newThread(() -> {
            LOGGER.fine("spawning new thread");
            GroovyCategorySupport.use(CATEGORIES, (Closure)new Closure<Void>(null){

                public Void call() {
                    r.run();
                    return null;
                }
            });
        });
    }

    CpsVmExecutorService(CpsThreadGroup cpsThreadGroup) {
        super((ExecutorService)new SingleLaneExecutorService(threadPool));
        this.cpsThreadGroup = cpsThreadGroup;
    }

    protected Runnable wrap(Runnable r) {
        CpsFlowExecution.Timing timing = this.cpsThreadGroup.getExecution().time(CpsFlowExecution.TimingKind.runQueue);
        return () -> {
            timing.close();
            ThreadContext context = this.setUp();
            try {
                r.run();
            }
            catch (Throwable t) {
                this.reportProblem(t);
                throw t;
            }
            finally {
                this.tearDown(context);
            }
        };
    }

    private void reportProblem(Throwable t) {
        if (this.cpsThreadGroup.getExecution().isComplete()) {
            LOGGER.log(Level.FINE, t, () -> "Unexpected exception in CPS VM thread and execution is already complete: " + String.valueOf((Object)this.cpsThreadGroup.getExecution()));
            return;
        }
        LOGGER.log(Level.WARNING, "Unexpected exception in CPS VM thread: " + String.valueOf((Object)this.cpsThreadGroup.getExecution()), t);
        for (CpsThread thread : this.cpsThreadGroup.getThreads()) {
            StepExecution se = thread.getStep();
            if (se == null) continue;
            try {
                se.stop(t);
                TaskListener listener = (TaskListener)se.getContext().get(TaskListener.class);
                FlowNode node = (FlowNode)se.getContext().get(FlowNode.class);
                if (listener == null || node == null) continue;
                listener.getLogger().println("Terminating " + node.getDisplayFunctionName() + " (id: " + node.getId() + ")");
            }
            catch (Throwable e) {
                t.addSuppressed(e);
            }
        }
        this.cpsThreadGroup.getExecution().croak(t);
        this.shutdown();
    }

    protected <V> Callable<V> wrap(Callable<V> r) {
        CpsFlowExecution.Timing timing = this.cpsThreadGroup.getExecution().time(CpsFlowExecution.TimingKind.runQueue);
        return () -> {
            timing.close();
            ThreadContext context = this.setUp();
            try {
                Object v = r.call();
                return v;
            }
            catch (Throwable t) {
                this.reportProblem(t);
                throw t;
            }
            finally {
                this.tearDown(context);
            }
        };
    }

    private ThreadContext setUp() {
        CpsFlowExecution execution = this.cpsThreadGroup.getExecution();
        ACL.impersonate2((Authentication)execution.getAuthentication2());
        CURRENT.set(this.cpsThreadGroup);
        this.cpsThreadGroup.busy = true;
        Thread t = Thread.currentThread();
        ThreadContext context = new ThreadContext(t, execution);
        t.setName("Running " + String.valueOf((Object)execution));
        assert (this.cpsThreadGroup.getExecution() != null);
        if (this.cpsThreadGroup.getExecution().getShell() != null) {
            assert (this.cpsThreadGroup.getExecution().getShell().getClassLoader() != null);
            t.setContextClassLoader((ClassLoader)this.cpsThreadGroup.getExecution().getShell().getClassLoader());
        }
        CpsCallableInvocation.registerMismatchHandler(this::handleMismatch);
        return context;
    }

    private void handleMismatch(Object expectedReceiver, String expectedMethodName, Object actualReceiver, String actualMethodName) {
        Class<?> receiverClass = expectedReceiver.getClass();
        if (Jenkins.get().getPluginManager().whichPlugin(receiverClass) != null) {
            return;
        }
        String mismatchMessage = CpsVmExecutorService.mismatchMessage(CpsVmExecutorService.className(expectedReceiver), expectedMethodName, CpsVmExecutorService.className(actualReceiver), actualMethodName);
        if (FAIL_ON_MISMATCH) {
            throw new IllegalStateException(mismatchMessage);
        }
        try {
            this.cpsThreadGroup.getExecution().getOwner().getListener().getLogger().println(mismatchMessage);
        }
        catch (IOException x) {
            LOGGER.log(Level.FINE, null, x);
        }
    }

    @CheckForNull
    private static String className(@CheckForNull Object receiver) {
        if (receiver == null) {
            return null;
        }
        if (receiver instanceof Class) {
            return ((Class)receiver).getName();
        }
        return receiver.getClass().getName();
    }

    static String mismatchMessage(@CheckForNull String expectedReceiverClassName, String expectedMethodName, @CheckForNull String actualReceiverClassName, String actualMethodName) {
        StringBuilder b = new StringBuilder("expected to call ");
        if (expectedReceiverClassName != null) {
            b.append(expectedReceiverClassName).append('.');
        }
        b.append(expectedMethodName).append(" but wound up catching ");
        if (actualReceiverClassName != null) {
            b.append(actualReceiverClassName).append('.');
        }
        b.append(actualMethodName);
        return b.append("; see: https://jenkins.io/redirect/pipeline-cps-method-mismatches/").toString();
    }

    private void tearDown(ThreadContext context) {
        CURRENT.set(null);
        this.cpsThreadGroup.busy = false;
        context.restore();
        CpsFlowExecution execution = this.cpsThreadGroup.getExecution();
        if (this.isShutdown() && !this.cpsThreadGroup.getThreads().iterator().hasNext()) {
            execution.logTimings();
        }
        CpsCallableInvocation.registerMismatchHandler(null);
    }

    private static class ThreadContext {
        final Thread thread;
        final String name;
        final ClassLoader classLoader;
        final CpsFlowExecution.Timing timing;

        ThreadContext(Thread thread, CpsFlowExecution execution) {
            this.thread = thread;
            this.name = thread.getName();
            this.classLoader = thread.getContextClassLoader();
            ORIGINAL_CONTEXT_CLASS_LOADER.set(this.classLoader);
            this.timing = execution.time(CpsFlowExecution.TimingKind.run);
        }

        void restore() {
            this.thread.setName(this.name);
            this.thread.setContextClassLoader(this.classLoader);
            ORIGINAL_CONTEXT_CLASS_LOADER.set(null);
            this.timing.close();
        }
    }
}

