/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps.replay;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.InvisibleAction;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.model.Run;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.CpsFlowFactoryAction2;
import org.jenkinsci.plugins.workflow.cps.replay.OriginalLoadedScripts;
import org.jenkinsci.plugins.workflow.flow.DurabilityHintProvider;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDurabilityHint;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.flow.GlobalDefaultFlowDurabilityLevel;

class ReplayFlowFactoryAction
extends InvisibleAction
implements CpsFlowFactoryAction2,
Queue.QueueAction {
    private String replacementMainScript;
    private final Map<String, String> replacementLoadedScripts;
    private final boolean sandbox;

    ReplayFlowFactoryAction(@NonNull String replacementMainScript, @NonNull Map<String, String> replacementLoadedScripts, boolean sandbox) {
        this.replacementMainScript = replacementMainScript;
        this.replacementLoadedScripts = new HashMap<String, String>(replacementLoadedScripts);
        this.sandbox = sandbox;
    }

    @Override
    public CpsFlowExecution create(FlowDefinition def, FlowExecutionOwner owner, List<? extends Action> actions) throws IOException {
        String script = this.replacementMainScript;
        this.replacementMainScript = null;
        Queue.Executable exec = owner.getExecutable();
        FlowDurabilityHint hint = exec instanceof Run ? DurabilityHintProvider.suggestedFor((Item)((Run)exec).getParent()) : GlobalDefaultFlowDurabilityLevel.getDefaultDurabilityHint();
        return new CpsFlowExecution(script, this.sandbox, owner, hint);
    }

    public boolean shouldSchedule(List<Action> actions) {
        return true;
    }

    Set<String> replaceableScripts() {
        return Set.copyOf(this.replacementLoadedScripts.keySet());
    }

    @CheckForNull
    String replace(String clazz) {
        return this.replacementLoadedScripts.remove(clazz);
    }

    @Extension
    public static class StoredLoadedScripts
    extends OriginalLoadedScripts {
        @Override
        public Map<String, String> loadScripts(CpsFlowExecution execution) {
            return execution.getLoadedScripts();
        }
    }
}

