/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps.nodes;

import java.io.ObjectStreamException;
import java.util.Collections;
import org.jenkinsci.plugins.workflow.actions.BodyInvocationAction;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.nodes.StepAtomNode;
import org.jenkinsci.plugins.workflow.cps.nodes.StepDescriptorCache;
import org.jenkinsci.plugins.workflow.cps.nodes.StepNode;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.BlockStartNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;

public class StepStartNode
extends BlockStartNode
implements StepNode {
    private String descriptorId;
    private transient StepDescriptor descriptor;

    public StepStartNode(CpsFlowExecution exec, StepDescriptor d, FlowNode parent) {
        super((FlowExecution)exec, exec.iotaStr(), new FlowNode[]{parent});
        this.descriptor = d;
        this.descriptorId = d != null ? d.getId().intern() : null;
        this.setActions(Collections.emptyList());
    }

    public StepDescriptor getDescriptor() {
        if (this.descriptor == null && this.descriptorId != null) {
            this.descriptor = StepDescriptorCache.getPublicCache().getDescriptor(this.descriptorId);
        }
        return this.descriptor;
    }

    protected Object readResolve() throws ObjectStreamException {
        if (this.descriptorId != null) {
            this.descriptorId = this.descriptorId.intern();
        }
        return super.readResolve();
    }

    protected String getTypeDisplayName() {
        return this.getStepName() + (this.isBody() ? " : Body" : "") + " : Start";
    }

    protected String getTypeFunctionName() {
        if (this.isBody()) {
            return "{";
        }
        String fn = StepAtomNode.effectiveFunctionName(this);
        return fn != null ? fn : this.descriptorId;
    }

    public boolean isBody() {
        return this.getAction(BodyInvocationAction.class) != null;
    }

    public String getStepName() {
        String n = StepAtomNode.effectiveDisplayName(this);
        return n != null ? n : this.descriptorId;
    }
}

