/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import com.cloudbees.groovy.cps.Continuable;
import com.cloudbees.groovy.cps.Outcome;
import groovy.lang.GroovyShell;
import hudson.MarkupText;
import hudson.console.ConsoleAnnotator;
import hudson.console.ConsoleNote;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.scriptsecurity.sandbox.Whitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.GroovySandbox;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.CpsThread;
import org.jenkinsci.plugins.workflow.cps.CpsWhitelist;
import org.jenkinsci.plugins.workflow.cps.GroovyClassLoaderWhitelist;

class SandboxContinuable
extends Continuable {
    private final CpsThread thread;
    private static final Logger LOGGER = Logger.getLogger(SandboxContinuable.class.getName());

    SandboxContinuable(Continuable src, CpsThread thread) {
        super(src);
        this.thread = thread;
    }

    public Outcome run0(Outcome cn) {
        CpsFlowExecution e = this.thread.group.getExecution();
        if (e == null) {
            throw new IllegalStateException("JENKINS-50407: no loaded execution");
        }
        GroovyShell shell = e.getShell();
        if (shell == null) {
            throw new IllegalStateException("JENKINS-50407: no loaded shell in " + String.valueOf((Object)e));
        }
        GroovyShell trustedShell = e.getTrustedShell();
        if (trustedShell == null) {
            throw new IllegalStateException("JENKINS-50407: no loaded trustedShell in " + String.valueOf((Object)e));
        }
        GroovySandbox sandbox = new GroovySandbox();
        try {
            sandbox.withTaskListener(e.getOwner().getListener());
        }
        catch (IOException x) {
            LOGGER.log(Level.WARNING, null, x);
        }
        sandbox.withWhitelist((Whitelist)new GroovyClassLoaderWhitelist(CpsWhitelist.get(), trustedShell.getClassLoader(), shell.getClassLoader()));
        try (GroovySandbox.Scope scope = sandbox.enter();){
            Outcome outcome = SandboxContinuable.super.run0(cn);
            return outcome;
        }
    }

    @Deprecated
    private static final class ScriptApprovalNote
    extends ConsoleNote {
        private int length;

        private ScriptApprovalNote() {
        }

        public ConsoleAnnotator annotate(Object context, MarkupText text, int charPos) {
            return null;
        }
    }
}

