/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import groovy.lang.GroovyClassLoader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import org.jenkinsci.plugins.scriptsecurity.sandbox.Whitelist;

class GroovyClassLoaderWhitelist
extends Whitelist {
    private final Collection<ClassLoader> scriptLoaders;
    private final Whitelist delegate;

    GroovyClassLoaderWhitelist(Whitelist delegate, GroovyClassLoader ... scriptLoaders) {
        this.scriptLoaders = Arrays.asList(scriptLoaders);
        this.delegate = delegate;
    }

    private boolean permits(Class<?> declaringClass) {
        ClassLoader cl = declaringClass.getClassLoader();
        if (cl instanceof GroovyClassLoader.InnerLoader) {
            return this.scriptLoaders.contains(cl.getParent());
        }
        return this.scriptLoaders.contains(cl);
    }

    public boolean permitsMethod(Method method, Object receiver, Object[] args) {
        return this.permits(method.getDeclaringClass()) && !GroovyClassLoaderWhitelist.isIllegalSyntheticMethod(method) || this.delegate.permitsMethod(method, receiver, args);
    }

    public boolean permitsConstructor(Constructor<?> constructor, Object[] args) {
        return this.permits(constructor.getDeclaringClass()) && !GroovyClassLoaderWhitelist.isIllegalSyntheticConstructor(constructor) || this.delegate.permitsConstructor(constructor, args);
    }

    public boolean permitsStaticMethod(Method method, Object[] args) {
        return this.permits(method.getDeclaringClass()) && !GroovyClassLoaderWhitelist.isIllegalSyntheticMethod(method) || this.delegate.permitsStaticMethod(method, args);
    }

    public boolean permitsFieldGet(Field field, Object receiver) {
        return this.permits(field.getDeclaringClass()) && !GroovyClassLoaderWhitelist.isIllegalSyntheticField(field) || this.delegate.permitsFieldGet(field, receiver);
    }

    public boolean permitsFieldSet(Field field, Object receiver, Object value) {
        return this.permits(field.getDeclaringClass()) && !GroovyClassLoaderWhitelist.isIllegalSyntheticField(field) || this.delegate.permitsFieldSet(field, receiver, value);
    }

    public boolean permitsStaticFieldGet(Field field) {
        return this.permits(field.getDeclaringClass()) && !GroovyClassLoaderWhitelist.isIllegalSyntheticField(field) || this.delegate.permitsStaticFieldGet(field);
    }

    public boolean permitsStaticFieldSet(Field field, Object value) {
        return this.permits(field.getDeclaringClass()) && !GroovyClassLoaderWhitelist.isIllegalSyntheticField(field) || this.delegate.permitsStaticFieldSet(field, value);
    }

    public String toString() {
        return super.toString() + "[" + String.valueOf(this.delegate) + "]";
    }

    private static boolean isIllegalSyntheticField(Field field) {
        if (!field.isSynthetic()) {
            return false;
        }
        Class<?> declaringClass = field.getDeclaringClass();
        Class<?> enclosingClass = declaringClass.getEnclosingClass();
        if (field.getType() == enclosingClass && field.getName().startsWith("this$")) {
            return false;
        }
        return !declaringClass.isEnum() || !Modifier.isStatic(field.getModifiers()) || !field.getName().equals("$VALUES");
    }

    private static boolean isIllegalSyntheticMethod(Method method) {
        if (!method.isSynthetic()) {
            return false;
        }
        return !Modifier.isStatic(method.getModifiers()) || !method.getDeclaringClass().isEnum() || !method.getName().equals("$INIT");
    }

    private static boolean isIllegalSyntheticConstructor(Constructor constructor) {
        if (!constructor.isSynthetic()) {
            return false;
        }
        Class declaringClass = constructor.getDeclaringClass();
        Class<?> enclosingClass = declaringClass.getEnclosingClass();
        return enclosingClass == null || constructor.getParameters().length <= 0 || constructor.getParameterTypes()[0] != enclosingClass;
    }
}

