/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import com.cloudbees.jenkins.support.api.Component;
import com.cloudbees.jenkins.support.api.Container;
import com.cloudbees.jenkins.support.api.Content;
import com.google.common.util.concurrent.FutureCallback;
import hudson.Extension;
import hudson.Functions;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.security.Permission;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.CpsThreadDump;
import org.jenkinsci.plugins.workflow.cps.CpsThreadGroup;
import org.jenkinsci.plugins.workflow.cps.RunningFlowAction;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionList;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.WebMethod;

public final class CpsThreadDumpAction
extends RunningFlowAction {
    private final CpsFlowExecution execution;

    CpsThreadDumpAction(CpsFlowExecution execution) {
        this.execution = execution;
    }

    public String getIconFileName() {
        return "symbol-analytics";
    }

    public String getDisplayName() {
        return "Thread Dump";
    }

    public String getUrlName() {
        return "threadDump";
    }

    public String getParentUrl() throws IOException {
        return this.execution.getOwner().getUrl();
    }

    CpsThreadDump threadDumpSynchronous() throws InterruptedException, ExecutionException {
        this.execution.waitForSuspension();
        return this.execution.getThreadDump();
    }

    public CpsThreadDump getThreadDump() {
        return this.execution.getThreadDump();
    }

    @WebMethod(name={"program.xml"})
    public void doProgramDotXml(StaplerRequest2 req, StaplerResponse2 rsp) throws Exception {
        String xml;
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        final CompletableFuture f = new CompletableFuture();
        this.execution.runInCpsVmThread(new FutureCallback<CpsThreadGroup>(){

            public void onSuccess(CpsThreadGroup g) {
                try {
                    f.complete(g.asXml());
                }
                catch (Throwable t) {
                    f.completeExceptionally(t);
                }
            }

            public void onFailure(Throwable t) {
                f.completeExceptionally(t);
            }
        });
        try {
            xml = (String)f.get(1L, TimeUnit.MINUTES);
        }
        catch (Exception x) {
            HttpResponses.error((Throwable)x).generateResponse(req, rsp, (Object)this);
            return;
        }
        rsp.setContentType("text/xml;charset=UTF-8");
        PrintWriter pw = rsp.getWriter();
        pw.print(xml);
        pw.flush();
    }

    @Extension(optional=true)
    public static class PipelineThreadDump
    extends Component {
        public Set<Permission> getRequiredPermissions() {
            return Set.of(Jenkins.ADMINISTER);
        }

        public String getDisplayName() {
            return "Running Pipeline builds";
        }

        public Component.ComponentCategory getCategory() {
            return Component.ComponentCategory.BUILDS;
        }

        public void addContents(Container container) {
            container.add(new Content("nodes/master/pipeline-running-builds.txt"){

                public void writeTo(OutputStream outputStream) {
                    PrintWriter pw = new PrintWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
                    for (FlowExecution flow : FlowExecutionList.get()) {
                        Queue.Executable ownerExec;
                        if (!(flow instanceof CpsFlowExecution)) continue;
                        try {
                            ownerExec = flow.getOwner().getExecutable();
                        }
                        catch (IOException e) {
                            pw.println("No data available for " + String.valueOf(flow));
                            Functions.printStackTrace((Throwable)e, (PrintWriter)pw);
                            pw.println();
                            continue;
                        }
                        pw.println("Build: " + String.valueOf(ownerExec));
                        if (ownerExec instanceof Run) {
                            Run run = (Run)ownerExec;
                            Instant started = Instant.ofEpochMilli(run.getStartTimeInMillis());
                            pw.println("Started: " + String.valueOf(started));
                            Duration duration = Duration.between(started, Instant.now());
                            pw.print("Duration: " + String.valueOf(duration));
                            if (duration.toDays() > 3L) {
                                pw.println(" (Running for more than 3 days!)");
                            } else {
                                pw.println();
                            }
                        }
                        CpsFlowExecution cpsFlow = (CpsFlowExecution)flow;
                        TreeMap<String, LongAdder> sortedTimings = new TreeMap<String, LongAdder>(cpsFlow.liveTimings);
                        pw.println("Timings:");
                        sortedTimings.forEach((k, v) -> pw.println("  " + k + "\t" + v.longValue() / 1000L / 1000L + "ms"));
                        pw.println("Active operations:");
                        long nanos = System.nanoTime();
                        Map sortedIncompleteTimings = new HashSet<CpsFlowExecution.Timing>(cpsFlow.liveIncompleteTimings).stream().collect(Collectors.groupingBy(t -> t.getKind().name(), TreeMap::new, Collectors.mapping(t -> new CountAndDuration(nanos - t.getStartNanos()), Collectors.reducing(CountAndDuration::new))));
                        sortedIncompleteTimings.forEach((k, optional) -> optional.ifPresent(cd -> pw.println("  " + k + "\t" + cd.count + "\t" + cd.duration / 1000L / 1000L + "ms")));
                        pw.println("Approximate graph size: " + cpsFlow.approximateNodeCount());
                        cpsFlow.getThreadDump().print(pw);
                        pw.println();
                    }
                    pw.flush();
                }
            });
        }

        private static class CountAndDuration {
            private final int count;
            private final long duration;

            CountAndDuration(long duration) {
                this.count = 1;
                this.duration = duration;
            }

            CountAndDuration(CountAndDuration a, CountAndDuration b) {
                this.count = a.count + b.count;
                this.duration = a.duration + b.duration;
            }
        }
    }
}

