/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import com.cloudbees.groovy.cps.Continuable;
import com.cloudbees.groovy.cps.Env;
import com.cloudbees.groovy.cps.Envs;
import com.cloudbees.groovy.cps.Outcome;
import com.cloudbees.groovy.cps.sandbox.Invoker;
import com.cloudbees.jenkins.support.api.Component;
import com.cloudbees.jenkins.support.api.Container;
import com.cloudbees.jenkins.support.api.Content;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import hudson.AbortException;
import hudson.BulkChange;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Functions;
import hudson.Util;
import hudson.init.Terminator;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.Saveable;
import hudson.model.User;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import hudson.util.Iterators;
import java.beans.Introspector;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jenkins.model.CauseOfInterruption;
import jenkins.model.Jenkins;
import jenkins.util.SystemProperties;
import net.jcip.annotations.GuardedBy;
import org.codehaus.groovy.GroovyBugError;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.marshalling.reflect.SerializableClassRegistry;
import org.jenkinsci.plugins.workflow.actions.ErrorAction;
import org.jenkinsci.plugins.workflow.cps.CpsGroovyShell;
import org.jenkinsci.plugins.workflow.cps.CpsGroovyShellFactory;
import org.jenkinsci.plugins.workflow.cps.CpsScript;
import org.jenkinsci.plugins.workflow.cps.CpsThread;
import org.jenkinsci.plugins.workflow.cps.CpsThreadDump;
import org.jenkinsci.plugins.workflow.cps.CpsThreadGroup;
import org.jenkinsci.plugins.workflow.cps.FlowHead;
import org.jenkinsci.plugins.workflow.cps.LoggingInvoker;
import org.jenkinsci.plugins.workflow.flow.BlockableResume;
import org.jenkinsci.plugins.workflow.flow.FlowDurabilityHint;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionList;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.flow.GraphListener;
import org.jenkinsci.plugins.workflow.graph.BlockStartNode;
import org.jenkinsci.plugins.workflow.graph.FlowEndNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graph.FlowStartNode;
import org.jenkinsci.plugins.workflow.graphanalysis.DepthFirstScanner;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.support.concurrent.Futures;
import org.jenkinsci.plugins.workflow.support.concurrent.WithThreadName;
import org.jenkinsci.plugins.workflow.support.pickles.serialization.RiverReader;
import org.jenkinsci.plugins.workflow.support.storage.BulkFlowNodeStorage;
import org.jenkinsci.plugins.workflow.support.storage.FlowNodeStorage;
import org.jenkinsci.plugins.workflow.support.storage.SimpleXStreamFlowNodeStorage;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class CpsFlowExecution
extends FlowExecution
implements BlockableResume {
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="non-final for modification via script console")
    public static boolean OPTIMIZE_STORAGE_UPON_COMPLETION = SystemProperties.getBoolean((String)(CpsFlowExecution.class.getName() + ".OPTIMIZE_STORAGE_UPON_COMPLETION"), (boolean)true);
    private final String script;
    Map<String, String> loadedScripts = new LinkedHashMap<String, String>();
    private final boolean sandbox;
    private transient FlowExecutionOwner owner;
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="TODO clean up")
    public volatile transient ListenableFuture<CpsThreadGroup> programPromise;
    private volatile transient Collection<ListenableFuture<?>> pickleFutures;
    transient TimingFlowNodeStorage storage;
    @CheckForNull
    private final String user;
    Boolean persistedClean = null;
    boolean resumeBlocked = false;
    private transient boolean pausedWhenLoaded;
    private String storageDir = null;
    @GuardedBy(value="this")
    Stack<BlockStartNode> startNodes = new Stack();
    private transient List<String> startNodesSerial;
    @GuardedBy(value="this")
    NavigableMap<Integer, FlowHead> heads = new TreeMap<Integer, FlowHead>();
    private transient Map<Integer, String> headsSerial;
    private final AtomicInteger iota = new AtomicInteger();
    private static final int ID_LOOKUP_TABLE_SIZE = 500;
    private static final String[] ID_LOOKUP_TABLE = new String[500];
    private transient List<GraphListener> listeners;
    private Result result = Result.SUCCESS;
    boolean done;
    private transient CpsGroovyShell shell;
    private transient CpsGroovyShell trusted;
    private transient Class<?> scriptClass;
    final transient List<Action> flowStartNodeActions = new ArrayList<Action>();
    @NonNull
    transient Map<String, LongAdder> liveTimings = new ConcurrentHashMap<String, LongAdder>();
    @NonNull
    transient Set<Timing> liveIncompleteTimings = ConcurrentHashMap.newKeySet();
    private Map<String, Long> timings;
    @NonNull
    private Set<String> internalCalls = ConcurrentHashMap.newKeySet();
    static final Logger TIMING_LOGGER;
    private static final Logger LOGGER;
    static final ThreadLocal<CpsFlowExecution> PROGRAM_STATE_SERIALIZATION;

    public boolean isResumeBlocked() {
        return this.resumeBlocked;
    }

    public void setResumeBlocked(boolean resumeBlocked) {
        if (this.resumeBlocked != resumeBlocked) {
            this.resumeBlocked = resumeBlocked;
        }
    }

    @Deprecated
    public CpsFlowExecution(String script, FlowExecutionOwner owner) throws IOException {
        this(script, false, owner);
    }

    public CpsFlowExecution(@NonNull String script, boolean sandbox, @NonNull FlowExecutionOwner owner, @CheckForNull FlowDurabilityHint durabilityHint) throws IOException {
        this.owner = owner;
        this.script = script;
        this.sandbox = sandbox;
        this.durabilityHint = durabilityHint;
        Authentication auth = Jenkins.getAuthentication2();
        this.user = auth.equals((Object)ACL.SYSTEM2) ? null : auth.getName();
        this.storage = this.createStorage();
        this.storage.setAvoidAtomicWrite(!this.getDurabilityHint().isAtomicWrite());
    }

    public CpsFlowExecution(String script, boolean sandbox, FlowExecutionOwner owner) throws IOException {
        this(script, sandbox, owner, null);
    }

    Timing time(TimingKind kind) {
        Timing timing = new Timing(kind);
        this.liveIncompleteTimings.add(timing);
        return timing;
    }

    void logTimings() {
        if (TIMING_LOGGER.isLoggable(Level.FINE)) {
            TreeMap formatted = new TreeMap();
            this.liveTimings.forEach((k, v) -> formatted.put(k, v.longValue() / 1000L / 1000L + "ms"));
            TIMING_LOGGER.log(Level.FINE, "timings for {0}: {1}", new Object[]{this.owner, formatted});
        }
    }

    void recordInternalCall(@NonNull String call) {
        this.internalCalls.add(call);
    }

    @NonNull
    Set<String> getInternalCalls() {
        return this.internalCalls;
    }

    public GroovyShell getShell() {
        return this.shell;
    }

    public GroovyShell getTrustedShell() {
        return this.trusted;
    }

    public FlowNodeStorage getStorage() {
        return this.storage;
    }

    public String getScript() {
        return this.script;
    }

    public Map<String, String> getLoadedScripts() {
        return Map.copyOf(this.loadedScripts);
    }

    public boolean isSandbox() {
        return this.sandbox;
    }

    public FlowExecutionOwner getOwner() {
        return this.owner;
    }

    private TimingFlowNodeStorage createStorage() throws IOException {
        FlowDurabilityHint hint;
        Object wrappedStorage = this.storageDir != null && this.storageDir.endsWith("-completed") ? new BulkFlowNodeStorage((FlowExecution)this, this.getStorageDir()) : ((hint = this.getDurabilityHint()).isPersistWithEveryStep() ? new SimpleXStreamFlowNodeStorage((FlowExecution)this, this.getStorageDir()) : new BulkFlowNodeStorage((FlowExecution)this, this.getStorageDir()));
        return new TimingFlowNodeStorage((FlowNodeStorage)wrappedStorage);
    }

    private synchronized void optimizeStorage(FlowNode flowEndNode) {
        if (!OPTIMIZE_STORAGE_UPON_COMPLETION) {
            return;
        }
        if (this.storage.delegate instanceof SimpleXStreamFlowNodeStorage) {
            LOGGER.log(Level.FINE, () -> "Migrating " + String.valueOf((Object)this) + " to BulkFlowNodeStorage");
            String newStorageDir = this.storageDir != null ? this.storageDir + "-completed" : "workflow-completed";
            try {
                BulkFlowNodeStorage newStorage = new BulkFlowNodeStorage((FlowExecution)this, new File(this.owner.getRootDir(), newStorageDir));
                DepthFirstScanner scanner = new DepthFirstScanner();
                scanner.setup(flowEndNode);
                for (FlowNode node : scanner) {
                    newStorage.storeNode(node, true);
                }
                newStorage.flush();
                LOGGER.log(Level.FINE, () -> "Copied nodes to " + newStorageDir);
                File oldStorageDir = this.getStorageDir();
                this.storageDir = newStorageDir;
                this.storage.withWriteLock(() -> this.lambda$optimizeStorage$5((FlowNodeStorage)newStorage, oldStorageDir));
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e, () -> "Unable to migrate " + String.valueOf((Object)this) + " to BulkFlowNodeStorage");
            }
        }
    }

    public File getStorageDir() throws IOException {
        return new File(this.owner.getRootDir(), this.storageDir != null ? this.storageDir : "workflow");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        SettableFuture f;
        final CpsScript s = this.parseScript();
        this.scriptClass = ((Object)((Object)s)).getClass();
        s.$initialize();
        final FlowHead h = new FlowHead(this);
        CpsFlowExecution cpsFlowExecution = this;
        synchronized (cpsFlowExecution) {
            this.heads.put(h.getId(), h);
        }
        h.newStartNode(new FlowStartNode((FlowExecution)this, this.iotaStr()));
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedIOException(String.valueOf((Object)this) + " was aborted while starting");
        }
        final CpsThreadGroup g = new CpsThreadGroup(this);
        g.register((Script)s);
        this.programPromise = f = SettableFuture.create();
        this.saveOwner();
        g.runner.submit(new Runnable(){

            @Override
            public void run() {
                CpsThread t = g.addThread(new Continuable((Script)s, this.createInitialEnv()), h, null);
                t.resume(new Outcome(null, null));
                f.set((Object)g);
            }

            private Env createInitialEnv() {
                return Envs.empty((Invoker)CpsFlowExecution.this.createInvoker());
            }
        });
    }

    Invoker createInvoker() {
        return LoggingInvoker.create(this.isSandbox());
    }

    private CpsScript parseScript() throws IOException {
        CpsScript s;
        try {
            this.trusted = new CpsGroovyShellFactory(this).forTrusted().build();
            this.shell = new CpsGroovyShellFactory(this).withParent(this.trusted).build();
            s = (CpsScript)this.shell.reparse("WorkflowScript", this.script);
            for (Map.Entry<String, String> e : this.loadedScripts.entrySet()) {
                this.shell.reparse(e.getKey(), e.getValue());
            }
        }
        catch (Error | RuntimeException x) {
            this.closeShells();
            throw x;
        }
        s.execution = this;
        return s;
    }

    @Restricted(value={NoExternalUse.class})
    public String iotaStr() {
        int iotaVal = this.iota();
        if (iotaVal > 0 && iotaVal < 500) {
            return ID_LOOKUP_TABLE[iotaVal];
        }
        return String.valueOf(iotaVal).intern();
    }

    @Restricted(value={NoExternalUse.class})
    public int iota() {
        return this.iota.incrementAndGet();
    }

    int approximateNodeCount() {
        return this.iota.get();
    }

    private synchronized String getHeadsAsString() {
        NavigableMap<Integer, FlowHead> myHeads = this.heads;
        if (myHeads == null) {
            return "null-heads";
        }
        if (myHeads.size() == 0) {
            return "empty-heads";
        }
        return myHeads.entrySet().stream().map(h -> String.valueOf(h.getKey()) + "::" + String.valueOf(h.getValue())).collect(Collectors.joining(","));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="this")
    void createPlaceholderNodes(Throwable failureReason) throws Exception {
        CpsFlowExecution cpsFlowExecution = this;
        synchronized (cpsFlowExecution) {
            Queue.Executable ex2;
            this.done = true;
            if (this.owner != null && (ex2 = this.owner.getExecutable()) instanceof Run) {
                Result res = ((Run)ex2).getResult();
                this.setResult(res != null ? res : Result.FAILURE);
            }
            this.programPromise = Futures.immediateFailedFuture((Throwable)new IllegalStateException("Failed loading heads", failureReason));
            LOGGER.log(Level.INFO, "Creating placeholder flownodes for execution: " + String.valueOf((Object)this));
            if (this.owner != null) {
                try {
                    this.owner.getListener().getLogger().println("Creating placeholder flownodes because failed loading originals.");
                }
                catch (Exception ex2) {
                    // empty catch block
                }
            }
            this.storageDir = this.storageDir != null ? this.storageDir + "-fallback" : "workflow-fallback";
            this.storage = this.createStorage();
            this.startNodes = new Stack();
            FlowHead head = new FlowHead(this);
            this.heads = new TreeMap<Integer, FlowHead>();
            this.heads.put(head.getId(), head);
            FlowStartNode start = new FlowStartNode((FlowExecution)this, this.iotaStr());
            head.newStartNode(start);
            FlowEndNode end = new FlowEndNode((FlowExecution)this, this.iotaStr(), (FlowStartNode)this.startNodes.pop(), this.result, this.getCurrentHeads().toArray(new FlowNode[0]));
            end.addAction((Action)new ErrorAction(failureReason));
            head.setNewHead((FlowNode)end);
        }
        this.saveOwner();
    }

    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="Storage does not actually NEED to be synchronized but the rest does.")
    protected synchronized void initializeStorage() throws IOException {
        this.storage = this.createStorage();
        this.heads = new TreeMap<Integer, FlowHead>();
        for (Map.Entry<Integer, String> entry : this.headsSerial.entrySet()) {
            FlowHead h = new FlowHead(this, entry.getKey());
            FlowNode n = this.storage.getNode(entry.getValue());
            if (n != null) {
                h.setForDeserialize(this.storage.getNode(entry.getValue()));
                this.heads.put(h.getId(), h);
                continue;
            }
            FlowDurabilityHint durabilitySetting = this.getDurabilityHint();
            if (durabilitySetting != FlowDurabilityHint.MAX_SURVIVABILITY) {
                throw new AbortException("Cannot resume build because FlowNode " + entry.getValue() + " for FlowHead " + String.valueOf(entry.getKey()) + " could not be loaded. This is expected to happen when using the " + String.valueOf(durabilitySetting) + " durability setting and Jenkins is not shut down cleanly. Consider investigating to understand if Jenkins was not shut down cleanly or switching to the MAX_SURVIVABILITY durability setting which should prevent this issue in most cases.");
            }
            Path sd = this.getStorageDir().toPath();
            List<Path> files = null;
            try (Stream<Path> walk = Files.walk(sd, new FileVisitOption[0]);){
                files = walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(sd::relativize).sorted().toList();
            }
            catch (Exception x) {
                LOGGER.log(Level.WARNING, null, x);
            }
            throw new AbortException("Cannot load build steps because FlowNode " + entry.getValue() + " for FlowHead " + String.valueOf(entry.getKey()) + " could not be loaded from " + String.valueOf((Object)this.storage) + " in " + String.valueOf(sd) + ": " + String.valueOf(files));
        }
        this.headsSerial = null;
        this.startNodes = new Stack();
        for (String id : this.startNodesSerial) {
            FlowNode node = this.storage.getNode(id);
            if (node != null) {
                this.startNodes.add((BlockStartNode)this.storage.getNode(id));
                continue;
            }
            throw new IOException("Tried to load startNode FlowNodes for execution " + String.valueOf(this.owner) + " but FlowNode was not found in storage for FlowNode Id " + id);
        }
        this.startNodesSerial = null;
    }

    public boolean canResume() {
        if (this.isResumeBlocked()) {
            return false;
        }
        if (this.persistedClean != null) {
            return this.persistedClean;
        }
        FlowDurabilityHint hint = this.getDurabilityHint();
        return hint.isPersistWithEveryStep();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLoad(FlowExecutionOwner owner) throws IOException {
        block17: {
            if (this.owner != null) {
                LOGGER.log(Level.WARNING, new Throwable(), () -> String.valueOf((Object)this) + " was already loaded");
                return;
            }
            this.owner = owner;
            try {
                try {
                    this.initializeStorage();
                }
                catch (Exception ex) {
                    String propName = CpsFlowExecution.class.getName() + ".initializeStorageFromOnLoad";
                    if (SystemProperties.getBoolean((String)propName, (boolean)true)) {
                        LOGGER.log(Level.WARNING, ex, () -> "Error initializing storage and loading nodes, will try to create placeholders for " + String.valueOf((Object)this) + " (use -D" + propName + "=false to suppress)");
                        this.createPlaceholderNodes(ex);
                        return;
                    }
                    throw ex;
                }
            }
            catch (Exception ex) {
                IOException ioe;
                this.done = true;
                this.programPromise = Futures.immediateFailedFuture((Throwable)ex);
                throw ex instanceof IOException ? (ioe = (IOException)ex) : new IOException(ex);
            }
            try {
                if (this.isComplete()) {
                    if (this.done == Boolean.TRUE && !super.isComplete()) {
                        LOGGER.log(Level.INFO, "Completed flow without FlowEndNode: " + String.valueOf((Object)this) + " heads:" + this.getHeadsAsString());
                    }
                    if (super.isComplete() && this.done != Boolean.TRUE) {
                        LOGGER.log(Level.FINE, "Flow has FlowEndNode, but is not marked as done, fixing this for" + String.valueOf((Object)this));
                        this.done = true;
                        this.saveOwner();
                    }
                    break block17;
                }
                if (this.canResume()) {
                    this.loadProgramAsync(this.getProgramDataFile());
                    break block17;
                }
                LOGGER.log(Level.WARNING, "Pipeline state not properly persisted, cannot resume " + owner.getUrl());
                throw new IOException("Cannot resume build -- was not cleanly saved when Jenkins shut down.");
            }
            catch (Exception e) {
                SettableFuture p;
                this.programPromise = p = SettableFuture.create();
                this.loadProgramFailed(e, (SettableFuture<CpsThreadGroup>)p);
            }
            finally {
                if (this.programPromise == null) {
                    this.programPromise = Futures.immediateFailedFuture((Throwable)new IllegalStateException("completed or broken execution"));
                }
            }
        }
    }

    public void loadProgramAsync(File programDataFile) {
        SettableFuture result;
        this.programPromise = result = SettableFuture.create();
        try {
            this.scriptClass = ((Object)((Object)this.parseScript())).getClass();
            final RiverReader r = new RiverReader(programDataFile, this.scriptClass.getClassLoader(), this.owner);
            this.pickleFutures = new ArrayList();
            Futures.addCallback((ListenableFuture)r.restorePickles(this.pickleFutures), (FutureCallback)new FutureCallback<Unmarshaller>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onSuccess(Unmarshaller u) {
                    CpsFlowExecution.this.pickleFutures = null;
                    try {
                        CpsFlowExecution old = PROGRAM_STATE_SERIALIZATION.get();
                        PROGRAM_STATE_SERIALIZATION.set(CpsFlowExecution.this);
                        try {
                            CpsThreadGroup g = (CpsThreadGroup)u.readObject();
                            result.set((Object)g);
                            CpsFlowExecution.this.pausedWhenLoaded = g.isPaused();
                            g.pause(false);
                            PROGRAM_STATE_SERIALIZATION.set(old);
                        }
                        catch (Throwable t) {
                            try {
                                this.onFailure(t);
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                PROGRAM_STATE_SERIALIZATION.set(old);
                            }
                        }
                    }
                    finally {
                        r.close();
                    }
                }

                public void onFailure(Throwable t) {
                    try {
                        CpsFlowExecution.this.loadProgramFailed(t, (SettableFuture<CpsThreadGroup>)result);
                    }
                    finally {
                        r.close();
                    }
                }
            });
        }
        catch (Exception | GroovyBugError e) {
            this.loadProgramFailed(e, (SettableFuture<CpsThreadGroup>)result);
        }
    }

    private void loadProgramFailed(Throwable problem, SettableFuture<CpsThreadGroup> promise) {
        try {
            Functions.printStackTrace((Throwable)problem, (PrintStream)this.owner.getListener().getLogger());
        }
        catch (Exception x) {
            LOGGER.log(Level.WARNING, x, () -> "failed to log problem to " + String.valueOf(this.owner));
        }
        promise.setException(problem);
        this.croak((Throwable)new AbortException("Failed to load program"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void croak(Throwable t) {
        boolean noStartNodes;
        this.setResult(Result.FAILURE);
        CpsFlowExecution cpsFlowExecution = this;
        synchronized (cpsFlowExecution) {
            noStartNodes = this.startNodes == null || this.startNodes.isEmpty();
        }
        if (noStartNodes) {
            try {
                this.createPlaceholderNodes(t);
            }
            catch (Exception x) {
                LOGGER.log(Level.WARNING, "Failed to create placeholder nodes in " + String.valueOf(this.owner), x);
            }
        } else {
            this.onProgramEnd(new Outcome(null, t), true);
        }
        this.cleanUpHeap();
        try {
            this.saveOwner();
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Failed to persist WorkflowRun after noting a serious failure for run: " + String.valueOf(this.owner), ex);
        }
    }

    protected void afterStepExecutionsResumed() {
        this.runInCpsVmThread(new FutureCallback<CpsThreadGroup>(){

            public void onSuccess(CpsThreadGroup g) {
                try {
                    if (CpsFlowExecution.this.pausedWhenLoaded) {
                        CpsFlowExecution.this.owner.getListener().getLogger().println("Still paused");
                    } else {
                        CpsFlowExecution.this.owner.getListener().getLogger().println("Ready to run at " + String.valueOf(new Date()));
                        g.unpause();
                        g.saveProgramIfPossible(false);
                    }
                }
                catch (IOException x) {
                    LOGGER.log(Level.WARNING, null, x);
                }
            }

            public void onFailure(Throwable t) {
                LOGGER.log(Level.WARNING, "could not resume " + String.valueOf(this), t);
            }
        });
    }

    File getProgramDataFile() throws IOException {
        return new File(this.owner.getRootDir(), "program.dat");
    }

    void runInCpsVmThread(final FutureCallback<CpsThreadGroup> callback) {
        if (this.programPromise == null) {
            throw new IllegalStateException("build storage unloadable, or build already finished");
        }
        Futures.addCallback(this.programPromise, (FutureCallback)new FutureCallback<CpsThreadGroup>(){

            public void onSuccess(final CpsThreadGroup g) {
                g.runner.submit(new Runnable(){

                    @Override
                    public void run() {
                        callback.onSuccess((Object)g);
                    }
                });
            }

            public void onFailure(Throwable t) {
                callback.onFailure(t);
            }
        });
    }

    public boolean blocksRestart() {
        CpsThreadGroup g;
        if (this.programPromise == null || !this.programPromise.isDone()) {
            return true;
        }
        try {
            g = (CpsThreadGroup)this.programPromise.get();
        }
        catch (Exception x) {
            LOGGER.log(Level.FINE, "Not blocking restart due to exception in ProgramPromise: " + String.valueOf((Object)this), x);
            return false;
        }
        if (g.busy) {
            return true;
        }
        try {
            return ((List)this.getCurrentExecutions(false).get(1L, TimeUnit.SECONDS)).stream().anyMatch(StepExecution::blocksRestart);
        }
        catch (Exception x) {
            Level level = x.getCause() instanceof RejectedExecutionException ? Level.FINE : Level.WARNING;
            LOGGER.log(level, "Not blocking restart due to problem checking running steps in " + String.valueOf((Object)this), x);
            return false;
        }
    }

    @Deprecated
    public void waitForSuspension() throws InterruptedException, ExecutionException {
        if (this.programPromise == null) {
            return;
        }
        CpsThreadGroup g = (CpsThreadGroup)this.programPromise.get();
        g.scheduleRun().get();
    }

    @CheckForNull
    public synchronized FlowHead getFlowHead(int id) {
        if (this.heads == null) {
            LOGGER.log(Level.WARNING, null, new IllegalStateException("List of flow heads unset for " + String.valueOf((Object)this)));
            return null;
        }
        return (FlowHead)this.heads.get(id);
    }

    public synchronized List<FlowNode> getCurrentHeads() {
        if (this.heads == null) {
            LOGGER.log(Level.WARNING, null, new IllegalStateException("List of flow heads unset for " + String.valueOf((Object)this)));
            return Collections.emptyList();
        }
        ArrayList<FlowNode> r = new ArrayList<FlowNode>(this.heads.size());
        for (FlowHead h : this.heads.values()) {
            r.add(h.get());
        }
        return r;
    }

    public ListenableFuture<List<StepExecution>> getCurrentExecutions(final boolean innerMostOnly) {
        if (this.programPromise == null || this.isComplete()) {
            return Futures.immediateFuture(Collections.emptyList());
        }
        final SettableFuture r = SettableFuture.create();
        this.runInCpsVmThread(new FutureCallback<CpsThreadGroup>(){

            public void onSuccess(CpsThreadGroup g) {
                if (innerMostOnly) {
                    LinkedHashMap<FlowHead, StepExecution> m = new LinkedHashMap<FlowHead, StepExecution>();
                    for (CpsThread t : g.getThreads()) {
                        StepExecution e = t.getStep();
                        if (e == null) continue;
                        m.put(t.head, e);
                    }
                    r.set((Object)ImmutableList.copyOf(m.values()));
                } else {
                    ArrayList<StepExecution> es = new ArrayList<StepExecution>();
                    for (CpsThread t : g.getThreads()) {
                        StepExecution e = t.getStep();
                        if (e == null) continue;
                        es.add(e);
                    }
                    r.set(Collections.unmodifiableList(es));
                }
            }

            public void onFailure(Throwable t) {
                if (t instanceof RejectedExecutionException) {
                    r.set(List.of());
                } else {
                    r.setException(t);
                }
            }
        });
        return r;
    }

    public CpsThreadDump getThreadDump() {
        if (this.programPromise == null || this.isComplete()) {
            return CpsThreadDump.EMPTY;
        }
        if (!this.programPromise.isDone()) {
            Collection<ListenableFuture<?>> _pickleFutures = this.pickleFutures;
            if (_pickleFutures != null) {
                StringBuilder b = new StringBuilder("Program is not yet loaded");
                for (ListenableFuture<?> pickleFuture : _pickleFutures) {
                    b.append("\n\t").append(pickleFuture);
                    if (pickleFuture.isCancelled()) {
                        b.append(" (cancelled)");
                    }
                    if (!pickleFuture.isDone()) continue;
                    b.append(" (complete)");
                }
                return CpsThreadDump.fromText(b.toString());
            }
            return CpsThreadDump.fromText("Program state is unknown");
        }
        try {
            return ((CpsThreadGroup)this.programPromise.get()).getThreadDump();
        }
        catch (InterruptedException e) {
            throw new AssertionError();
        }
        catch (ExecutionException e) {
            return CpsThreadDump.from(new Exception("Failed to resurrect program state", e));
        }
    }

    public synchronized boolean isCurrentHead(FlowNode n) {
        if (this.heads == null) {
            LOGGER.log(Level.WARNING, null, new IllegalStateException("List of flow heads unset for " + String.valueOf((Object)this)));
            return false;
        }
        for (FlowHead h : this.heads.values()) {
            if (!h.get().equals((Object)n)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addHead(FlowHead h) {
        CpsFlowExecution cpsFlowExecution = this;
        synchronized (cpsFlowExecution) {
            this.heads.put(h.getId(), h);
        }
        this.saveExecutionIfDurable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeHead(FlowHead h) {
        CpsFlowExecution cpsFlowExecution = this;
        synchronized (cpsFlowExecution) {
            this.heads.remove(h.getId());
        }
        this.saveExecutionIfDurable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void subsumeHead(FlowNode n) {
        ArrayList _heads;
        CpsFlowExecution cpsFlowExecution = this;
        synchronized (cpsFlowExecution) {
            _heads = new ArrayList(this.heads.values());
        }
        for (FlowHead h : _heads) {
            if (h.get() != n) continue;
            h.remove();
            this.saveExecutionIfDurable();
            return;
        }
    }

    public void addListener(GraphListener listener) {
        if (this.listeners == null) {
            this.listeners = new CopyOnWriteArrayList<GraphListener>();
        }
        this.listeners.add(0, listener);
    }

    public void removeListener(GraphListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public void interrupt(Result result, CauseOfInterruption ... causes) throws IOException, InterruptedException {
        this.setResult(result);
        LOGGER.log(Level.FINE, "Interrupting {0} as {1}", new Object[]{this.owner, result});
        final FlowInterruptedException ex = new FlowInterruptedException(result, causes);
        this.runInCpsVmThread(new FutureCallback<CpsThreadGroup>(){

            public void onSuccess(CpsThreadGroup g) {
                LinkedHashMap<FlowHead, CpsThread> m = new LinkedHashMap<FlowHead, CpsThread>();
                for (CpsThread t : g.getThreads()) {
                    m.put(t.head, t);
                }
                for (CpsThread t : Iterators.reverse(List.copyOf(m.values()))) {
                    try {
                        t.stop((Throwable)ex);
                    }
                    catch (Exception x) {
                        LOGGER.log(Level.WARNING, "Failed to abort " + String.valueOf(CpsFlowExecution.this.owner), x);
                    }
                }
            }

            public void onFailure(Throwable t) {
                LOGGER.log(Level.WARNING, "Failed to interrupt steps in " + String.valueOf(CpsFlowExecution.this.owner), t);
            }
        });
        Collection<ListenableFuture<?>> futures = this.pickleFutures;
        if (futures != null) {
            LOGGER.log(Level.FINE, "We are still rehydrating pickles in {0}", this.owner);
            for (ListenableFuture<?> future : futures) {
                if (future.isDone()) continue;
                LOGGER.log(Level.FINE, "Trying to cancel {0} for {1}", new Object[]{future, this.owner});
                if (future.cancel(true)) continue;
                LOGGER.log(Level.WARNING, "Failed to cancel {0} for {1}", new Object[]{future, this.owner});
            }
        }
    }

    public FlowNode getNode(String id) throws IOException {
        if (this.storage == null) {
            throw new IOException("storage not yet loaded");
        }
        return this.storage.getNode(id);
    }

    public void setResult(Result v) {
        this.result = this.result.combine(v);
    }

    public Result getResult() {
        return this.result;
    }

    public List<Action> loadActions(FlowNode node) throws IOException {
        if (this.storage == null) {
            throw new IOException("storage not yet loaded");
        }
        return this.storage.loadActions(node);
    }

    public void saveActions(FlowNode node, List<Action> actions) throws IOException {
        if (this.storage == null) {
            throw new IOException("storage not yet loaded");
        }
        if (this.isComplete()) {
            throw new IOException("Cannot save actions for " + String.valueOf(node) + " for completed execution " + String.valueOf((Object)this) + ": " + String.valueOf(actions));
        }
        this.storage.saveActions(node, actions);
    }

    void cacheNode(@NonNull FlowNode node) {
        try {
            this.getStorage().storeNode(node, true);
        }
        catch (IOException ioe) {
            LOGGER.log(Level.WARNING, "Attempt to persist triggered IOException for node " + node.getId(), ioe);
        }
    }

    public static void maybeAutoPersistNode(@NonNull FlowNode node) {
        try {
            FlowExecution exec = node.getExecution();
            if (exec instanceof CpsFlowExecution && exec.getDurabilityHint().isPersistWithEveryStep()) {
                FlowNodeStorage exc = ((CpsFlowExecution)exec).getStorage();
                exc.autopersist(node);
            }
        }
        catch (IOException ioe) {
            LOGGER.log(Level.WARNING, "Attempt to persist triggered IOException for node " + node.getId(), ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isComplete() {
        if (this.done) {
            return true;
        }
        CpsFlowExecution cpsFlowExecution = this;
        synchronized (cpsFlowExecution) {
            return this.heads != null && super.isComplete();
        }
    }

    synchronized void onProgramEnd(Outcome outcome, boolean asynchNotifications) {
        FlowEndNode head = new FlowEndNode((FlowExecution)this, this.iotaStr(), (FlowStartNode)this.startNodes.pop(), this.result, this.getCurrentHeads().toArray(new FlowNode[0]));
        if (outcome.isFailure()) {
            head.addAction((Action)new ErrorAction(outcome.getAbnormal()));
        }
        try {
            FlowHead first = this.getFirstHead();
            if (first != null) {
                first.setNewHead((FlowNode)head, asynchNotifications);
                this.done = true;
                this.heads.clear();
                this.heads.put(first.getId(), first);
                String tempIotaStr = Integer.toString(this.iota.get());
                FlowHead lastHead = (FlowHead)this.heads.get(first.getId());
                if (lastHead == null || lastHead.get() == null || !lastHead.get().getId().equals(tempIotaStr)) {
                    LOGGER.log(Level.WARNING, "Invalid final head for execution " + String.valueOf(this.owner) + " with head: " + String.valueOf(lastHead));
                }
            }
        }
        catch (Exception ex) {
            this.done = true;
            LOGGER.log(Level.WARNING, "Error trying to end execution " + String.valueOf((Object)this), ex);
        }
        try {
            this.getStorage().flush();
        }
        catch (IOException ioe) {
            LOGGER.log(Level.WARNING, "Error flushing FlowNodeStorage to disk at end of run", ioe);
        }
        this.optimizeStorage((FlowNode)head);
        this.persistedClean = Boolean.TRUE;
    }

    private void closeShells() {
        try {
            if (this.shell != null) {
                LOGGER.fine(() -> "closing main class loader from " + String.valueOf(this.owner));
                this.shell.getClassLoader().close();
                this.shell = null;
            }
            if (this.trusted != null) {
                LOGGER.fine(() -> "closing trusted class loader from " + String.valueOf(this.owner));
                this.trusted.getClassLoader().close();
                this.trusted = null;
            }
        }
        catch (IOException x) {
            LOGGER.log(Level.WARNING, "failed to close class loaders from " + String.valueOf(this.owner), x);
        }
    }

    void cleanUpHeap() {
        LOGGER.log(Level.FINE, "cleanUpHeap on {0}", this.owner);
        this.closeShells();
        if (this.scriptClass != null) {
            try {
                CpsFlowExecution.cleanUpLoader(this.scriptClass.getClassLoader(), new HashSet<ClassLoader>(), new HashSet());
            }
            catch (Exception x) {
                LOGGER.log(Level.WARNING, "failed to clean up memory from " + String.valueOf(this.owner), x);
            }
            this.scriptClass = null;
        } else {
            LOGGER.fine("no scriptClass");
        }
    }

    private static void cleanUpLoader(ClassLoader loader, Set<ClassLoader> encounteredLoaders, Set<Class<?>> encounteredClasses) throws Exception {
        if (loader instanceof CpsGroovyShell.TimingLoader) {
            CpsFlowExecution.cleanUpLoader(loader.getParent(), encounteredLoaders, encounteredClasses);
            return;
        }
        if (!(loader instanceof GroovyClassLoader)) {
            LOGGER.finer(() -> "ignoring " + String.valueOf(loader));
            return;
        }
        if (!encounteredLoaders.add(loader)) {
            return;
        }
        CpsFlowExecution.cleanUpLoader(loader.getParent(), encounteredLoaders, encounteredClasses);
        LOGGER.finer(() -> "found " + String.valueOf(loader));
        SerializableClassRegistry.getInstance().release(loader);
        GroovyClassLoader gcl = (GroovyClassLoader)loader;
        HashSet loadedClasses = new HashSet(Arrays.asList(gcl.getLoadedClasses()));
        CpsFlowExecution.cleanUpGlobalClassValue(loader, loadedClasses);
        CpsFlowExecution.cleanUpClassHelperCache(loader, loadedClasses);
        for (Class clazz : loadedClasses) {
            if (!encounteredClasses.add(clazz)) continue;
            LOGGER.finer(() -> "found " + clazz.getName());
            Introspector.flushFromCaches(clazz);
            CpsFlowExecution.cleanUpLoader(clazz.getClassLoader(), encounteredLoaders, encounteredClasses);
        }
        gcl.clearCache();
    }

    private static void cleanUpGlobalClassValue(@NonNull ClassLoader loader, Set<Class<?>> loadedClasses) throws Exception {
        Class<?> classInfoC = Class.forName("org.codehaus.groovy.reflection.ClassInfo");
        Field globalClassValueF = classInfoC.getDeclaredField("globalClassValue");
        globalClassValueF.setAccessible(true);
        Object globalClassValue = globalClassValueF.get(null);
        Class<?> groovyClassValuePreJava7C = Class.forName("org.codehaus.groovy.reflection.GroovyClassValuePreJava7");
        if (!groovyClassValuePreJava7C.isInstance(globalClassValue)) {
            return;
        }
        Field mapF = groovyClassValuePreJava7C.getDeclaredField("map");
        mapF.setAccessible(true);
        Object map = mapF.get(globalClassValue);
        Class<?> groovyClassValuePreJava7Map = Class.forName("org.codehaus.groovy.reflection.GroovyClassValuePreJava7$GroovyClassValuePreJava7Map");
        Collection entries = (Collection)groovyClassValuePreJava7Map.getMethod("values", new Class[0]).invoke(map, new Object[0]);
        Method removeM = groovyClassValuePreJava7Map.getMethod("remove", Object.class);
        Class<?> entryC = Class.forName("org.codehaus.groovy.util.AbstractConcurrentMapBase$Entry");
        Method getValueM = entryC.getMethod("getValue", new Class[0]);
        ArrayList toRemove = new ArrayList();
        Field classRefF = classInfoC.getDeclaredField("classRef");
        classRefF.setAccessible(true);
        for (Object e : entries) {
            Class clazz;
            Object classInfo = getValueM.invoke(e, new Object[0]);
            if (classInfo == null || (clazz = (Class)((WeakReference)classRefF.get(classInfo)).get()) == null) continue;
            toRemove.add(clazz);
        }
        toRemove.removeIf(CpsFlowExecution.isClassFromOtherClassLoader(loader));
        LOGGER.fine(() -> "cleaning up " + String.valueOf(toRemove) + " associated with " + String.valueOf(loader));
        for (Class clazz : toRemove) {
            loadedClasses.add(clazz);
            removeM.invoke(map, clazz);
        }
    }

    private static void cleanUpClassHelperCache(@NonNull ClassLoader loader, Set<Class<?>> loadedClasses) throws Exception {
        Field classCacheF = Class.forName("org.codehaus.groovy.ast.ClassHelper$ClassHelperCache").getDeclaredField("classCache");
        classCacheF.setAccessible(true);
        Object classCache = classCacheF.get(null);
        Class<?> classCacheC = classCache.getClass();
        Collection entries = (Collection)classCacheC.getMethod("values", new Class[0]).invoke(classCache, new Object[0]);
        Class<?> managedRefC = Class.forName("org.codehaus.groovy.util.ManagedReference");
        Method getRefM = managedRefC.getMethod("get", new Class[0]);
        ArrayList toRemove = new ArrayList();
        for (Object entry : entries) {
            Class clazz = (Class)getRefM.invoke(entry, new Object[0]);
            if (clazz == null) continue;
            toRemove.add(clazz);
        }
        toRemove.removeIf(CpsFlowExecution.isClassFromOtherClassLoader(loader));
        LOGGER.fine(() -> "cleaning up " + String.valueOf(toRemove) + " associated with " + String.valueOf(loader));
        Method removeM = classCache.getClass().getMethod("remove", Object.class);
        for (Class clazz : toRemove) {
            loadedClasses.add(clazz);
            removeM.invoke(classCache, clazz);
        }
    }

    private static Predicate<Class<?>> isClassFromOtherClassLoader(ClassLoader loader) {
        return klazz -> {
            boolean irrelevant;
            ClassLoader encounteredLoader = klazz.getClassLoader();
            boolean bl = irrelevant = encounteredLoader != loader;
            if (irrelevant) {
                LOGGER.finest(() -> "ignoring " + String.valueOf(klazz) + " with loader " + String.valueOf(encounteredLoader));
            }
            return irrelevant;
        };
    }

    @CheckForNull
    synchronized FlowHead getFirstHead() {
        if (this.heads == null) {
            return null;
        }
        Map.Entry<Integer, FlowHead> firstEntry = this.heads.firstEntry();
        if (firstEntry == null) {
            return null;
        }
        return firstEntry.getValue();
    }

    List<GraphListener> getListenersToRun() {
        ArrayList<GraphListener> l = new ArrayList<GraphListener>((Collection<GraphListener>)ExtensionList.lookup(GraphListener.class));
        if (this.listeners != null) {
            l.addAll(this.listeners);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyListeners(List<FlowNode> nodes, boolean synchronous) {
        List<GraphListener> toRun = this.getListenersToRun();
        if (!toRun.isEmpty()) {
            Saveable s = Saveable.NOOP;
            try {
                Queue.Executable exec = this.owner.getExecutable();
                if (exec instanceof Saveable) {
                    s = (Saveable)exec;
                }
            }
            catch (IOException x) {
                LOGGER.log(Level.WARNING, "failed to notify listeners of changes to " + String.valueOf(nodes) + " in " + String.valueOf((Object)this), x);
            }
            BulkChange bc = new BulkChange(s);
            try {
                for (FlowNode node : nodes) {
                    for (GraphListener listener : toRun) {
                        if (listener instanceof GraphListener.Synchronous != synchronous) continue;
                        try {
                            LOGGER.fine(() -> "notifying " + String.valueOf(listener) + " of " + String.valueOf(node));
                            listener.onNewHead(node);
                        }
                        catch (Throwable x) {
                            LOGGER.log(Level.WARNING, null, x);
                        }
                    }
                }
            }
            finally {
                if (synchronous) {
                    bc.abort();
                } else {
                    try {
                        bc.commit();
                    }
                    catch (IOException x) {
                        LOGGER.log(Level.WARNING, null, x);
                    }
                }
            }
        }
    }

    public Authentication getAuthentication2() {
        if (this.user == null) {
            return ACL.SYSTEM2;
        }
        try {
            User u = User.getById((String)this.user, (boolean)true);
            if (u == null) {
                return Jenkins.ANONYMOUS2;
            }
            return u.impersonate2();
        }
        catch (UsernameNotFoundException x) {
            LOGGER.log(Level.WARNING, "could not restore authentication", x);
            return Jenkins.ANONYMOUS2;
        }
    }

    @Restricted(value={NoExternalUse.class})
    public String getNextScriptName(String path) {
        return this.shell.generateScriptName().replaceFirst("[.]groovy$", "");
    }

    public boolean isDoneFlagSet() {
        return this.done;
    }

    public boolean isPaused() {
        if (this.programPromise.isDone()) {
            try {
                return ((CpsThreadGroup)this.programPromise.get()).isPaused();
            }
            catch (InterruptedException | ExecutionException x) {
                LOGGER.log(Level.WARNING, null, x);
            }
        }
        return false;
    }

    private void setPersistedClean(boolean persistedClean) {
        this.persistedClean = persistedClean;
    }

    public void pause(final boolean v) throws IOException {
        Queue.Executable executable = this.owner.getExecutable();
        if (executable instanceof AccessControlled) {
            ((AccessControlled)executable).checkPermission(Item.CANCEL);
        }
        this.done = false;
        Futures.addCallback(this.programPromise, (FutureCallback)new FutureCallback<CpsThreadGroup>(){

            public void onSuccess(CpsThreadGroup g) {
                if (v) {
                    g.pause(true);
                    CpsFlowExecution.this.checkAndAbortNonresumableBuild();
                    CpsFlowExecution.this.checkpoint(false);
                } else {
                    g.unpause();
                }
                try {
                    CpsFlowExecution.this.owner.getListener().getLogger().println(v ? "Pausing" : "Resuming");
                }
                catch (IOException x) {
                    LOGGER.log(Level.WARNING, null, x);
                }
            }

            public void onFailure(Throwable x) {
                LOGGER.log(Level.WARNING, "cannot pause/unpause " + String.valueOf(this), x);
            }
        });
    }

    public String toString() {
        return "CpsFlowExecution[" + String.valueOf(this.owner) + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Restricted(value={DoNotUse.class})
    @Terminator(attains={"FlowExecutionList.EXECUTIONS_SUSPENDED"})
    public static void suspendAll() {
        LOGGER.fine("looking for executions to suspend");
        ForkJoinPool pool = new ForkJoinPool();
        try {
            ArrayList<Callable<Boolean>> tasks = new ArrayList<Callable<Boolean>>();
            for (FlowExecution fe : FlowExecutionList.get()) {
                if (!(fe instanceof CpsFlowExecution)) continue;
                CpsFlowExecution cpsExec = (CpsFlowExecution)fe;
                LOGGER.finer(() -> "will request suspension of " + String.valueOf((Object)cpsExec));
                tasks.add(cpsExec::suspend);
            }
            LOGGER.fine(() -> "waiting for " + tasks.size() + " suspensions");
            Duration timeout = Duration.ofSeconds(SystemProperties.getLong((String)(CpsFlowExecution.class.getName() + ".suspendTimeout"), (Long)10L));
            List futures = pool.invokeAll(tasks, timeout.toMillis(), TimeUnit.MILLISECONDS);
            int failed = tasks.size();
            for (Future future : futures) {
                if (!future.isDone() || future.isCancelled() || !((Boolean)future.get()).booleanValue()) continue;
                --failed;
            }
            if (failed == 0) {
                LOGGER.fine("finished suspending all executions");
            } else {
                LOGGER.warning(failed + "/" + tasks.size() + " builds did not finish suspending within " + timeout.toSeconds() + " seconds");
            }
        }
        catch (Exception x) {
            LOGGER.log(Level.WARNING, "Unexpected error suspending pipeline builds; some may not be in a consistent state on resume", x);
        }
        finally {
            pool.shutdown();
        }
    }

    private boolean suspend() {
        final AtomicInteger steps = new AtomicInteger();
        try {
            boolean nonresumable = this.checkAndAbortNonresumableBuild();
            if (this.programPromise != null && this.programPromise.isDone()) {
                LOGGER.fine(() -> "waiting to suspend " + String.valueOf((Object)this));
                try {
                    CpsThreadGroup program = (CpsThreadGroup)this.programPromise.get();
                    Future<?> f = nonresumable ? program.scheduleRun() : program.terminating();
                    f.get(1L, TimeUnit.MINUTES);
                    LOGGER.finer(() -> " Pipeline went to sleep OK: " + String.valueOf((Object)this));
                    steps.incrementAndGet();
                }
                catch (InterruptedException | TimeoutException ex) {
                    LOGGER.warning(() -> "Timed out waiting for Pipeline to suspend: " + String.valueOf((Object)this));
                    LOGGER.log(Level.FINER, null, ex);
                }
            } else {
                LOGGER.fine(() -> "not trying to suspend " + String.valueOf((Object)this));
            }
            this.checkpoint(true);
            if (this.programPromise != null) {
                this.runInCpsVmThread(new FutureCallback<CpsThreadGroup>(){

                    public void onSuccess(CpsThreadGroup g) {
                        LOGGER.fine(() -> "shutting down CPS VM for " + String.valueOf((Object)CpsFlowExecution.this));
                        g.shutdown();
                        steps.incrementAndGet();
                    }

                    public void onFailure(Throwable t) {
                        LOGGER.log(t instanceof RejectedExecutionException ? Level.FINE : Level.WARNING, "failed to shut down " + String.valueOf((Object)CpsFlowExecution.this), t);
                    }
                });
            }
            this.saveOwner();
            if (this.owner != null && !this.isComplete()) {
                this.owner.getListener().getLogger().close();
                steps.incrementAndGet();
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Failed to persist build at shutdown: " + String.valueOf((Object)this), ex);
        }
        return steps.get() == 3;
    }

    void saveExecutionIfDurable() {
        if (this.getDurabilityHint().isPersistWithEveryStep()) {
            this.saveOwner();
        }
    }

    void saveOwner() {
        block5: {
            try {
                Queue.Executable executable;
                if (this.owner == null || !((executable = this.owner.getExecutable()) instanceof Saveable)) break block5;
                Saveable saveable = (Saveable)executable;
                this.persistedClean = true;
                if (this.storage != null && this.storage.delegate != null) {
                    try {
                        this.storage.flush();
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.WARNING, "Error persisting FlowNodes for execution " + String.valueOf(this.owner), ex);
                        this.persistedClean = false;
                    }
                }
                saveable.save();
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, "Error persisting Run " + String.valueOf(this.owner), ex);
                this.persistedClean = false;
            }
        }
    }

    private void checkpoint(boolean shuttingDown) {
        if (this.isComplete() || this.getDurabilityHint().isPersistWithEveryStep()) {
            LOGGER.fine(() -> "Nothing to persist for " + String.valueOf((Object)this) + " or it has already been persisted along the way");
            return;
        }
        LOGGER.log(Level.INFO, "Attempting to save a checkpoint of all data for {0}{1}", new Object[]{this, shuttingDown ? " before shutdown" : ""});
        boolean persistOk = true;
        FlowNodeStorage storage = this.getStorage();
        if (storage != null) {
            try {
                storage.flush();
            }
            catch (IOException ioe) {
                persistOk = false;
                LOGGER.log(Level.WARNING, "Error persisting FlowNode storage for: " + String.valueOf((Object)this), ioe);
            }
            try {
                final CompletableFuture myOutcome = new CompletableFuture();
                LOGGER.log(Level.FINE, "About to try to checkpoint the program for: {0}", (Object)this);
                if (this.programPromise != null && this.programPromise.isDone()) {
                    this.runInCpsVmThread(new FutureCallback<CpsThreadGroup>(){

                        public void onSuccess(CpsThreadGroup result) {
                            try {
                                LOGGER.log(Level.FINE, "Trying to save program for: {0}", (Object)CpsFlowExecution.this);
                                result.saveProgramIfPossible(true);
                                LOGGER.log(Level.FINE, "Finished saving program for: {0}", (Object)CpsFlowExecution.this);
                                myOutcome.complete(null);
                            }
                            catch (Exception ex) {
                                myOutcome.completeExceptionally(ex);
                            }
                        }

                        public void onFailure(Throwable t) {
                            myOutcome.completeExceptionally(t);
                        }
                    });
                    myOutcome.get(30L, TimeUnit.SECONDS);
                    LOGGER.log(Level.FINE, "Successfully saved program for: {0}", (Object)this);
                } else {
                    persistOk = false;
                    LOGGER.log(Level.WARNING, "Unable to persist program because it was never loaded for: {0}", (Object)this);
                }
            }
            catch (TimeoutException te) {
                persistOk = false;
                LOGGER.log(Level.WARNING, "Timeout persisting program for: " + String.valueOf((Object)this), te);
            }
            catch (InterruptedException | ExecutionException ex) {
                persistOk = false;
                LOGGER.log(Level.WARNING, "Error saving program for: " + String.valueOf((Object)this), ex);
            }
            try {
                storage.flush();
                LOGGER.log(Level.FINE, "Successfully did final flush of storage for: {0}", (Object)this);
            }
            catch (IOException ioe) {
                persistOk = false;
                LOGGER.log(Level.WARNING, "Error persisting FlowNode storage for: " + String.valueOf((Object)this), ioe);
            }
            this.persistedClean = persistOk;
            try {
                LOGGER.fine(() -> "Saving owner for " + String.valueOf((Object)this));
                this.saveOwner();
            }
            catch (Exception ex) {
                persistOk = false;
                LOGGER.log(Level.WARNING, "Error saving build for: " + String.valueOf((Object)this), ex);
            }
        } else {
            persistOk = false;
            LOGGER.log(Level.WARNING, "No FlowNode storage for: {0}", (Object)this);
        }
        if (persistOk) {
            LOGGER.log(Level.INFO, "Successfully checkpointed {0}{1}", new Object[]{this, shuttingDown ? " before shutdown" : ""});
        } else {
            LOGGER.log(Level.WARNING, "Unable to successfully checkpoint {0}{1}", new Object[]{this, shuttingDown ? " before shutdown, so this build will probably fail when Jenkins restarts" : ""});
        }
    }

    private boolean checkAndAbortNonresumableBuild() {
        if (this.isComplete() || this.getDurabilityHint().isPersistWithEveryStep() || !this.isResumeBlocked()) {
            return false;
        }
        try {
            this.owner.getListener().getLogger().println("Failing build: shutting down controller and build is marked to not resume");
            FlowInterruptedException x = new FlowInterruptedException(Result.ABORTED, new CauseOfInterruption[0]);
            Futures.addCallback(this.getCurrentExecutions(true), (FutureCallback)new FutureCallback<List<StepExecution>>((Throwable)x){
                final /* synthetic */ Throwable val$x;
                {
                    this.val$x = throwable;
                }

                public void onSuccess(List<StepExecution> l) {
                    for (StepExecution e : Iterators.reverse(l)) {
                        StepContext context = e.getContext();
                        context.onFailure(this.val$x);
                        try {
                            FlowNode n = (FlowNode)context.get(FlowNode.class);
                            if (n == null) continue;
                            CpsFlowExecution.this.owner.getListener().getLogger().println("Terminating " + n.getDisplayFunctionName());
                        }
                        catch (Exception x) {
                            LOGGER.log(Level.FINE, null, x);
                        }
                    }
                }

                public void onFailure(Throwable t) {
                    LOGGER.log(Level.WARNING, "Error stopping build due to error obtaining executions", t);
                }
            });
        }
        catch (IOException ioe) {
            LOGGER.log(Level.WARNING, "Error just doing logging", ioe);
        }
        return true;
    }

    private /* synthetic */ void lambda$optimizeStorage$5(FlowNodeStorage newStorage, File oldStorageDir) throws RuntimeException {
        this.storage.delegate = newStorage;
        try {
            Util.deleteRecursive((File)oldStorageDir);
            LOGGER.log(Level.FINE, () -> "Deleted " + String.valueOf(oldStorageDir));
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, e, () -> "Unable to delete unused flow node storage directory " + String.valueOf(oldStorageDir) + " for " + String.valueOf((Object)this));
        }
    }

    static {
        for (int i = 0; i < ID_LOOKUP_TABLE.length; ++i) {
            CpsFlowExecution.ID_LOOKUP_TABLE[i] = String.valueOf(i).intern();
        }
        TIMING_LOGGER = Logger.getLogger(CpsFlowExecution.class.getName() + ".timing");
        LOGGER = Logger.getLogger(CpsFlowExecution.class.getName());
        PROGRAM_STATE_SERIALIZATION = new ThreadLocal();
    }

    class TimingFlowNodeStorage
    extends FlowNodeStorage {
        FlowNodeStorage delegate;
        private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

        TimingFlowNodeStorage(FlowNodeStorage delegate) {
            this.delegate = delegate;
        }

        public FlowNode getNode(String string) throws IOException {
            try (Timing t = CpsFlowExecution.this.time(TimingKind.flowNode);){
                FlowNode flowNode = this.withReadLock(() -> this.delegate.getNode(string));
                return flowNode;
            }
        }

        public void storeNode(@NonNull FlowNode n) throws IOException {
            try (Timing t = CpsFlowExecution.this.time(TimingKind.flowNode);){
                this.withWriteLock(() -> this.delegate.storeNode(n));
            }
        }

        public void storeNode(@NonNull FlowNode n, boolean delayWritingActions) throws IOException {
            try (Timing t = CpsFlowExecution.this.time(TimingKind.flowNode);){
                this.withWriteLock(() -> this.delegate.storeNode(n, delayWritingActions));
            }
        }

        public void flush() throws IOException {
            try (Timing t = CpsFlowExecution.this.time(TimingKind.flowNode);){
                this.withWriteLock(() -> this.delegate.flush());
            }
        }

        public void flushNode(FlowNode node) throws IOException {
            try (Timing t = CpsFlowExecution.this.time(TimingKind.flowNode);){
                this.withWriteLock(() -> this.delegate.flushNode(node));
            }
        }

        public void autopersist(@NonNull FlowNode n) throws IOException {
            try (Timing t = CpsFlowExecution.this.time(TimingKind.flowNode);){
                this.withWriteLock(() -> this.delegate.autopersist(n));
            }
        }

        public List<Action> loadActions(FlowNode node) throws IOException {
            try (Timing t = CpsFlowExecution.this.time(TimingKind.flowNode);){
                List list = this.withReadLock(() -> this.delegate.loadActions(node));
                return list;
            }
        }

        public void saveActions(FlowNode node, List<Action> actions) throws IOException {
            try (Timing t = CpsFlowExecution.this.time(TimingKind.flowNode);){
                this.withWriteLock(() -> this.delegate.saveActions(node, actions));
            }
        }

        public String toString() {
            return "TimingFlowNodeStorage[" + String.valueOf(this.delegate) + "]";
        }

        private <T, E extends Exception> T withReadLock(@NonNull SupplierWithEx<T, E> supplier) throws E {
            try (WithThreadName ignored = new WithThreadName(" acquiring read lock on storage of " + String.valueOf((Object)CpsFlowExecution.this));){
                this.readWriteLock.readLock().lock();
            }
            try {
                T t;
                ignored = new WithThreadName(" with read lock on storage of " + String.valueOf((Object)CpsFlowExecution.this));
                try {
                    t = supplier.get();
                }
                catch (Throwable throwable) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                ignored.close();
                return t;
            }
            finally {
                this.readWriteLock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <E extends Exception> void withWriteLock(@NonNull RunnableWithEx<E> runnable) throws E {
            try (WithThreadName ignored = new WithThreadName(" acquiring write lock on storage of " + String.valueOf((Object)CpsFlowExecution.this));){
                this.readWriteLock.writeLock().lock();
            }
            try {
                ignored = new WithThreadName(" with write lock on storage of " + String.valueOf((Object)CpsFlowExecution.this));
                try {
                    runnable.run();
                }
                finally {
                    ignored.close();
                }
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
        }

        @FunctionalInterface
        private static interface SupplierWithEx<T, E extends Exception> {
            public T get() throws E;
        }

        @FunctionalInterface
        private static interface RunnableWithEx<E extends Exception> {
            public void run() throws E;
        }
    }

    class Timing
    implements AutoCloseable {
        private final TimingKind kind;
        private final long start;

        private Timing(TimingKind kind) {
            this.kind = kind;
            this.start = System.nanoTime();
        }

        TimingKind getKind() {
            return this.kind;
        }

        long getStartNanos() {
            return this.start;
        }

        @Override
        public void close() {
            CpsFlowExecution.this.liveIncompleteTimings.remove(this);
            CpsFlowExecution.this.liveTimings.computeIfAbsent(this.kind.name(), k -> new LongAdder()).add(System.nanoTime() - this.start);
        }
    }

    static enum TimingKind {
        parse,
        classLoad,
        run,
        runQueue,
        saveProgram,
        flowNode;

    }

    @Extension(optional=true)
    public static class PipelineInternalCalls
    extends Component {
        public Set<Permission> getRequiredPermissions() {
            return Collections.singleton(Jenkins.ADMINISTER);
        }

        public String getDisplayName() {
            return "List of internal API calls made by Pipeline builds (typically from trusted libraries)";
        }

        public Component.ComponentCategory getCategory() {
            return Component.ComponentCategory.BUILDS;
        }

        public void addContents(Container container) {
            container.add(new Content("nodes/master/pipeline-internal-calls.txt"){

                public void writeTo(OutputStream outputStream) throws IOException {
                    PrintWriter pw = new PrintWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
                    pw.println("Internal Jenkins API calls from the last build of any job (plus one example of such a build):");
                    TreeMap<String, String> internalCallsToExample = new TreeMap<String, String>();
                    for (Job job : Jenkins.get().getAllItems(Job.class)) {
                        FlowExecution exec;
                        FlowExecutionOwner owner;
                        Run run;
                        if (!(job instanceof Queue.FlyweightTask) || !((run = job.getLastCompletedBuild()) instanceof FlowExecutionOwner.Executable) || (owner = ((FlowExecutionOwner.Executable)run).asFlowExecutionOwner()) == null || !((exec = owner.getOrNull()) instanceof CpsFlowExecution)) continue;
                        for (String call : ((CpsFlowExecution)exec).getInternalCalls()) {
                            internalCallsToExample.putIfAbsent(call, run.toString());
                        }
                    }
                    for (Map.Entry entry : internalCallsToExample.entrySet()) {
                        pw.println((String)entry.getKey() + " (" + (String)entry.getValue() + ")");
                    }
                    pw.flush();
                }
            });
        }
    }

    @Extension(optional=true)
    public static class PipelineTimings
    extends Component {
        public Set<Permission> getRequiredPermissions() {
            return Set.of(Jenkins.ADMINISTER);
        }

        public String getDisplayName() {
            return "Recently completed Pipeline builds";
        }

        public Component.ComponentCategory getCategory() {
            return Component.ComponentCategory.BUILDS;
        }

        public void addContents(Container container) {
            container.add(new Content("nodes/master/pipeline-recent-builds.txt"){

                public void writeTo(OutputStream outputStream) throws IOException {
                    PrintWriter pw = new PrintWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
                    for (Job job : Jenkins.get().getAllItems(Job.class)) {
                        FlowExecution exec;
                        FlowExecutionOwner owner;
                        Run run;
                        if (!(job instanceof Queue.FlyweightTask) || !((run = job.getLastCompletedBuild()) instanceof FlowExecutionOwner.Executable) || (owner = ((FlowExecutionOwner.Executable)run).asFlowExecutionOwner()) == null) continue;
                        try {
                            exec = owner.get();
                        }
                        catch (IOException x) {
                            pw.println("No timings available for " + String.valueOf(run) + ": " + String.valueOf(x));
                            pw.println();
                            continue;
                        }
                        if (!(exec instanceof CpsFlowExecution)) continue;
                        TreeMap<String, LongAdder> sortedTimings = new TreeMap<String, LongAdder>(((CpsFlowExecution)exec).liveTimings);
                        pw.println("Timings for " + String.valueOf(run) + ":");
                        sortedTimings.forEach((k, v) -> pw.println("  " + k + "\t" + v.longValue() / 1000L / 1000L + "ms"));
                        pw.println("Approximate graph size: " + ((CpsFlowExecution)exec).approximateNodeCount());
                        pw.println();
                    }
                    pw.flush();
                }
            });
        }
    }

    public static final class ConverterImpl
    implements Converter {
        private final ReflectionProvider ref;
        private final Mapper mapper;

        public ConverterImpl(XStream xs) {
            this.ref = xs.getReflectionProvider();
            this.mapper = xs.getMapper();
        }

        public boolean canConvert(Class type) {
            return CpsFlowExecution.class == type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void marshal(Object source, HierarchicalStreamWriter w, MarshallingContext context) {
            CpsFlowExecution e = (CpsFlowExecution)((Object)source);
            this.writeChild(w, context, "result", e.result, Result.class);
            this.writeChild(w, context, "script", e.script, String.class);
            this.writeChild(w, context, "loadedScripts", e.loadedScripts, Map.class);
            if (e.persistedClean != null) {
                this.writeChild(w, context, "persistedClean", e.persistedClean, Boolean.class);
            }
            if (e.durabilityHint != null) {
                this.writeChild(w, context, "durabilityHint", e.durabilityHint, FlowDurabilityHint.class);
            }
            this.writeChild(w, context, "timings", e.liveTimings.entrySet().stream().collect(Collectors.toMap(kv -> (String)kv.getKey(), kv -> ((LongAdder)kv.getValue()).longValue())), Map.class);
            this.writeChild(w, context, "internalCalls", new TreeSet<String>(e.internalCalls), Set.class);
            this.writeChild(w, context, "sandbox", e.sandbox, Boolean.class);
            if (e.user != null) {
                this.writeChild(w, context, "user", e.user, String.class);
            }
            this.writeChild(w, context, "iota", e.iota.get(), Integer.class);
            CpsFlowExecution cpsFlowExecution = e;
            synchronized (cpsFlowExecution) {
                if (e.headsSerial != null && (e.heads == null || e.heads.isEmpty())) {
                    for (Map.Entry entry : e.headsSerial.entrySet()) {
                        this.writeChild(w, context, "head", String.valueOf(entry.getKey()) + ":" + (String)entry.getValue(), String.class);
                    }
                } else {
                    for (FlowHead flowHead : e.heads.values()) {
                        this.writeChild(w, context, "head", flowHead.getId() + ":" + flowHead.get().getId(), String.class);
                    }
                }
                if (e.startNodesSerial != null && e.startNodes == null) {
                    for (String string : e.startNodesSerial) {
                        this.writeChild(w, context, "start", string, String.class);
                    }
                } else {
                    for (BlockStartNode blockStartNode : e.startNodes) {
                        this.writeChild(w, context, "start", blockStartNode.getId(), String.class);
                    }
                }
                this.writeChild(w, context, "done", e.done, Boolean.class);
            }
            this.writeChild(w, context, "resumeBlocked", e.resumeBlocked, Boolean.class);
            if (e.storageDir != null) {
                this.writeChild(w, context, "storageDir", e.storageDir, String.class);
            }
        }

        private <T> void writeChild(HierarchicalStreamWriter w, MarshallingContext context, String name, @NonNull T v, Class<T> staticType) {
            if (!this.mapper.shouldSerializeMember(CpsFlowExecution.class, name)) {
                return;
            }
            ExtendedHierarchicalStreamWriterHelper.startNode((HierarchicalStreamWriter)w, (String)name, staticType);
            Class<?> actualType = v.getClass();
            if (actualType != staticType) {
                w.addAttribute(this.mapper.aliasForSystemAttribute("class"), this.mapper.serializedClass(actualType));
            }
            context.convertAnother(v);
            w.endNode();
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            try {
                CpsFlowExecution result = context.currentObject() != null ? (CpsFlowExecution)((Object)context.currentObject()) : (CpsFlowExecution)((Object)this.ref.newInstance(CpsFlowExecution.class));
                result.startNodesSerial = new ArrayList<String>();
                result.headsSerial = new TreeMap<Integer, String>();
                result.internalCalls = ConcurrentHashMap.newKeySet();
                while (reader.hasMoreChildren()) {
                    reader.moveDown();
                    String nodeName = reader.getNodeName();
                    if (nodeName.equals("result")) {
                        Result r = this.readChild(reader, context, Result.class, (Object)result);
                        this.setField(result, "result", r);
                    } else if (nodeName.equals("script")) {
                        String script = this.readChild(reader, context, String.class, (Object)result);
                        this.setField(result, "script", script);
                    } else if (nodeName.equals("loadedScripts")) {
                        Map loadedScripts = this.readChild(reader, context, Map.class, (Object)result);
                        this.setField(result, "loadedScripts", loadedScripts);
                    } else if (nodeName.equals("timings")) {
                        Map timings = this.readChild(reader, context, Map.class, (Object)result);
                        this.setField(result, "timings", timings);
                    } else if (nodeName.equals("internalCalls")) {
                        Set internalCalls = this.readChild(reader, context, Set.class, (Object)result);
                        for (Object internalCall : internalCalls) {
                            result.internalCalls.add((String)internalCall);
                        }
                    } else if (nodeName.equals("sandbox")) {
                        boolean sandbox = this.readChild(reader, context, Boolean.class, (Object)result);
                        this.setField(result, "sandbox", sandbox);
                    } else if (nodeName.equals("owner")) {
                        this.readChild(reader, context, Object.class, (Object)result);
                    } else if (nodeName.equals("user")) {
                        String user = this.readChild(reader, context, String.class, (Object)result);
                        this.setField(result, "user", user);
                    } else if (nodeName.equals("head")) {
                        String[] head = this.readChild(reader, context, String.class, (Object)result).split(":");
                        result.headsSerial.put(Integer.parseInt(head[0]), head[1]);
                    } else if (nodeName.equals("iota")) {
                        Integer iota = this.readChild(reader, context, Integer.class, (Object)result);
                        this.setField(result, "iota", new AtomicInteger(iota));
                    } else if (nodeName.equals("done")) {
                        Boolean isDone = this.readChild(reader, context, Boolean.class, (Object)result);
                        this.setField(result, "done", isDone);
                    } else if (nodeName.equals("start")) {
                        String id = this.readChild(reader, context, String.class, (Object)result);
                        result.startNodesSerial.add(id);
                    } else if (nodeName.equals("durabilityHint")) {
                        FlowDurabilityHint hint = this.readChild(reader, context, FlowDurabilityHint.class, (Object)result);
                        this.setFieldParent(result, "durabilityHint", hint);
                    } else if (nodeName.equals("persistedClean")) {
                        Boolean hint = this.readChild(reader, context, Boolean.class, (Object)result);
                        this.setField(result, "persistedClean", hint);
                    } else if (nodeName.equals("resumeBlocked")) {
                        Boolean val = this.readChild(reader, context, Boolean.class, (Object)result);
                        this.setField(result, "resumeBlocked", val);
                    } else if (nodeName.equals("storageDir")) {
                        String val = this.readChild(reader, context, String.class, (Object)result);
                        this.setField(result, "storageDir", val);
                    }
                    reader.moveUp();
                }
                if (result.loadedScripts == null) {
                    result.loadedScripts = new LinkedHashMap<String, String>();
                }
                result.liveTimings = result.timings == null ? new ConcurrentHashMap<String, LongAdder>() : (Map)result.timings.entrySet().stream().collect(Collectors.toConcurrentMap(kv -> (String)kv.getKey(), kv -> {
                    LongAdder la = new LongAdder();
                    la.add((Long)kv.getValue());
                    return la;
                }));
                result.liveIncompleteTimings = ConcurrentHashMap.newKeySet();
                return result;
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Failed to even load the FlowExecution", ex);
                throw new RuntimeException(ex);
            }
        }

        private void setField(CpsFlowExecution result, String fieldName, Object value) {
            this.ref.writeField((Object)result, fieldName, value, CpsFlowExecution.class);
        }

        private void setFieldParent(CpsFlowExecution result, String fieldName, Object value) {
            this.ref.writeField((Object)result, fieldName, value, FlowExecution.class);
        }

        private <T> T readChild(HierarchicalStreamReader r, UnmarshallingContext context, Class<T> type, Object parent) {
            String classAttribute = r.getAttribute(this.mapper.aliasForAttribute("class"));
            if (classAttribute != null) {
                type = this.mapper.realClass(classAttribute);
            }
            return type.cast(context.convertAnother(parent, type));
        }
    }
}

