/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps.replay;

import hudson.AbortException;
import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.cli.handlers.GenericItemOptionHandler;
import hudson.model.Job;
import hudson.model.Run;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import jenkins.model.Jenkins;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.plugins.scriptsecurity.scripts.ScriptApproval;
import org.jenkinsci.plugins.scriptsecurity.scripts.languages.GroovyLanguage;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.replay.Messages;
import org.jenkinsci.plugins.workflow.cps.replay.ReplayAction;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.Setter;

@Extension
public class ReplayPipelineCommand
extends CLICommand {
    @Argument(required=true, index=0, metaVar="JOB", usage="Name of the job to replay.", handler=JobHandler.class)
    public Job<?, ?> job;
    @Option(name="-n", aliases={"--number"}, metaVar="BUILD#", usage="Build to replay, if not the last.")
    public int number;
    @Option(name="-s", aliases={"--script"}, metaVar="SCRIPT", usage="Name of script to edit, such as Script3, if not the main Jenkinsfile.")
    public String script;
    @Option(name="-a", aliases={"--approve"}, metaVar="APPROVE", usage="Approve the main Jenkinsfile if the build is unsandboxed.")
    public boolean approve = false;

    public String getShortDescription() {
        return Messages.ReplayCommand_shortDescription();
    }

    protected int run() throws Exception {
        Run run;
        Run run2 = run = this.number == 0 ? this.job.getLastBuild() : this.job.getBuildByNumber(this.number);
        if (run == null) {
            throw new AbortException("No such build");
        }
        ReplayAction action = (ReplayAction)run.getAction(ReplayAction.class);
        if (action == null) {
            throw new AbortException("Not a Pipeline build");
        }
        if (!action.isEnabled() || !action.isReplayableSandboxTest()) {
            throw new AbortException("Not authorized to replay builds of this job");
        }
        String text = IOUtils.toString((InputStream)this.stdin, (Charset)this.getClientCharset());
        if (this.script != null) {
            HashMap<String, String> replacementLoadedScripts = new HashMap<String, String>(action.getOriginalLoadedScripts());
            if (!replacementLoadedScripts.containsKey(this.script)) {
                throw new AbortException("Unrecognized script name among " + String.valueOf(replacementLoadedScripts.keySet()));
            }
            replacementLoadedScripts.put(this.script, text);
            if (this.approve) {
                this.approveScript(action.getOriginalScript(), action);
            }
            action.run(action.getOriginalScript(), replacementLoadedScripts);
        } else {
            this.approveScript(text, action);
            action.run(text, action.getOriginalLoadedScripts());
        }
        return 0;
    }

    public void approveScript(String script, ReplayAction action) {
        CpsFlowExecution exec = action.getExecutionBlocking();
        if (exec == null) {
            return;
        }
        if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER) || exec.isSandbox()) {
            return;
        }
        if (!ScriptApproval.get().isScriptApproved(script, GroovyLanguage.get())) {
            ScriptApproval.get().preapprove(script, GroovyLanguage.get());
            ScriptApproval.get().save();
        }
    }

    public static class JobHandler
    extends GenericItemOptionHandler<Job> {
        public JobHandler(CmdLineParser parser, OptionDef option, Setter<Job> setter) {
            super(parser, option, setter);
        }

        protected Class<Job> type() {
            return Job.class;
        }
    }
}

