/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import com.cloudbees.groovy.cps.Outcome;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import groovy.lang.Closure;
import hudson.model.Result;
import hudson.util.DaemonThreadFactory;
import hudson.util.NamingThreadFactory;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import jenkins.model.CauseOfInterruption;
import jenkins.model.Jenkins;
import jenkins.util.ContextResettingExecutorService;
import net.jcip.annotations.GuardedBy;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.jenkinsci.plugins.workflow.cps.BodyReference;
import org.jenkinsci.plugins.workflow.cps.CpsBodyInvoker;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.CpsThread;
import org.jenkinsci.plugins.workflow.cps.CpsThreadGroup;
import org.jenkinsci.plugins.workflow.cps.CpsVmThreadOnly;
import org.jenkinsci.plugins.workflow.cps.FlowHead;
import org.jenkinsci.plugins.workflow.cps.nodes.StepEndNode;
import org.jenkinsci.plugins.workflow.cps.nodes.StepNode;
import org.jenkinsci.plugins.workflow.cps.nodes.StepStartNode;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.FailureHandler;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.support.DefaultStepContext;
import org.jenkinsci.plugins.workflow.support.concurrent.Futures;

@SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
public class CpsStepContext
extends DefaultStepContext {
    private static final Logger LOGGER = Logger.getLogger(CpsStepContext.class.getName());
    @GuardedBy(value="this")
    private transient Outcome outcome;
    private transient Throwable whenOutcomeDelivered;
    private transient boolean syncMode = true;
    private final FlowExecutionOwner executionRef;
    private final String id;
    transient FlowNode node;
    final List<Integer> bodyHeads = new ArrayList<Integer>();
    @GuardedBy(value="this")
    private transient List<CpsBodyInvoker> bodyInvokers = new ArrayList<CpsBodyInvoker>();
    @CheckForNull
    private BodyReference body;
    private final int threadId;
    private final String stepDescriptorId;
    private volatile transient StepDescriptor stepDescriptor;
    private volatile transient CpsThreadGroup threadGroup;
    private volatile transient boolean loadingThreadGroup;
    private static final ExecutorService isReadyExecutorService = new ContextResettingExecutorService(Executors.newCachedThreadPool((ThreadFactory)new NamingThreadFactory((ThreadFactory)new DaemonThreadFactory(), "CpsStepContext.isReady")));
    private static final long serialVersionUID = 1L;

    @CpsVmThreadOnly
    CpsStepContext(StepDescriptor step, CpsThread thread, FlowExecutionOwner executionRef, FlowNode node, @CheckForNull Closure body) {
        this.threadId = thread.id;
        this.executionRef = executionRef;
        this.id = node.getId();
        this.node = node;
        this.body = body != null ? thread.group.export(body) : null;
        this.stepDescriptorId = step.getId();
    }

    @CheckForNull
    public StepDescriptor getStepDescriptor() {
        Jenkins j = Jenkins.getInstanceOrNull();
        if (j == null) {
            return null;
        }
        if (this.stepDescriptor == null) {
            this.stepDescriptor = (StepDescriptor)j.getDescriptor(this.stepDescriptorId);
        }
        return this.stepDescriptor;
    }

    public String getDisplayName() {
        StepDescriptor d = this.getStepDescriptor();
        return d != null ? d.getDisplayName() : this.stepDescriptorId;
    }

    protected CpsFlowExecution getExecution() throws IOException {
        return (CpsFlowExecution)this.executionRef.get();
    }

    @CheckForNull
    CpsThread getThread(CpsThreadGroup g) {
        return g.getThread(this.threadId);
    }

    @CheckForNull
    private CpsThread getThreadSynchronously() throws InterruptedException, IOException {
        return this.getThread(this.getThreadGroupSynchronously());
    }

    @NonNull
    private CpsThreadGroup getThreadGroupSynchronously() throws InterruptedException, IOException {
        if (this.threadGroup == null) {
            ListenableFuture<CpsThreadGroup> pp;
            CpsFlowExecution flowExecution = this.getExecution();
            while ((pp = flowExecution.programPromise) == null) {
                Thread.sleep(100L);
            }
            try {
                this.threadGroup = (CpsThreadGroup)pp.get();
            }
            catch (ExecutionException e) {
                throw new IOException(e);
            }
        }
        return this.threadGroup;
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    public boolean isReady() {
        if (this.threadGroup == null) {
            if (!this.loadingThreadGroup) {
                isReadyExecutorService.submit(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        CpsStepContext.this.getThreadGroupSynchronously();
                        return null;
                    }
                });
                this.loadingThreadGroup = true;
            }
            return false;
        }
        return true;
    }

    public boolean hasBody() {
        return this.body != null;
    }

    public CpsBodyInvoker newBodyInvoker() {
        if (this.body == null) {
            throw new IllegalStateException("There is no body to invoke");
        }
        return this.newBodyInvoker(this.body, false);
    }

    @NonNull
    public CpsBodyInvoker newBodyInvoker(@NonNull BodyReference body, boolean unexport) {
        return new CpsBodyInvoker(this, body, unexport);
    }

    protected <T> T doGet(Class<T> key) throws IOException, InterruptedException {
        CpsThread t = this.getThreadSynchronously();
        if (t == null) {
            throw new IOException("cannot find current thread in " + String.valueOf((Object)this));
        }
        return t.getContextVariable(key, this::getExecution, this::getNode);
    }

    protected FlowNode getNode() throws IOException {
        if (this.node == null) {
            this.node = this.getExecution().getNode(this.id);
            if (this.node == null) {
                throw new IOException("no node found for " + this.id + " in " + String.valueOf((Object)this));
            }
        }
        return this.node;
    }

    public synchronized void onFailure(Throwable t) {
        if (t == null) {
            throw new IllegalArgumentException();
        }
        t = FailureHandler.apply((StepContext)this, (Throwable)t);
        this.completed(new Outcome(null, t));
    }

    public synchronized void onSuccess(Object returnValue) {
        this.completed(new Outcome(returnValue, null));
    }

    private void completed(@NonNull Outcome newOutcome) {
        if (this.outcome == null) {
            LOGGER.finer(() -> String.valueOf((Object)this) + " completed with " + String.valueOf(newOutcome));
            this.outcome = newOutcome;
            this.scheduleNextRun();
            this.whenOutcomeDelivered = new Throwable();
        } else {
            Throwable failure = newOutcome.getAbnormal();
            Throwable earlierFailure = this.outcome.getAbnormal();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "already completed " + String.valueOf((Object)this), new IllegalStateException("delivered here"));
                if (failure != null) {
                    LOGGER.log(Level.FINE, "new failure", failure);
                } else {
                    LOGGER.log(Level.FINE, "new success: {0}", this.outcome.getNormal());
                }
                if (this.whenOutcomeDelivered != null) {
                    LOGGER.log(Level.FINE, "previously delivered here", this.whenOutcomeDelivered);
                }
                if (earlierFailure != null) {
                    LOGGER.log(Level.FINE, "earlier failure", earlierFailure);
                } else {
                    LOGGER.log(Level.FINE, "earlier success: {0}", this.outcome.getNormal());
                }
            }
            if (failure != null && earlierFailure != null && !CpsStepContext.refersTo(failure, earlierFailure, Collections.newSetFromMap(new IdentityHashMap()))) {
                earlierFailure.addSuppressed(failure);
            }
        }
    }

    private static boolean refersTo(Throwable t1, Throwable t2, Set<Throwable> checked) {
        return checked.add(t1) && (t1 == t2 || t1.getCause() != null && CpsStepContext.refersTo(t1.getCause(), t2, checked) || Stream.of(t1.getSuppressed()).anyMatch(t3 -> CpsStepContext.refersTo(t3, t2, checked)));
    }

    private void scheduleNextRun() {
        if (this.syncMode) {
            if (this.threadGroup != null && this.body != null) {
                this.threadGroup.unexport(this.body);
                this.body = null;
            }
            return;
        }
        try {
            final FlowNode n = this.getNode();
            final CpsFlowExecution flow = this.getExecution();
            final ArrayList<FlowNode> parents = new ArrayList<FlowNode>();
            for (int head : this.bodyHeads) {
                FlowHead flowHead = flow.getFlowHead(head);
                if (flowHead != null) {
                    parents.add(flowHead.get());
                    continue;
                }
                LOGGER.log(Level.WARNING, "Could not find flow head #{0}", head);
            }
            flow.runInCpsVmThread(new FutureCallback<CpsThreadGroup>(){

                @CpsVmThreadOnly
                public void onSuccess(CpsThreadGroup g) {
                    g.unexport(CpsStepContext.this.body);
                    CpsStepContext.this.body = null;
                    CpsThread thread = CpsStepContext.this.getThread(g);
                    if (thread != null) {
                        CpsThread nit = thread.getNextInner();
                        if (nit != null) {
                            StepExecution s;
                            nit.addCompletionHandler(new ScheduleNextRun());
                            if (CpsStepContext.this.getOutcome().isFailure() && (s = nit.getStep()) != null) {
                                FlowInterruptedException cause = new FlowInterruptedException(Result.FAILURE, new CauseOfInterruption[]{new BodyFailed()});
                                cause.initCause(CpsStepContext.this.getOutcome().getAbnormal());
                                try {
                                    s.stop((Throwable)cause);
                                }
                                catch (Exception e) {
                                    LOGGER.log(Level.WARNING, "Failed to stop the body execution in response to the failure of the parent");
                                }
                            }
                            return;
                        }
                        if (n instanceof StepStartNode) {
                            if (parents.isEmpty()) {
                                parents.add(thread.head.get());
                            }
                            for (int i = 1; i < parents.size(); ++i) {
                                g.getExecution().subsumeHead((FlowNode)parents.get(i));
                            }
                            StepEndNode en = new StepEndNode(flow, (StepStartNode)n, parents);
                            thread.head.setNewHead((FlowNode)en);
                        }
                        thread.head.markIfFail(CpsStepContext.this.getOutcome());
                        thread.setStep(null);
                        thread.resume(CpsStepContext.this.getOutcome());
                    }
                    CpsStepContext.this.outcome = new Outcome(null, (Throwable)((Object)new AlreadyCompleted()));
                }

                public void onFailure(Throwable t) {
                    LOGGER.log(Level.WARNING, "Failed to proceed after " + String.valueOf((Object)CpsStepContext.this), t);
                }
            });
        }
        catch (IOException x) {
            LOGGER.log(Level.WARNING, "Unable to load FlowNode or CpsFlowExecution when completing " + String.valueOf((Object)this) + ", which is likely to cause its execution to hang indefinitely", x);
        }
    }

    public void setResult(Result r) {
        try {
            this.getExecution().setResult(r);
        }
        catch (IOException x) {
            LOGGER.log(Level.FINE, null, x);
        }
    }

    synchronized boolean isCompleted() {
        return this.outcome != null;
    }

    synchronized boolean isSyncMode() {
        return this.syncMode;
    }

    synchronized Object replay() {
        try {
            return this.getOutcome().replay();
        }
        catch (Throwable failure) {
            if (failure instanceof RuntimeException) {
                throw (RuntimeException)failure;
            }
            if (failure instanceof Error) {
                throw (Error)failure;
            }
            throw new InvokerInvocationException(failure);
        }
    }

    synchronized Outcome getOutcome() {
        return this.outcome;
    }

    synchronized boolean switchToAsyncMode() {
        if (!this.syncMode) {
            throw new AssertionError();
        }
        this.syncMode = false;
        return !this.isCompleted();
    }

    synchronized <R> R withBodyInvokers(Function<List<CpsBodyInvoker>, R> action) {
        return action.apply(this.bodyInvokers);
    }

    public ListenableFuture<Void> saveState() {
        try {
            final SettableFuture f = SettableFuture.create();
            CpsFlowExecution exec = this.getExecution();
            if (!exec.getDurabilityHint().isPersistWithEveryStep()) {
                f.set(null);
                return f;
            }
            exec.runInCpsVmThread(new FutureCallback<CpsThreadGroup>(){

                public void onSuccess(CpsThreadGroup result) {
                    try {
                        if (result.getExecution().getDurabilityHint().isPersistWithEveryStep()) {
                            result.getExecution().getStorage().flush();
                            result.saveProgram();
                        }
                        f.set(null);
                    }
                    catch (Exception x) {
                        f.setException((Throwable)x);
                    }
                }

                public void onFailure(Throwable t) {
                    f.setException(t);
                }
            });
            return f;
        }
        catch (IOException x) {
            return Futures.immediateFailedFuture((Throwable)x);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CpsStepContext that = (CpsStepContext)((Object)o);
        return this.executionRef.equals((Object)that.executionRef) && this.id.equals(that.id);
    }

    public int hashCode() {
        int result = this.executionRef.hashCode();
        result = 31 * result + this.id.hashCode();
        return result;
    }

    public String toString() {
        StepDescriptor d;
        String function = null;
        if (this.node instanceof StepNode && (d = ((StepNode)this.node).getDescriptor()) != null) {
            function = d.getFunctionName();
        }
        return "CpsStepContext[" + this.id + ":" + function + "]:" + String.valueOf(this.executionRef);
    }

    @SuppressFBWarnings(value={"SE_INNER_CLASS"})
    private class ScheduleNextRun
    implements FutureCallback<Object>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private ScheduleNextRun() {
        }

        public void onSuccess(Object e) {
            CpsStepContext.this.scheduleNextRun();
        }

        public void onFailure(Throwable e) {
            CpsStepContext.this.scheduleNextRun();
        }
    }

    private static class BodyFailed
    extends CauseOfInterruption {
        private BodyFailed() {
        }

        public String getShortDescription() {
            return "Body of block-scoped step failed";
        }
    }

    private static final class AlreadyCompleted
    extends AssertionError {
        private AlreadyCompleted() {
        }

        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

