/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps.steps;

import com.google.common.util.concurrent.FutureCallback;
import groovy.lang.Script;
import hudson.FilePath;
import hudson.model.TaskListener;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.jenkinsci.plugins.workflow.cps.CpsCompilationErrorsException;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.CpsStepContext;
import org.jenkinsci.plugins.workflow.cps.CpsThread;
import org.jenkinsci.plugins.workflow.cps.replay.ReplayAction;
import org.jenkinsci.plugins.workflow.cps.steps.LoadStep;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.StepContext;

public class LoadStepExecution
extends AbstractStepExecutionImpl {
    private transient LoadStep step;
    private static final long serialVersionUID = 1L;

    LoadStepExecution(LoadStep step, StepContext context) {
        super(context);
        this.step = step;
    }

    public boolean start() throws Exception {
        Script script;
        CpsStepContext cps = (CpsStepContext)this.getContext();
        FilePath cwd = (FilePath)cps.get(FilePath.class);
        TaskListener listener = (TaskListener)cps.get(TaskListener.class);
        CpsThread t = CpsThread.current();
        CpsFlowExecution execution = t.getExecution();
        String text = cwd.child(this.step.getPath()).readToString();
        String clazz = execution.getNextScriptName(this.step.getPath());
        String newText = ReplayAction.replace(execution, clazz);
        if (newText != null) {
            listener.getLogger().println("Replacing Groovy text with edited version");
            text = newText;
        }
        try {
            script = execution.getShell().parse(text);
        }
        catch (MultipleCompilationErrorsException e) {
            throw new CpsCompilationErrorsException(e);
        }
        cps.newBodyInvoker(t.getGroup().export(script), true).withDisplayName(this.step.getPath()).withCallback(BodyExecutionCallback.wrap((FutureCallback)cps)).start();
        return false;
    }

    public void onResume() {
    }
}

