/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionPoint;
import hudson.model.Item;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.workflow.cps.Messages;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;

public abstract class SnippetizerLink
implements ExtensionPoint {
    private static final Logger LOGGER = Logger.getLogger(SnippetizerLink.class.getName());

    @NonNull
    public abstract String getUrl();

    @NonNull
    public final String getDisplayUrl() {
        String u = this.getUrl();
        try {
            if (new URI(u).isAbsolute()) {
                return u;
            }
        }
        catch (URISyntaxException e) {
            LOGGER.log(Level.WARNING, "Failed to parse URL for " + u, e);
            return "";
        }
        StaplerRequest2 req = Stapler.getCurrentRequest2();
        if (req == null) {
            return u;
        }
        Item i = (Item)req.findAncestorObject(Item.class);
        StringBuilder toAppend = new StringBuilder();
        toAppend.append(req.getContextPath());
        if (!req.getContextPath().endsWith("/")) {
            toAppend.append("/");
        }
        if (i == null) {
            toAppend.append(u);
        } else {
            toAppend.append(i.getUrl());
            if (!i.getUrl().endsWith("/")) {
                toAppend.append("/");
            }
            toAppend.append(u);
        }
        return toAppend.toString();
    }

    @NonNull
    public String getIcon() {
        return "icon-help icon-md";
    }

    @NonNull
    public abstract String getDisplayName();

    public boolean inNewWindow() {
        return false;
    }

    @Extension(ordinal=500.0)
    public static class GDSLLink
    extends SnippetizerLink {
        @Override
        @NonNull
        public String getUrl() {
            return "pipeline-syntax/gdsl";
        }

        @Override
        @NonNull
        public String getDisplayName() {
            return Messages.SnippetizerLink_GDSLLink_displayName();
        }

        @Override
        public boolean inNewWindow() {
            return true;
        }
    }

    @Extension(ordinal=600.0)
    public static class ExamplesLink
    extends SnippetizerLink {
        @Override
        @NonNull
        public String getUrl() {
            return "https://jenkins.io/doc/pipeline/examples/";
        }

        @Override
        @NonNull
        public String getDisplayName() {
            return Messages.SnippetizerLink_ExamplesLink_displayName();
        }
    }

    @Extension(ordinal=700.0)
    public static class OnlineDocsLink
    extends SnippetizerLink {
        @Override
        @NonNull
        public String getUrl() {
            return "https://jenkins.io/doc/pipeline/";
        }

        @Override
        @NonNull
        public String getDisplayName() {
            return Messages.SnippetizerLink_OnlineDocsLink_displayName();
        }

        @Override
        public boolean inNewWindow() {
            return true;
        }
    }

    @Extension(ordinal=800.0)
    public static class GlobalsReferenceLink
    extends SnippetizerLink {
        @Override
        @NonNull
        public String getUrl() {
            return "pipeline-syntax/globals";
        }

        @Override
        @NonNull
        public String getDisplayName() {
            return Messages.SnippetizerLink_GlobalsReferenceLink_displayName();
        }
    }

    @Extension(ordinal=900.0)
    public static class StepReferenceLink
    extends SnippetizerLink {
        @Override
        @NonNull
        public String getUrl() {
            return "pipeline-syntax/html";
        }

        @Override
        @NonNull
        public String getDisplayName() {
            return Messages.SnippetizerLink_StepReferenceLink_displayName();
        }
    }

    @Extension(ordinal=1000.0)
    public static class GeneratorLink
    extends SnippetizerLink {
        @Override
        @NonNull
        public String getUrl() {
            return "pipeline-syntax";
        }

        @Override
        @NonNull
        public String getIcon() {
            return "icon-gear2 icon-md";
        }

        @Override
        @NonNull
        public String getDisplayName() {
            return Messages.SnippetizerLink_GeneratorLink_displayName();
        }
    }
}

