/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import com.cloudbees.groovy.cps.impl.CallSiteBlock;
import com.cloudbees.groovy.cps.sandbox.DefaultInvoker;
import com.cloudbees.groovy.cps.sandbox.Invoker;
import com.cloudbees.groovy.cps.sandbox.SandboxInvoker;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import groovy.lang.Closure;
import groovy.lang.GroovyClassLoader;
import hudson.ExtensionList;
import java.util.Set;
import java.util.function.Supplier;
import jenkins.util.SystemProperties;
import org.jenkinsci.plugins.workflow.cps.CpsClosure2;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.CpsScript;
import org.jenkinsci.plugins.workflow.cps.CpsThreadGroup;
import org.jenkinsci.plugins.workflow.cps.EnvActionImpl;
import org.jenkinsci.plugins.workflow.cps.IgnoredInternalClasses;
import org.jenkinsci.plugins.workflow.cps.Messages;
import org.jenkinsci.plugins.workflow.cps.Safepoint;
import org.jenkinsci.plugins.workflow.support.steps.build.RunWrapper;

final class LoggingInvoker
implements Invoker {
    private final Invoker delegate;
    private static final Set<Class<?>> IGNORED = Set.of(Safepoint.class, CpsClosure2.class, EnvActionImpl.class, RunWrapper.class);
    private static final Set<String> CLOSURE_METAPROPS = Set.of("delegate", "directive", "resolveStrategy");

    public static Invoker create(boolean sandbox) {
        SandboxInvoker delegate = sandbox ? new SandboxInvoker() : new DefaultInvoker();
        return SystemProperties.getBoolean((String)(LoggingInvoker.class.getName() + ".enabled"), (boolean)true) ? new LoggingInvoker((Invoker)delegate) : delegate;
    }

    private LoggingInvoker(Invoker delegate) {
        this.delegate = delegate;
    }

    private void record(String call) {
        CpsThreadGroup g = CpsThreadGroup.current();
        if (g == null) {
            assert (false) : "should never happen";
            return;
        }
        CpsFlowExecution execution = g.getExecution();
        if (execution == null) {
            assert (false) : "should never happen";
            return;
        }
        execution.recordInternalCall(call);
    }

    private static boolean isInternal(Class<?> clazz) {
        if (IGNORED.contains(clazz)) {
            return false;
        }
        if (ExtensionList.lookup(IgnoredInternalClasses.class).stream().anyMatch(iic -> iic.ignore(clazz))) {
            return false;
        }
        if (clazz.getClassLoader() instanceof GroovyClassLoader) {
            return false;
        }
        String name = clazz.getName();
        if (name.startsWith("com.cloudbees.groovy.cps.") || name.startsWith("org.jenkinsci.plugins.workflow.cps.persistence.IteratorHack$")) {
            return false;
        }
        return name.contains("jenkins") || name.contains("hudson") || name.contains("cloudbees");
    }

    private void maybeRecord(Class<?> clazz, Supplier<String> message) {
        if (LoggingInvoker.isInternal(clazz)) {
            this.record(message.get());
        }
    }

    @NonNull
    private static Class<?> classOf(@CheckForNull Object receiver) {
        if (receiver == null) {
            return Void.class;
        }
        if (receiver instanceof Class) {
            return (Class)receiver;
        }
        return receiver.getClass();
    }

    public Object methodCall(Object receiver, String method, Object[] args) throws Throwable {
        Class<?> clazz = LoggingInvoker.classOf(receiver);
        this.maybeRecord(clazz, () -> clazz.getName() + "." + method);
        return this.delegate.methodCall(receiver, method, args);
    }

    public Object constructorCall(Class lhs, Object[] args) throws Throwable {
        this.maybeRecord(lhs, () -> lhs.getName() + ".<init>");
        return this.delegate.constructorCall(lhs, args);
    }

    public Object superCall(Class senderType, Object receiver, String method, Object[] args) throws Throwable {
        this.maybeRecord(senderType, () -> senderType.getName() + "." + method);
        return this.delegate.superCall(senderType, receiver, method, args);
    }

    public Object getProperty(Object lhs, String name) throws Throwable {
        Class<?> clazz = LoggingInvoker.classOf(lhs);
        this.maybeRecord(clazz, () -> clazz.getName() + "." + name);
        return this.delegate.getProperty(lhs, name);
    }

    public void setProperty(Object lhs, String name, Object value) throws Throwable {
        block3: {
            Object receiver;
            Class<?> clazz = LoggingInvoker.classOf(lhs);
            this.maybeRecord(clazz, () -> clazz.getName() + "." + name);
            this.delegate.setProperty(lhs, name, value);
            if (SystemProperties.getBoolean((String)(LoggingInvoker.class.getName() + ".fieldSetWarning"), (boolean)true) && value != null && !CLOSURE_METAPROPS.contains(name) && !name.startsWith("__model__") && (receiver = this.findReceiver(lhs)) instanceof CpsScript) {
                try {
                    receiver.getClass().getDeclaredField(name);
                }
                catch (NoSuchFieldException x) {
                    CpsFlowExecution e;
                    CpsThreadGroup g = CpsThreadGroup.current();
                    if (g == null || (e = g.getExecution()) == null) break block3;
                    e.getOwner().getListener().getLogger().println(Messages.LoggingInvoker_field_set(receiver.getClass().getSimpleName(), name, value.getClass().getSimpleName()));
                }
            }
        }
    }

    private Object findReceiver(Object o) {
        if (o instanceof Closure) {
            Closure c = (Closure)o;
            return switch (c.getResolveStrategy()) {
                case 3 -> this.findReceiver(c.getDelegate());
                case 2 -> this.findReceiver(c.getOwner());
                case 4 -> c;
                case 1 -> {
                    Object delegate = c.getDelegate();
                    if (delegate == null) {
                        yield this.findReceiver(c.getOwner());
                    }
                    yield this.findReceiver(delegate);
                }
                default -> this.findReceiver(c.getOwner());
            };
        }
        return o;
    }

    public Object getAttribute(Object lhs, String name) throws Throwable {
        Class<?> clazz = LoggingInvoker.classOf(lhs);
        this.maybeRecord(clazz, () -> clazz.getName() + "." + name);
        return this.delegate.getAttribute(lhs, name);
    }

    public void setAttribute(Object lhs, String name, Object value) throws Throwable {
        Class<?> clazz = LoggingInvoker.classOf(lhs);
        this.maybeRecord(clazz, () -> clazz.getName() + "." + name);
        this.delegate.setAttribute(lhs, name, value);
    }

    public Object getArray(Object lhs, Object index) throws Throwable {
        return this.delegate.getArray(lhs, index);
    }

    public void setArray(Object lhs, Object index, Object value) throws Throwable {
        this.delegate.setArray(lhs, index, value);
    }

    public Object methodPointer(Object lhs, String name) {
        Class<?> clazz = LoggingInvoker.classOf(lhs);
        this.maybeRecord(clazz, () -> clazz.getName() + "." + name);
        return this.delegate.methodPointer(lhs, name);
    }

    public Object cast(Object value, Class<?> type, boolean ignoreAutoboxing, boolean coerce, boolean strict) throws Throwable {
        return this.delegate.cast(value, type, ignoreAutoboxing, coerce, strict);
    }

    public Invoker contextualize(CallSiteBlock tags) {
        Invoker contextualized = this.delegate.contextualize(tags);
        return contextualized instanceof LoggingInvoker ? contextualized : new LoggingInvoker(contextualized);
    }
}

