/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps.persistence;

import com.cloudbees.groovy.cps.impl.Caller;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;

public class IteratorHack {
    public static <E> Iterator<E> iterator(List<E> list) {
        return new Itr<E>(list);
    }

    public static <E> Iterator<E> iterator(Set<E> set) {
        return new Itr<E>(new ArrayList<E>(set));
    }

    public static <E> Iterator<E> iterator(E[] array) {
        return new Itr<E>(Arrays.asList(array));
    }

    public static <E> Iterator<E> iterator(Deque deque) {
        return new Itr(new ArrayList(deque));
    }

    public static <E> ListIterator<E> listIterator(List<E> list) {
        if (!Caller.isAsynchronous(list, (String)"listIterator") && !Caller.isAsynchronous(IteratorHack.class, (String)"listIterator", list)) {
            return list.listIterator();
        }
        return new ListItr<E>(list, 0);
    }

    public static <E> ListIterator<E> listIterator(List<E> list, int idx) {
        if (!Caller.isAsynchronous(list, (String)"listIterator", (Object)idx) && !Caller.isAsynchronous(IteratorHack.class, (String)"listIterator", list, (Object)idx)) {
            return list.listIterator(idx);
        }
        return new ListItr<E>(list, idx);
    }

    public static <K, V> Set<Map.Entry<K, V>> entrySet(Map<K, V> map) {
        if (!Caller.isAsynchronous(map, (String)"entrySet") && !Caller.isAsynchronous(IteratorHack.class, (String)"entrySet", map)) {
            return map.entrySet();
        }
        LinkedHashSet<Map.Entry<K, V>> entries = new LinkedHashSet<Map.Entry<K, V>>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            entries.add(new AbstractMap.SimpleImmutableEntry<K, V>(entry));
        }
        return entries;
    }

    public static <K, V> Set<Map.Entry<K, V>> entrySet(SortedMap<K, V> map) {
        return IteratorHack.entrySet(map);
    }

    public static <K> Set<K> keySet(Map<K, ?> map) {
        if (!Caller.isAsynchronous(map, (String)"keySet") && !Caller.isAsynchronous(IteratorHack.class, (String)"keySet", map)) {
            return map.keySet();
        }
        return new LinkedHashSet<K>(map.keySet());
    }

    public static <K> Set<K> keySet(SortedMap<K, ?> map) {
        return IteratorHack.keySet(map);
    }

    public static <V> Collection<V> values(Map<?, V> map) {
        if (!Caller.isAsynchronous(map, (String)"values") && !Caller.isAsynchronous(IteratorHack.class, (String)"values", map)) {
            return map.values();
        }
        return new ArrayList<V>(map.values());
    }

    public static <V> Collection<V> values(SortedMap<?, V> map) {
        return IteratorHack.values(map);
    }

    private IteratorHack() {
    }

    private static class Itr<E>
    implements Iterator<E>,
    Serializable {
        private static final long serialVersionUID = 1L;
        final List<E> list;
        int cursor = 0;
        int lastRet = -1;

        Itr(List<E> list) {
            this.list = list;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != this.list.size();
        }

        @Override
        public E next() {
            try {
                int i = this.cursor;
                E next = this.list.get(i);
                this.lastRet = i;
                this.cursor = i + 1;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            try {
                this.list.remove(this.lastRet);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private static final class ListItr<E>
    extends Itr<E>
    implements ListIterator<E> {
        private static final long serialVersionUID = 1L;

        ListItr(List<E> list, int idx) {
            super(list);
            this.cursor = idx;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public E previous() {
            try {
                if (this.cursor == 0) {
                    throw new NoSuchElementException();
                }
                --this.cursor;
                this.lastRet = this.cursor;
                return this.list.get(this.lastRet);
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void set(E e) {
            this.list.set(this.lastRet, e);
        }

        @Override
        public void add(E e) {
            this.list.add(this.cursor, e);
            ++this.cursor;
            this.lastRet = -1;
        }
    }
}

