/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Functions;
import hudson.model.Action;
import hudson.model.Computer;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.slaves.WorkspaceList;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMFileSystem;
import jenkins.security.HMACConfidentialKey;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.CpsFlowFactoryAction2;
import org.jenkinsci.plugins.workflow.flow.DurabilityHintProvider;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinitionDescriptor;
import org.jenkinsci.plugins.workflow.flow.FlowDurabilityHint;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.flow.GlobalDefaultFlowDurabilityLevel;
import org.jenkinsci.plugins.workflow.steps.scm.GenericSCMStep;
import org.jenkinsci.plugins.workflow.support.actions.WorkspaceActionImpl;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;

public class CpsScmFlowDefinition
extends FlowDefinition {
    private static final HMACConfidentialKey CHECKOUT_DIR_KEY = new HMACConfidentialKey(CpsScmFlowDefinition.class, "filePathWithSuffix", 32);
    private final SCM scm;
    private final String scriptPath;
    private boolean lightweight;

    @DataBoundConstructor
    public CpsScmFlowDefinition(SCM scm, String scriptPath) {
        this.scm = scm;
        this.scriptPath = scriptPath.trim();
    }

    public SCM getScm() {
        return this.scm;
    }

    public Collection<? extends SCM> getSCMs() {
        return Collections.singletonList(this.scm);
    }

    public String getScriptPath() {
        return this.scriptPath;
    }

    public boolean isLightweight() {
        return this.lightweight;
    }

    @DataBoundSetter
    public void setLightweight(boolean lightweight) {
        this.lightweight = lightweight;
    }

    public CpsFlowExecution create(FlowExecutionOwner owner, TaskListener listener, List<? extends Action> actions) throws Exception {
        FilePath acquiredDir;
        FilePath dir;
        for (Action action : actions) {
            if (!(action instanceof CpsFlowFactoryAction2)) continue;
            return ((CpsFlowFactoryAction2)action).create(this, owner, actions);
        }
        Queue.Executable _build = owner.getExecutable();
        if (!(_build instanceof Run)) {
            throw new IOException("can only check out SCM into a Run");
        }
        Run run = (Run)_build;
        String expandedScriptPath = run.getEnvironment(listener).expand(this.scriptPath);
        if (this.isLightweight()) {
            try (SCMFileSystem fs = SCMFileSystem.of((Item)run.getParent(), (SCM)this.scm, null, (Run)run);){
                if (fs != null) {
                    try {
                        String script = fs.child(expandedScriptPath).contentAsString();
                        listener.getLogger().println("Obtained " + expandedScriptPath + " from " + this.scm.getKey());
                        Queue.Executable exec = owner.getExecutable();
                        FlowDurabilityHint hint = exec instanceof Run ? DurabilityHintProvider.suggestedFor((Item)((Run)exec).getParent()) : GlobalDefaultFlowDurabilityLevel.getDefaultDurabilityHint();
                        CpsFlowExecution cpsFlowExecution = new CpsFlowExecution(script, true, owner, hint);
                        return cpsFlowExecution;
                    }
                    catch (FileNotFoundException e) {
                        throw new AbortException("Unable to find " + expandedScriptPath + " from " + this.scm.getKey());
                    }
                }
                listener.getLogger().println("Lightweight checkout support not available, falling back to full checkout.");
            }
        }
        Jenkins node = Jenkins.get();
        if (run.getParent() instanceof TopLevelItem) {
            FilePath baseWorkspace = node.getWorkspaceFor((TopLevelItem)run.getParent());
            if (baseWorkspace == null) {
                throw new IOException(node.getDisplayName() + " may be offline");
            }
            dir = this.getFilePathWithSuffix(baseWorkspace, this.scm);
        } else {
            dir = new FilePath(owner.getRootDir());
        }
        listener.getLogger().println("Checking out " + this.scm.getKey() + " into " + String.valueOf(dir) + " to read " + expandedScriptPath);
        String script = null;
        Computer computer = node.toComputer();
        if (computer == null) {
            throw new IOException(node.getDisplayName() + " may be offline");
        }
        GenericSCMStep delegate = new GenericSCMStep(this.scm);
        delegate.setPoll(true);
        delegate.setChangelog(true);
        try (WorkspaceList.Lease lease = computer.getWorkspaceList().acquire(dir);){
            FilePath scriptFile;
            dir.withSuffix("-scm-key.txt").write(this.scm.getKey(), "UTF-8");
            for (int retryCount = Jenkins.get().getScmCheckoutRetryCount(); retryCount >= 0; --retryCount) {
                try {
                    delegate.checkout(run, dir, listener, node.createLauncher(listener));
                    break;
                }
                catch (AbortException e) {
                    if (e.getMessage() != null) {
                        listener.error(e.getMessage());
                    }
                }
                catch (InterruptedIOException e) {
                    throw e;
                }
                catch (Exception e) {
                    Functions.printStackTrace((Throwable)e, (PrintWriter)listener.error("Checkout failed"));
                }
                if (retryCount == 0) {
                    throw new AbortException("Maximum checkout retry attempts reached, aborting");
                }
                listener.getLogger().println("Retrying after 10 seconds");
                Thread.sleep(10000L);
            }
            if (!new File((scriptFile = dir.child(expandedScriptPath)).getRemote()).getCanonicalFile().toPath().startsWith(new File(dir.getRemote()).getCanonicalPath())) {
                throw new IOException(String.valueOf(scriptFile) + " references a file that is not inside " + String.valueOf(dir));
            }
            if (!scriptFile.exists()) {
                throw new AbortException(String.valueOf(scriptFile) + " not found");
            }
            script = scriptFile.readToString();
            acquiredDir = lease.path;
        }
        Queue.Executable queueExec = owner.getExecutable();
        FlowDurabilityHint hint = queueExec instanceof Run ? DurabilityHintProvider.suggestedFor((Item)((Run)queueExec).getParent()) : GlobalDefaultFlowDurabilityLevel.getDefaultDurabilityHint();
        CpsFlowExecution exec = new CpsFlowExecution(script, true, owner, hint);
        exec.flowStartNodeActions.add((Action)new WorkspaceActionImpl(acquiredDir, null));
        return exec;
    }

    private FilePath getFilePathWithSuffix(FilePath baseWorkspace, SCM scm) {
        return baseWorkspace.withSuffix(this.getFilePathSuffix() + "script").child(CHECKOUT_DIR_KEY.mac(scm.getKey()));
    }

    private String getFilePathSuffix() {
        return System.getProperty(WorkspaceList.class.getName(), "@");
    }

    @Extension
    public static class DescriptorImpl
    extends FlowDefinitionDescriptor {
        public String getDisplayName() {
            return "Pipeline script from SCM";
        }

        public Collection<? extends SCMDescriptor<?>> getApplicableDescriptors() {
            StaplerRequest2 req = Stapler.getCurrentRequest2();
            Job job = req != null ? (Job)req.findAncestorObject(Job.class) : null;
            return SCM._for((Job)job).stream().filter(d -> !"org.jenkinsci.plugins.multiplescms.MultiSCM".equals(d.getId())).collect(Collectors.toList());
        }
    }
}

