/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import hudson.util.StreamTaskListener;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.codehaus.groovy.control.CompilationFailedException;
import org.jenkinsci.plugins.scriptsecurity.scripts.ApprovalContext;
import org.jenkinsci.plugins.scriptsecurity.scripts.ScriptApproval;
import org.jenkinsci.plugins.scriptsecurity.scripts.languages.GroovyLanguage;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinitionValidator;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.CpsFlowFactoryAction;
import org.jenkinsci.plugins.workflow.cps.CpsFlowFactoryAction2;
import org.jenkinsci.plugins.workflow.cps.CpsGroovyShell;
import org.jenkinsci.plugins.workflow.cps.CpsGroovyShellFactory;
import org.jenkinsci.plugins.workflow.flow.DurabilityHintProvider;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinitionDescriptor;
import org.jenkinsci.plugins.workflow.flow.FlowDurabilityHint;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.flow.GlobalDefaultFlowDurabilityLevel;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class CpsFlowDefinition
extends FlowDefinition {
    private final String script;
    private final boolean sandbox;

    @Deprecated
    public CpsFlowDefinition(String script) throws Descriptor.FormException {
        this(script, false);
    }

    @DataBoundConstructor
    public CpsFlowDefinition(String script, boolean sandbox) throws Descriptor.FormException {
        ScriptApproval.validateSandbox((boolean)sandbox);
        StaplerRequest2 req = Stapler.getCurrentRequest2();
        this.script = sandbox ? script : ScriptApproval.get().configuring(script, GroovyLanguage.get(), ApprovalContext.create().withCurrentUser().withItemAsKey(req != null ? (Item)req.findAncestorObject(Item.class) : null), req == null);
        this.sandbox = sandbox;
    }

    private Object readResolve() {
        if (!this.sandbox) {
            ScriptApproval.get().configuring(this.script, GroovyLanguage.get(), ApprovalContext.create(), true);
        }
        return this;
    }

    public String getScript() {
        return this.script;
    }

    public boolean isSandbox() {
        return this.sandbox;
    }

    public CpsFlowExecution create(FlowExecutionOwner handle, Action ... actions) throws IOException {
        return this.create(handle, (TaskListener)StreamTaskListener.fromStderr(), List.of(actions));
    }

    public CpsFlowExecution create(FlowExecutionOwner owner, TaskListener listener, List<? extends Action> actions) throws IOException {
        for (Action action : actions) {
            if (action instanceof CpsFlowFactoryAction) {
                CpsFlowFactoryAction fa = (CpsFlowFactoryAction)action;
                return fa.create(this, owner, actions);
            }
            if (!(action instanceof CpsFlowFactoryAction2)) continue;
            return ((CpsFlowFactoryAction2)action).create(this, owner, actions);
        }
        Queue.Executable exec = owner.getExecutable();
        FlowDurabilityHint flowDurabilityHint = exec instanceof Run ? DurabilityHintProvider.suggestedFor((Item)((Run)exec).getParent()) : GlobalDefaultFlowDurabilityLevel.getDefaultDurabilityHint();
        return new CpsFlowExecution(this.sandbox ? this.script : ScriptApproval.get().using(this.script, GroovyLanguage.get()), this.sandbox, owner, flowDurabilityHint);
    }

    @Extension
    public static class DescriptorImpl
    extends FlowDefinitionDescriptor {
        public FlowDefinition newInstance(@NonNull StaplerRequest2 req, @NonNull JSONObject formData) throws Descriptor.FormException {
            if (Util.isOverridden(FlowDefinitionDescriptor.class, ((Object)((Object)this)).getClass(), (String)"newInstance", (Class[])new Class[]{StaplerRequest.class, JSONObject.class})) {
                return this.newInstance(StaplerRequest.fromStaplerRequest2((StaplerRequest2)req), formData);
            }
            CpsFlowDefinition cpsFlowDefinition = (CpsFlowDefinition)super.newInstance(req, formData);
            return this.newInstanceImpl(cpsFlowDefinition, req, formData);
        }

        @Deprecated
        public FlowDefinition newInstance(@NonNull StaplerRequest req, @NonNull JSONObject formData) throws Descriptor.FormException {
            CpsFlowDefinition cpsFlowDefinition = (CpsFlowDefinition)super.newInstance(req, formData);
            return this.newInstanceImpl(cpsFlowDefinition, StaplerRequest.toStaplerRequest2((StaplerRequest)req), formData);
        }

        private FlowDefinition newInstanceImpl(CpsFlowDefinition cpsFlowDefinition, @NonNull StaplerRequest2 req, @NonNull JSONObject formData) {
            if (!cpsFlowDefinition.sandbox && formData.get("oldScript") != null) {
                boolean approveIfAdmin;
                String oldScript = formData.getString("oldScript");
                boolean bl = approveIfAdmin = !Objects.equals(oldScript, cpsFlowDefinition.script);
                if (approveIfAdmin) {
                    ScriptApproval.get().configuring(cpsFlowDefinition.script, GroovyLanguage.get(), ApprovalContext.create().withCurrentUser().withItemAsKey((Item)req.findAncestorObject(Item.class)), true);
                }
            }
            return cpsFlowDefinition;
        }

        public String getDisplayName() {
            return "Pipeline script";
        }

        @RequirePOST
        public FormValidation doCheckScript(@QueryParameter String value, @QueryParameter String oldScript, @QueryParameter boolean sandbox) {
            return sandbox ? FormValidation.ok() : ScriptApproval.get().checking(value, GroovyLanguage.get(), !Objects.equals(oldScript, value));
        }

        @RequirePOST
        public JSON doCheckScriptCompile(@AncestorInPath Item job, @QueryParameter String value) {
            if (!job.hasPermission(Job.CONFIGURE)) {
                return CpsFlowDefinitionValidator.CheckStatus.SUCCESS.asJSON();
            }
            try {
                CpsGroovyShell trusted = new CpsGroovyShellFactory(null).forTrusted().build();
                new CpsGroovyShellFactory(null).withParent(trusted).withSandbox(true).build().getClassLoader().parseClass(value);
            }
            catch (CompilationFailedException x) {
                return JSONArray.fromObject((Object)CpsFlowDefinitionValidator.toCheckStatus(x).toArray());
            }
            return CpsFlowDefinitionValidator.CheckStatus.SUCCESS.asJSON();
        }

        @Restricted(value={NoExternalUse.class})
        public boolean shouldHideSandbox(@CheckForNull CpsFlowDefinition instance) {
            return ScriptApproval.shouldHideSandbox((Object)((Object)instance), CpsFlowDefinition::isSandbox);
        }
    }
}

