/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.groovy.cps.impl;

import com.cloudbees.groovy.cps.Env;
import com.cloudbees.groovy.cps.impl.ProxyEnv;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class BlockScopeEnv
extends ProxyEnv {
    private Map<String, Object> locals;
    private Map<String, Class> types;
    private static final long serialVersionUID = 1L;

    public BlockScopeEnv(Env parent) {
        this(parent, 0);
    }

    public BlockScopeEnv(Env parent, int localsSize) {
        super(parent);
        if (localsSize <= 0) {
            this.locals = Collections.EMPTY_MAP;
            this.types = Collections.EMPTY_MAP;
        } else {
            this.locals = Maps.newHashMapWithExpectedSize((int)localsSize);
            this.types = Maps.newHashMapWithExpectedSize((int)localsSize);
        }
    }

    @Override
    public void declareVariable(Class type, String name) {
        if (this.locals == Collections.EMPTY_MAP) {
            this.locals = new HashMap<String, Object>(2);
        }
        this.locals.put(name, null);
        if (this.types == null || this.types == Collections.EMPTY_MAP) {
            this.types = new HashMap<String, Class>(2);
        }
        this.types.put(name, type);
    }

    @Override
    public Object getLocalVariable(String name) {
        if (this.locals.containsKey(name)) {
            return this.locals.get(name);
        }
        return this.parent.getLocalVariable(name);
    }

    private Map<String, Class> getTypes() {
        if (this.types == null) {
            this.types = Collections.EMPTY_MAP;
        }
        return this.types;
    }

    @Override
    public Class getLocalVariableType(String name) {
        return this.locals.containsKey(name) ? this.getTypes().get(name) : this.parent.getLocalVariableType(name);
    }

    @Override
    public void setLocalVariable(String name, Object value) {
        if (this.locals.containsKey(name)) {
            this.locals.put(name, value);
        } else {
            this.parent.setLocalVariable(name, value);
        }
    }
}

