/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps.actions;

import com.google.common.collect.Maps;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import groovy.lang.GroovyClassLoader;
import hudson.EnvVars;
import hudson.model.Describable;
import hudson.model.Result;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.structs.describable.DescribableModel;
import org.jenkinsci.plugins.structs.describable.UninstantiatedDescribable;
import org.jenkinsci.plugins.workflow.actions.ArgumentsAction;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class ArgumentsActionImpl
extends ArgumentsAction {
    @CheckForNull
    private Map<String, Object> arguments;
    private final Set<String> sensitiveVariables;
    boolean isUnmodifiedBySanitization = true;
    private static final Logger LOGGER = Logger.getLogger(ArgumentsActionImpl.class.getName());

    public ArgumentsActionImpl(@NonNull Map<String, Object> stepArguments, @CheckForNull EnvVars env, @NonNull Set<String> sensitiveVariables) {
        this.sensitiveVariables = new HashSet<String>(sensitiveVariables);
        this.arguments = this.serializationCheck(this.sanitizeStepArguments(stepArguments, env));
    }

    public ArgumentsActionImpl(@NonNull Map<String, Object> stepArguments) {
        this(stepArguments, new EnvVars(), Collections.emptySet());
    }

    ArgumentsActionImpl(@NonNull Set<String> sensitiveVariables) {
        this.isUnmodifiedBySanitization = true;
        this.arguments = Collections.emptyMap();
        this.sensitiveVariables = sensitiveVariables;
    }

    public static String replaceSensitiveVariables(@NonNull String input, @CheckForNull EnvVars variables, @NonNull Set<String> sensitiveVariables) {
        if (variables == null || variables.size() == 0 || sensitiveVariables.size() == 0) {
            return input;
        }
        String modded = input;
        for (String sensitive : sensitiveVariables) {
            String sensitiveValue = variables.get(sensitive, "");
            if (sensitiveValue.isEmpty()) continue;
            modded = modded.replace((CharSequence)variables.get((Object)sensitive), "${" + sensitive + "}");
        }
        return modded;
    }

    boolean isStorableType(Object ob) {
        if (ob == null) {
            return true;
        }
        if (ob instanceof CharSequence || ob instanceof Number || ob instanceof Boolean || ob instanceof Map || ob instanceof List || ob instanceof UninstantiatedDescribable || ob instanceof URL || ob instanceof Result) {
            return true;
        }
        if (ob instanceof Enum) {
            Class enumClass = ((Enum)ob).getDeclaringClass();
            return !(enumClass.getClassLoader() instanceof GroovyClassLoader);
        }
        Class<?> c = ob.getClass();
        return c.isPrimitive() || c.isArray() && !c.getComponentType().isPrimitive();
    }

    @CheckForNull
    Object sanitizeListAndRecordMutation(@NonNull List objects, @CheckForNull EnvVars variables) {
        if (ArgumentsActionImpl.isOversized((Object)objects)) {
            this.isUnmodifiedBySanitization = false;
            return ArgumentsAction.NotStoredReason.OVERSIZE_VALUE;
        }
        boolean isMutated = false;
        ArrayList<Object> output = new ArrayList<Object>(objects.size());
        long size = objects.size();
        for (Object o : objects) {
            Object modded = this.sanitizeObjectAndRecordMutation(o, variables);
            if ((size += ArgumentsActionImpl.shallowSize(modded)) > (long)MAX_RETAINED_LENGTH) {
                this.isUnmodifiedBySanitization = false;
                return ArgumentsAction.NotStoredReason.OVERSIZE_VALUE;
            }
            if (modded != o) {
                output.add(modded);
                isMutated = true;
                continue;
            }
            output.add(o);
        }
        return isMutated ? output : objects;
    }

    @CheckForNull
    Object sanitizeArrayAndRecordMutation(@NonNull Object[] objects, @CheckForNull EnvVars variables) {
        if (ArgumentsActionImpl.isOversized((Object)objects)) {
            this.isUnmodifiedBySanitization = false;
            return ArgumentsAction.NotStoredReason.OVERSIZE_VALUE;
        }
        List<Object> inputList = Arrays.asList(objects);
        Object sanitized = this.sanitizeListAndRecordMutation(inputList, variables);
        if (sanitized == inputList) {
            return objects;
        }
        if (sanitized instanceof List) {
            return ((List)sanitized).toArray();
        }
        return sanitized;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CheckForNull
    Object sanitizeObjectAndRecordMutation(@CheckForNull Object o, @CheckForNull EnvVars vars) {
        Object tempVal = o;
        DescribableModel m = null;
        if (tempVal instanceof Step) {
            m = DescribableModel.of(tempVal.getClass());
            tempVal = ((Step)tempVal).getDescriptor().defineArguments((Step)tempVal);
        } else if (tempVal instanceof UninstantiatedDescribable) {
            tempVal = ((UninstantiatedDescribable)tempVal).toMap();
        } else if (tempVal instanceof Describable) {
            try {
                m = DescribableModel.of(tempVal.getClass());
                tempVal = m.uninstantiate2(o).toMap();
            }
            catch (RuntimeException x) {
                LOGGER.log(Level.FINE, "failed to store " + String.valueOf(tempVal), x);
                this.isUnmodifiedBySanitization = false;
                return ArgumentsAction.NotStoredReason.UNSERIALIZABLE;
            }
        }
        if (ArgumentsActionImpl.isOversized((Object)tempVal)) {
            this.isUnmodifiedBySanitization = false;
            return ArgumentsAction.NotStoredReason.OVERSIZE_VALUE;
        }
        if (!this.isStorableType(tempVal)) {
            this.isUnmodifiedBySanitization = false;
            return ArgumentsAction.NotStoredReason.UNSERIALIZABLE;
        }
        Object modded = tempVal;
        if (modded instanceof Map) {
            modded = this.sanitizeMapAndRecordMutation((Map)modded, vars, false);
        } else if (modded instanceof List) {
            modded = this.sanitizeListAndRecordMutation((List)modded, vars);
        } else if (modded != null && modded.getClass().isArray()) {
            Class<?> componentType = modded.getClass().getComponentType();
            if (componentType.isPrimitive()) {
                this.isUnmodifiedBySanitization = true;
                return ArgumentsAction.NotStoredReason.UNSERIALIZABLE;
            }
            modded = this.sanitizeArrayAndRecordMutation((Object[])modded, vars);
        } else {
            if (modded instanceof String && ((String)modded).contains("\u0000")) {
                this.isUnmodifiedBySanitization = false;
                return "<contains ASCII NUL>";
            }
            if (modded instanceof String && vars != null && !vars.isEmpty()) {
                String replaced = ArgumentsActionImpl.replaceSensitiveVariables((String)modded, vars, this.sensitiveVariables);
                if (replaced.equals(modded)) return replaced;
                this.isUnmodifiedBySanitization = false;
                return replaced;
            }
        }
        if (modded != tempVal) {
            this.isUnmodifiedBySanitization = false;
            if (o instanceof Describable && !(o instanceof Step)) {
                UninstantiatedDescribable rawUd = m.uninstantiate2(o);
                return new UninstantiatedDescribable(rawUd.getSymbol(), rawUd.getKlass(), (Map)modded);
            }
            if (!(o instanceof UninstantiatedDescribable)) return modded;
            UninstantiatedDescribable ud = (UninstantiatedDescribable)o;
            return new UninstantiatedDescribable(ud.getSymbol(), ud.getKlass(), (Map)modded);
        }
        if (!(o instanceof Describable)) return o;
        if (!(tempVal instanceof Map)) return o;
        return m.uninstantiate2(o);
    }

    Map<String, Object> serializationCheck(@NonNull Map<String, Object> arguments) {
        boolean isMutated = false;
        HashMap out = Maps.newHashMapWithExpectedSize((int)arguments.size());
        for (Map.Entry<String, Object> entry : arguments.entrySet()) {
            Object val = entry.getValue();
            try {
                if (!(val == null || val instanceof String || val instanceof Boolean || val instanceof Number || val instanceof ArgumentsAction.NotStoredReason || val instanceof TimeUnit)) {
                    Jenkins.XSTREAM2.toXMLUTF8(entry.getValue(), OutputStream.nullOutputStream());
                }
                out.put(entry.getKey(), entry.getValue());
            }
            catch (Exception ex) {
                out.put(entry.getKey(), ArgumentsAction.NotStoredReason.UNSERIALIZABLE);
                isMutated = true;
                LOGGER.log(Level.FINE, "Failed to serialize argument " + entry.getKey(), ex);
            }
        }
        if (isMutated) {
            this.isUnmodifiedBySanitization = false;
        }
        return out;
    }

    @NonNull
    Object sanitizeMapAndRecordMutation(@NonNull Map<String, Object> mapContents, @CheckForNull EnvVars variables) {
        return this.sanitizeMapAndRecordMutation(mapContents, variables, false);
    }

    private Map<String, Object> sanitizeStepArguments(Map<String, Object> stepArguments, EnvVars env) {
        return (Map)this.sanitizeMapAndRecordMutation(stepArguments, env, true);
    }

    @NonNull
    private Object sanitizeMapAndRecordMutation(@NonNull Map<String, Object> mapContents, @CheckForNull EnvVars variables, boolean topLevel) {
        LinkedHashMap<String, Object> output = new LinkedHashMap<String, Object>(mapContents.size());
        long size = mapContents.size();
        boolean isMutated = false;
        for (Map.Entry<String, Object> param : mapContents.entrySet()) {
            Object modded = this.sanitizeObjectAndRecordMutation(param.getValue(), variables);
            if (!topLevel) {
                size += (long)param.getKey().length();
                if ((size += ArgumentsActionImpl.shallowSize(modded)) > (long)MAX_RETAINED_LENGTH) {
                    this.isUnmodifiedBySanitization = false;
                    return ArgumentsAction.NotStoredReason.OVERSIZE_VALUE;
                }
            }
            if (modded != param.getValue()) {
                output.put(param.getKey(), modded);
                isMutated = true;
                continue;
            }
            output.put(param.getKey(), param.getValue());
        }
        return isMutated ? output : mapContents;
    }

    static long shallowSize(Object o) {
        if (o == null) {
            return 0L;
        }
        if (o instanceof CharSequence) {
            return ((CharSequence)o).length();
        }
        if (o instanceof Collection) {
            Collection collection = (Collection)o;
            return collection.size();
        }
        if (o.getClass().isArray()) {
            Object[] array = (Object[])o;
            return array.length;
        }
        if (o instanceof Map) {
            Map map = (Map)o;
            return map.size();
        }
        return 1L;
    }

    static int getMaxRetainedLength() {
        return MAX_RETAINED_LENGTH;
    }

    @NonNull
    protected Map<String, Object> getArgumentsInternal() {
        return this.arguments == null ? Collections.EMPTY_MAP : this.arguments;
    }

    public boolean isUnmodifiedArguments() {
        return this.isUnmodifiedBySanitization;
    }
}

