/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.TimeUnit;
import org.jenkinsci.plugins.workflow.cps.CpsStepContext;
import org.jenkinsci.plugins.workflow.cps.CpsThread;
import org.jenkinsci.plugins.workflow.cps.CpsThreadGroup;
import org.jenkinsci.plugins.workflow.cps.FlowHead;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;

public final class CpsThreadDump {
    public final boolean valid;
    private final List<ThreadInfo> threads = new ArrayList<ThreadInfo>();
    public static final CpsThreadDump EMPTY = new CpsThreadDump(false);
    @Deprecated
    public static final CpsThreadDump UNKNOWN = CpsThreadDump.fromText("Program state is not yet known");

    private CpsThreadDump(boolean valid) {
        this.valid = valid;
    }

    public List<ThreadInfo> getThreads() {
        return Collections.unmodifiableList(this.threads);
    }

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"}, justification="Only used by tests anyway.")
    public void print(PrintStream ps) {
        this.print(new PrintWriter(ps, true));
    }

    public void print(PrintWriter w) {
        for (ThreadInfo t : this.threads) {
            t.print(w);
        }
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        this.print(new PrintWriter(sw));
        return sw.toString();
    }

    public static CpsThreadDump from(Throwable t) {
        CpsThreadDump td = new CpsThreadDump(false);
        td.threads.add(new ThreadInfo(t));
        return td;
    }

    public static CpsThreadDump from(CpsThreadGroup g) {
        LinkedHashMap<FlowHead, List> m = new LinkedHashMap<FlowHead, List>();
        for (CpsThread t : g.getThreads()) {
            List l = m.computeIfAbsent(t.head, unused -> new ArrayList());
            l.add(t);
        }
        CpsThreadDump td = new CpsThreadDump(true);
        for (List e : m.values()) {
            td.threads.add(new ThreadInfo(e));
        }
        return td;
    }

    @NonNull
    public static CpsThreadDump fromText(final @NonNull String text) {
        return CpsThreadDump.from(new Throwable(){

            @Override
            public String toString() {
                return text;
            }

            @Override
            public Throwable fillInStackTrace() {
                return this;
            }
        });
    }

    public static final class ThreadInfo {
        private final String headline;
        private final List<StackTraceElement> stack = new ArrayList<StackTraceElement>();
        private static final int MAX_STATUS_LENGTH = 1000;

        private ThreadInfo(List<CpsThread> e) {
            CpsThread head = e.get(e.size() - 1);
            this.headline = "Thread #" + head.id;
            ListIterator<CpsThread> itr = e.listIterator(e.size());
            while (itr.hasPrevious()) {
                StepDescriptor d;
                CpsThread t = itr.previous();
                StepExecution s = t.getStep();
                if (s != null && (d = ((CpsStepContext)s.getContext()).getStepDescriptor()) != null) {
                    Object status = s.getStatusBounded(3L, TimeUnit.SECONDS);
                    if (status != null) {
                        int len = ((String)status).length();
                        if (len > 1000) {
                            int half = 500;
                            status = String.valueOf(((String)status).subSequence(0, half)) + "\u2026[truncated " + (len - 1000) + " chars]\u2026" + String.valueOf(((String)status).subSequence(len - half, len));
                        }
                        this.stack.add(new StackTraceElement("DSL", d.getFunctionName(), (String)status, -1));
                    } else {
                        this.stack.add(new StackTraceElement("DSL", d.getFunctionName(), null, -2));
                    }
                }
                this.stack.addAll(t.getStackTrace());
            }
        }

        public ThreadInfo(Throwable t) {
            this.headline = t.toString();
            this.stack.addAll(List.of(t.getStackTrace()));
        }

        public List<StackTraceElement> getStackTrace() {
            return Collections.unmodifiableList(this.stack);
        }

        public String getHeadline() {
            return this.headline;
        }

        public void print(PrintWriter w) {
            w.println(this.headline);
            for (StackTraceElement e : this.stack) {
                w.println("\tat " + String.valueOf(e));
            }
        }

        public String toString() {
            StringWriter sw = new StringWriter();
            this.print(new PrintWriter(sw));
            return sw.toString();
        }
    }
}

