/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import com.cloudbees.groovy.cps.Continuable;
import com.cloudbees.groovy.cps.Outcome;
import com.google.common.util.concurrent.Futures;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import groovy.lang.Closure;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import hudson.ExtensionList;
import hudson.Functions;
import hudson.Main;
import hudson.Util;
import hudson.model.Action;
import hudson.model.Result;
import hudson.util.XStream2;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.util.Timer;
import org.jenkinsci.plugins.workflow.actions.ErrorAction;
import org.jenkinsci.plugins.workflow.cps.BodyReference;
import org.jenkinsci.plugins.workflow.cps.ContextVariableSet;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.CpsThread;
import org.jenkinsci.plugins.workflow.cps.CpsThreadDump;
import org.jenkinsci.plugins.workflow.cps.CpsVmExecutorService;
import org.jenkinsci.plugins.workflow.cps.CpsVmThreadOnly;
import org.jenkinsci.plugins.workflow.cps.FlowHead;
import org.jenkinsci.plugins.workflow.cps.StaticBodyReference;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.pickles.Pickle;
import org.jenkinsci.plugins.workflow.pickles.PickleFactory;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;
import org.jenkinsci.plugins.workflow.support.concurrent.WithThreadName;
import org.jenkinsci.plugins.workflow.support.pickles.SingleTypedPickleFactory;
import org.jenkinsci.plugins.workflow.support.pickles.serialization.RiverWriter;
import org.jenkinsci.plugins.workflow.support.storage.FlowNodeStorage;

public final class CpsThreadGroup
implements Serializable {
    private transient CpsFlowExecution execution;
    private volatile Map<Integer, CpsThread> threads;
    private transient NavigableMap<Integer, CpsThread> runtimeThreads;
    private int iota;
    transient ExecutorService runner;
    transient boolean busy;
    private transient AtomicBoolean pausedByQuietMode;
    private transient AtomicBoolean paused = new AtomicBoolean();
    private transient boolean terminating;
    private boolean executionPaused;
    public final Map<Integer, Closure> closures = new HashMap<Integer, Closure>();
    @CheckForNull
    private final List<Script> scripts = new ArrayList<Script>();
    private transient List<FlowNode> nodesToNotify;
    private static final Object nodesToNotifyLock = new Object();
    private static final Logger LOGGER = Logger.getLogger(CpsThreadGroup.class.getName());
    private static final long serialVersionUID = 1L;

    CpsThreadGroup(CpsFlowExecution execution) {
        this.execution = execution;
        this.setupTransients();
    }

    public CpsFlowExecution getExecution() {
        return this.execution;
    }

    void register(Script script) {
        if (this.scripts != null) {
            this.scripts.add(script);
        }
    }

    private Object readResolve() {
        this.execution = CpsFlowExecution.PROGRAM_STATE_SERIALIZATION.get();
        this.setupTransients();
        assert (this.execution != null);
        this.runtimeThreads.putAll(this.threads);
        if (this.scripts != null && !this.scripts.isEmpty()) {
            GroovyShell shell = this.execution.getShell();
            shell.getContext().getVariables().putAll(this.scripts.get(0).getBinding().getVariables());
            for (Script script : this.scripts) {
                script.setBinding(shell.getContext());
            }
        }
        if (this.paused == null) {
            this.paused = new AtomicBoolean(this.executionPaused);
        }
        return this;
    }

    private void setupTransients() {
        this.runtimeThreads = new ConcurrentSkipListMap<Integer, CpsThread>();
        this.runner = new CpsVmExecutorService(this);
        this.pausedByQuietMode = new AtomicBoolean();
    }

    private Object writeReplace() {
        this.threads = new HashMap<Integer, CpsThread>(this.runtimeThreads);
        return this;
    }

    @CpsVmThreadOnly
    public CpsThread addThread(@NonNull Continuable program, FlowHead head, ContextVariableSet contextVariables) {
        this.assertVmThread();
        CpsThread t = new CpsThread(this, this.iota++, program, head, contextVariables);
        this.runtimeThreads.put(t.id, t);
        return t;
    }

    private void assertVmThread() {
        assert (CpsThreadGroup.current() == this);
    }

    public CpsThread getThread(int id) {
        CpsThread thread = (CpsThread)this.runtimeThreads.get(id);
        if (thread == null && LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "no thread " + id + " among " + String.valueOf(this.runtimeThreads.keySet()), new IllegalStateException());
        }
        return thread;
    }

    public Iterable<CpsThread> getThreads() {
        return this.runtimeThreads.values();
    }

    @CpsVmThreadOnly(value="root")
    @NonNull
    public BodyReference export(@NonNull Closure body) {
        this.assertVmThread();
        int id = this.iota++;
        this.closures.put(id, body);
        LOGGER.log(Level.FINE, "exporting {0}", id);
        return new StaticBodyReference(id, body);
    }

    @CpsVmThreadOnly(value="root")
    @NonNull
    public BodyReference export(final @NonNull Script body) {
        this.register(body);
        return this.export(new Closure(null){

            public Object call() {
                return body.run();
            }
        });
    }

    @CpsVmThreadOnly(value="root")
    public void unexport(BodyReference ref) {
        this.assertVmThread();
        if (ref == null) {
            return;
        }
        if (this.closures.remove(ref.id) != null) {
            LOGGER.log(Level.FINE, "unexporting {0}", ref.id);
        } else if (this.closures.isEmpty()) {
            LOGGER.log(Level.FINE, "cannot unexport {0} but there are no closures at all so perhaps we are still trying to load the program", ref.id);
        } else {
            LOGGER.log(Level.WARNING, "double unexport of {0}", ref.id);
        }
    }

    public Future<?> scheduleRun() {
        final CompletableFuture f = new CompletableFuture();
        try {
            this.runner.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    final Jenkins j = Jenkins.getInstanceOrNull();
                    if (j != null && !j.isQuietingDown() && CpsThreadGroup.this.execution != null && CpsThreadGroup.this.pausedByQuietMode.compareAndSet(true, false)) {
                        try {
                            CpsThreadGroup.this.execution.getOwner().getListener().getLogger().println("Resuming (Shutdown was canceled)");
                        }
                        catch (IOException e) {
                            LOGGER.log(Level.WARNING, null, e);
                        }
                    }
                    if (CpsThreadGroup.this.paused.get() || j == null || CpsThreadGroup.this.execution != null && j.isQuietingDown()) {
                        if (j != null && j.isQuietingDown() && CpsThreadGroup.this.execution != null && CpsThreadGroup.this.pausedByQuietMode.compareAndSet(false, true)) {
                            try {
                                CpsThreadGroup.this.execution.getOwner().getListener().getLogger().println("Pausing (Preparing for shutdown)");
                            }
                            catch (IOException e) {
                                LOGGER.log(Level.WARNING, null, e);
                            }
                            Timer.get().schedule(new Runnable(){

                                @Override
                                public void run() {
                                    if (j.isQuietingDown()) {
                                        Timer.get().schedule(this, Main.isUnitTest ? 1L : 10L, TimeUnit.SECONDS);
                                    } else {
                                        CpsThreadGroup.this.scheduleRun();
                                    }
                                }
                            }, Main.isUnitTest ? 1L : 10L, TimeUnit.SECONDS);
                        }
                        CpsThreadGroup.this.saveProgramIfPossible(true);
                        f.complete(null);
                        return null;
                    }
                    if (CpsThreadGroup.this.terminating) {
                        if (CpsThreadGroup.this.execution != null) {
                            try {
                                FlowExecutionOwner feo = CpsThreadGroup.this.execution.getOwner();
                                if (feo.get().isComplete()) {
                                    LOGGER.warning(() -> "too late to pause " + String.valueOf(feo));
                                } else {
                                    feo.getListener().getLogger().println("Pausing (shutting down)");
                                }
                            }
                            catch (IOException x) {
                                LOGGER.log(Level.WARNING, null, x);
                            }
                        }
                        CpsThreadGroup.this.saveProgramIfPossible(true);
                        f.complete(null);
                        return null;
                    }
                    boolean stillRunnable = CpsThreadGroup.this.run();
                    try {
                        if (stillRunnable) {
                            CpsThreadGroup.this.runner.submit(this);
                        } else {
                            CpsThreadGroup.this.runner.submit(new Runnable(){

                                @Override
                                public void run() {
                                    if (CpsThreadGroup.this.runtimeThreads.isEmpty()) {
                                        CpsThreadGroup.this.runner.shutdown();
                                    }
                                    f.complete(null);
                                }
                            });
                        }
                    }
                    catch (RejectedExecutionException x) {
                        f.completeExceptionally(x);
                    }
                    return null;
                }
            });
        }
        catch (RejectedExecutionException x) {
            return Futures.immediateFuture(null);
        }
        return f;
    }

    public Future<?> pause(boolean persist) {
        this.paused.set(true);
        if (persist) {
            this.executionPaused = true;
        }
        return this.scheduleRun();
    }

    public void unpause() {
        if (this.paused.getAndSet(false)) {
            this.executionPaused = false;
            this.scheduleRun();
        } else {
            LOGGER.warning("were not paused to begin with");
        }
    }

    public boolean isPaused() {
        return this.paused.get();
    }

    @CpsVmThreadOnly(value="root")
    private boolean run() {
        boolean changed = false;
        boolean ending = false;
        boolean stillRunnable = false;
        for (CpsThread t : this.runtimeThreads.values().toArray(new CpsThread[this.runtimeThreads.size()])) {
            if (!t.isRunnable()) continue;
            Outcome o = t.runNextChunk();
            if (o.isFailure()) {
                String msg;
                assert (!t.isAlive());
                Result result = Result.FAILURE;
                Throwable error = o.getAbnormal();
                if (error instanceof FlowInterruptedException) {
                    result = ((FlowInterruptedException)error).getResult();
                }
                this.execution.setResult(result);
                FlowNode fn = t.head.get();
                if (fn != null) {
                    t.head.get().addAction((Action)new ErrorAction(error));
                }
                if (error instanceof VerifyError && (msg = error.getMessage()) != null && msg.contains("Illegal type in constant pool")) {
                    try {
                        this.execution.getOwner().getListener().getLogger().println("May be JENKINS-73031: calling static interface methods from Groovy is not currently supported by Jenkins");
                    }
                    catch (IOException x) {
                        LOGGER.log(Level.WARNING, null, x);
                    }
                }
            }
            if (!t.isAlive()) {
                LOGGER.fine("completed " + String.valueOf(t));
                t.fireCompletionHandlers(o);
                this.runtimeThreads.remove(t.id);
                t.cleanUp();
                if (this.runtimeThreads.isEmpty()) {
                    this.execution.onProgramEnd(o, false);
                    try {
                        this.execution.saveOwner();
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.WARNING, "Error saving execution for " + String.valueOf((Object)this.getExecution()), ex);
                    }
                    ending = true;
                }
            } else {
                stillRunnable |= t.isRunnable();
            }
            changed = true;
        }
        if (changed && !stillRunnable) {
            this.execution.persistedClean = null;
            this.saveProgramIfPossible(false);
        }
        if (ending) {
            this.execution.cleanUpHeap();
            if (this.scripts != null) {
                this.scripts.clear();
            }
            if (!this.closures.isEmpty()) {
                LOGGER.log(Level.WARNING, "Stale closures in {0}: {1}", new Object[]{this.execution, this.closures.keySet()});
                this.closures.clear();
            }
            try {
                Util.deleteFile((File)this.execution.getProgramDataFile());
            }
            catch (IOException x) {
                LOGGER.log(Level.WARNING, "Failed to delete program.dat in " + String.valueOf((Object)this.execution), x);
            }
        }
        return stillRunnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CpsVmThreadOnly
    void notifyNewHead(FlowNode head) {
        this.assertVmThread();
        this.execution.notifyListeners(List.of(head), true);
        Object object = nodesToNotifyLock;
        synchronized (object) {
            if (this.nodesToNotify == null) {
                this.nodesToNotify = new ArrayList<FlowNode>();
            }
            this.nodesToNotify.add(head);
        }
        this.runner.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List<FlowNode> _nodesToNotify;
                Object object = nodesToNotifyLock;
                synchronized (object) {
                    if (CpsThreadGroup.this.nodesToNotify == null) {
                        return;
                    }
                    _nodesToNotify = CpsThreadGroup.this.nodesToNotify;
                    CpsThreadGroup.this.nodesToNotify = null;
                }
                CpsThreadGroup.this.execution.notifyListeners(_nodesToNotify, false);
            }
        });
    }

    public CpsThreadDump getThreadDump() {
        return CpsThreadDump.from(this);
    }

    @CpsVmThreadOnly
    void saveProgramIfPossible(boolean enteringQuietState) {
        if (this.getExecution() != null && (this.getExecution().getDurabilityHint().isPersistWithEveryStep() || enteringQuietState)) {
            try {
                FlowNodeStorage storage = this.execution.getStorage();
                if (storage != null) {
                    storage.flush();
                }
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, "Error persisting FlowNode storage before saving program", ioe);
            }
            try {
                this.saveProgram();
            }
            catch (IOException x) {
                LOGGER.log(Level.WARNING, "program state save failed", x);
            }
        }
    }

    @CpsVmThreadOnly
    void saveProgram() throws IOException {
        if (this.execution.isResumeBlocked()) {
            return;
        }
        File f = this.execution.getProgramDataFile();
        this.saveProgram(f);
    }

    @CpsVmThreadOnly
    public void saveProgram(File f) throws IOException {
        File dir = f.getParentFile();
        File tmpFile = File.createTempFile("atomic", null, dir);
        this.assertVmThread();
        CpsFlowExecution old = CpsFlowExecution.PROGRAM_STATE_SERIALIZATION.get();
        CpsFlowExecution.PROGRAM_STATE_SERIALIZATION.set(this.execution);
        ExtensionList pickleFactories = PickleFactory.all();
        if (pickleFactories.isEmpty()) {
            LOGGER.log(Level.WARNING, "Skipping save to {0} since Jenkins seems to be either starting up or shutting down", f);
            return;
        }
        boolean serializedOK = false;
        try (CpsFlowExecution.Timing t = this.execution.time(CpsFlowExecution.TimingKind.saveProgram);
             WithThreadName diag = new WithThreadName("saving " + String.valueOf(f));){
            try (RiverWriter w = new RiverWriter(tmpFile, this.execution.getOwner(), (Collection)pickleFactories);){
                w.writeObject((Object)this);
            }
            serializedOK = true;
            Files.move(tmpFile.toPath(), f.toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            LOGGER.fine(() -> String.valueOf(f) + " saved");
        }
        catch (RuntimeException e) {
            this.propagateErrorToWorkflow(e);
            throw new IOException("Failed to persist " + String.valueOf(f), e);
        }
        catch (IOException e) {
            if (!serializedOK) {
                this.propagateErrorToWorkflow(e);
            }
            throw new IOException("Failed to persist " + String.valueOf(f), e);
        }
        finally {
            CpsFlowExecution.PROGRAM_STATE_SERIALIZATION.set(old);
            Util.deleteFile((File)tmpFile);
        }
    }

    @CpsVmThreadOnly
    String asXml() {
        XStream xs = new XStream(XStream2.getDefaultDriver());
        for (final SingleTypedPickleFactory stpf : ExtensionList.lookup(SingleTypedPickleFactory.class)) {
            final Class factoryType = Functions.getTypeParameter(stpf.getClass(), SingleTypedPickleFactory.class, (int)0);
            xs.registerConverter(new Converter(){

                public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
                    Pickle p = stpf.writeReplace(source);
                    assert (p != null) : "failed to pickle " + String.valueOf(source) + " using " + String.valueOf(stpf);
                    context.convertAnother((Object)p);
                }

                public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
                    throw new UnsupportedOperationException();
                }

                public boolean canConvert(Class type) {
                    return factoryType.isAssignableFrom(type);
                }
            });
        }
        return xs.toXML((Object)this);
    }

    @CpsVmThreadOnly
    private void propagateErrorToWorkflow(Throwable t) {
        Map.Entry<Integer, CpsThread> lastEntry = this.runtimeThreads.lastEntry();
        if (lastEntry != null) {
            lastEntry.getValue().resume(new Outcome(null, t));
        } else {
            LOGGER.log(Level.WARNING, "encountered error but could not pass it to the flow", t);
        }
    }

    Future<?> terminating() {
        LOGGER.fine(() -> "terminating " + String.valueOf((Object)this.execution));
        this.terminating = true;
        return this.scheduleRun();
    }

    void shutdown() {
        this.runner.shutdown();
    }

    @CpsVmThreadOnly
    static CpsThreadGroup current() {
        return CpsVmExecutorService.CURRENT.get();
    }
}

