/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.TaskListener;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import jenkins.util.Timer;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecution;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public final class WaitForConditionStep
extends Step {
    static final long MIN_RECURRENCE_PERIOD = 250L;
    static final long MAX_RECURRENCE_PERIOD = 15000L;
    private long initialRecurrencePeriod = 250L;
    private boolean quiet = false;

    @DataBoundConstructor
    public WaitForConditionStep() {
    }

    @DataBoundSetter
    public void setInitialRecurrencePeriod(long initialRecurrencePeriod) {
        this.initialRecurrencePeriod = Math.max(250L, Math.min(initialRecurrencePeriod, 15000L));
    }

    public long getInitialRecurrencePeriod() {
        return this.initialRecurrencePeriod;
    }

    @DataBoundSetter
    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public boolean getQuiet() {
        return this.quiet;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(context, this.initialRecurrencePeriod, this.quiet);
    }

    public static final class Execution
    extends AbstractStepExecutionImpl {
        private static final long serialVersionUID = 1L;
        private volatile BodyExecution body;
        private volatile transient ScheduledFuture<?> task;
        private final String id = UUID.randomUUID().toString();
        private static final float RECURRENCE_PERIOD_BACKOFF = 1.2f;
        private long initialRecurrencePeriod;
        long recurrencePeriod;
        private final boolean quiet;

        Execution(StepContext context, long initialRecurrencePeriod, boolean quiet) {
            super(context);
            this.initialRecurrencePeriod = initialRecurrencePeriod;
            this.recurrencePeriod = initialRecurrencePeriod;
            this.quiet = quiet;
        }

        private Object readResolve() {
            if (this.initialRecurrencePeriod == 0L) {
                this.initialRecurrencePeriod = 250L;
            }
            return this;
        }

        public boolean start() throws Exception {
            this.body = this.getContext().newBodyInvoker().withCallback((BodyExecutionCallback)new Callback(this.id)).start();
            return false;
        }

        public void stop(@NonNull Throwable cause) throws Exception {
            if (this.task != null) {
                this.task.cancel(false);
            }
            super.stop(cause);
        }

        public void onResume() {
            this.recurrencePeriod = this.initialRecurrencePeriod;
            if (this.body == null) {
                this.body = this.getContext().newBodyInvoker().withCallback((BodyExecutionCallback)new Callback(this.id)).start();
            }
        }

        private static void retry(String id, StepContext context) {
            StepExecution.acceptAll(Execution.class, execution -> {
                if (execution.id.equals(id)) {
                    execution.retry(context);
                }
            });
        }

        private void retry(StepContext perBodyContext) {
            this.body = null;
            this.getContext().saveState();
            if (!this.quiet) {
                try {
                    ((TaskListener)perBodyContext.get(TaskListener.class)).getLogger().println("Will try again after " + Util.getTimeSpanString((long)this.recurrencePeriod));
                }
                catch (Exception x) {
                    this.getContext().onFailure((Throwable)x);
                    return;
                }
            }
            this.task = Timer.get().schedule(() -> {
                this.task = null;
                this.body = this.getContext().newBodyInvoker().withCallback((BodyExecutionCallback)new Callback(this.id)).start();
            }, this.recurrencePeriod, TimeUnit.MILLISECONDS);
            this.recurrencePeriod = Math.min((long)((float)this.recurrencePeriod * 1.2f), 15000L);
        }

        public String getStatus() {
            if (this.body != null) {
                return "running body";
            }
            if (this.task == null) {
                return "no body, no task, not sure what happened";
            }
            if (this.task.isDone()) {
                return "scheduled task task done, but no body";
            }
            if (this.task.isCancelled()) {
                return "scheduled task was cancelled";
            }
            return "waiting to rerun; next recurrence period: " + this.recurrencePeriod + "ms";
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "waitUntil";
        }

        @NonNull
        public String getDisplayName() {
            return "Wait for condition";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.singleton(TaskListener.class);
        }
    }

    private static final class Callback
    extends BodyExecutionCallback {
        private static final long serialVersionUID = 1L;
        private final String id;

        Callback(String id) {
            this.id = id;
        }

        public void onSuccess(StepContext context, Object result) {
            if (!(result instanceof Boolean)) {
                context.onFailure((Throwable)new ClassCastException("body return value " + String.valueOf(result) + " is not boolean"));
                return;
            }
            if (((Boolean)result).booleanValue()) {
                context.onSuccess(null);
                return;
            }
            Execution.retry(this.id, context);
        }

        public void onFailure(StepContext context, Throwable t) {
            context.onFailure(t);
        }
    }
}

