/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jenkinsci.plugins.workflow.actions.WarningAction;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class UnstableStep
extends Step {
    private final String message;

    @DataBoundConstructor
    public UnstableStep(String message) {
        message = Util.fixEmptyAndTrim((String)message);
        if (message == null) {
            throw new IllegalArgumentException("A non-empty message is required");
        }
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new UnstableStepExecution(this, context);
    }

    private static class UnstableStepExecution
    extends SynchronousStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        private final transient UnstableStep step;

        private UnstableStepExecution(UnstableStep step, StepContext context) {
            super(context);
            this.step = step;
        }

        protected Void run() throws Exception {
            ((FlowNode)this.getContext().get(FlowNode.class)).addOrReplaceAction((Action)new WarningAction(Result.UNSTABLE).withMessage(this.step.message));
            ((Run)this.getContext().get(Run.class)).setResult(Result.UNSTABLE);
            ((TaskListener)this.getContext().get(TaskListener.class)).getLogger().append("WARNING: ").println(this.step.message);
            return null;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "unstable";
        }

        @NonNull
        public String getDisplayName() {
            return "Set stage result to unstable";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            HashSet context = new HashSet();
            Collections.addAll(context, FlowNode.class, Run.class, TaskListener.class);
            return Collections.unmodifiableSet(context);
        }

        public FormValidation doCheckMessage(@QueryParameter String message) {
            if (Util.fixEmptyAndTrim((String)message) == null) {
                return FormValidation.error((String)"Message must be non-empty");
            }
            return FormValidation.ok();
        }
    }
}

