/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Main;
import hudson.Util;
import hudson.console.ConsoleLogFilter;
import hudson.console.LineTransformationOutputStream;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.CauseOfInterruption;
import jenkins.security.SlaveToMasterCallable;
import jenkins.util.SystemProperties;
import jenkins.util.Timer;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graphanalysis.LinearBlockHoppingScanner;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecution;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.BodyInvoker;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.TimeoutStep;

@SuppressFBWarnings(value={"SE_INNER_CLASS"})
public class TimeoutStepExecution
extends AbstractStepExecutionImpl {
    private static final Logger LOGGER = Logger.getLogger(TimeoutStepExecution.class.getName());
    private static final long GRACE_PERIOD = Main.isUnitTest ? 5000L : 60000L;
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static boolean forceInterruption = SystemProperties.getBoolean((String)(TimeoutStepExecution.class.getName() + ".forceInterruption"));
    private BodyExecution body;
    private transient ScheduledFuture<?> killer;
    private long timeout;
    private long end = 0L;
    private final boolean activity;
    private transient boolean forcible;
    private final String id;
    private static final long serialVersionUID = 1L;

    TimeoutStepExecution(TimeoutStep step, StepContext context) {
        super(context);
        this.activity = step.isActivity();
        this.id = this.activity ? UUID.randomUUID().toString() : null;
        this.timeout = step.getUnit().toMillis(step.getTime());
    }

    public boolean start() throws Exception {
        StepContext context = this.getContext();
        BodyInvoker bodyInvoker = context.newBodyInvoker().withCallback((BodyExecutionCallback)new Callback());
        if (this.activity) {
            bodyInvoker = bodyInvoker.withContext((Object)BodyInvoker.mergeConsoleLogFilters((ConsoleLogFilter)((ConsoleLogFilter)context.get(ConsoleLogFilter.class)), (ConsoleLogFilter)new ConsoleLogFilterImpl2(this.id, this.timeout)));
        }
        this.body = bodyInvoker.start();
        this.resetTimer();
        return false;
    }

    public void onResume() {
        this.setupTimer(System.currentTimeMillis(), false);
    }

    private TaskListener listener() {
        try {
            return (TaskListener)this.getContext().get(TaskListener.class);
        }
        catch (Exception x) {
            LOGGER.log(Level.WARNING, null, x);
            return TaskListener.NULL;
        }
    }

    private void setupTimer(long now, boolean forceReset) {
        long delay;
        boolean resettingKiller = false;
        if (this.killer != null) {
            if (!forceReset) {
                return;
            }
            resettingKiller = true;
            this.killer.cancel(true);
            this.killer = null;
        }
        if ((delay = this.end - now) > 0L) {
            if (!this.forcible && !resettingKiller) {
                if (this.activity) {
                    this.listener().getLogger().println("Timeout set to expire after " + Util.getTimeSpanString((long)delay) + " without activity");
                } else {
                    this.listener().getLogger().println("Timeout set to expire in " + Util.getTimeSpanString((long)delay));
                }
            }
            this.killer = Timer.get().schedule(this::cancel, delay, TimeUnit.MILLISECONDS);
        } else {
            this.listener().getLogger().println("Timeout expired " + Util.getTimeSpanString((long)(-delay)) + " ago");
            this.cancel();
        }
    }

    private void resetTimer() {
        LOGGER.fine(() -> "resetting timer on " + this.id);
        long now = System.currentTimeMillis();
        this.end = now + this.timeout;
        this.setupTimer(now, true);
    }

    private void cancel() {
        String nodeId;
        FlowNode flowNode = null;
        try {
            flowNode = (FlowNode)this.getContext().get(FlowNode.class);
        }
        catch (IOException | InterruptedException e) {
            LOGGER.log(Level.WARNING, null, e);
        }
        String string = nodeId = flowNode != null ? flowNode.getId() : null;
        if (this.forcible) {
            if (!this.killer.isCancelled()) {
                FlowExecution exec;
                this.listener().getLogger().println("Body did not finish within grace period; terminating with extreme prejudice");
                try {
                    exec = (FlowExecution)this.getContext().get(FlowExecution.class);
                }
                catch (IOException | InterruptedException x) {
                    LOGGER.log(Level.WARNING, null, x);
                    return;
                }
                FlowInterruptedException death = new FlowInterruptedException(Result.ABORTED, new CauseOfInterruption[]{new ExceededTimeout(nodeId)});
                ListenableFuture currentExecutions = exec.getCurrentExecutions(true);
                currentExecutions.addListener(() -> this.lambda$cancel$1(currentExecutions, (Throwable)death), (Executor)MoreExecutors.newDirectExecutorService());
            }
        } else {
            this.listener().getLogger().println("Cancelling nested steps due to timeout");
            this.body.cancel(new CauseOfInterruption[]{new ExceededTimeout(nodeId)});
            this.forcible = true;
            this.timeout = GRACE_PERIOD;
            this.resetTimer();
        }
    }

    public String getStatus() {
        if (this.killer == null) {
            return "killer task nowhere to be found";
        }
        if (this.killer.isCancelled()) {
            return "killer task was cancelled";
        }
        if (this.killer.isDone()) {
            return "killer task reported done";
        }
        long delay = this.end - System.currentTimeMillis();
        if (delay <= 0L) {
            return "overshot by " + Util.getTimeSpanString((long)(-delay));
        }
        String delayS = Util.getTimeSpanString((long)delay);
        if (this.forcible) {
            return "body did not yet respond to signal; forcibly killing in " + delayS;
        }
        return "body has another " + delayS + " to run";
    }

    private /* synthetic */ void lambda$cancel$1(ListenableFuture currentExecutions, Throwable death) {
        assert (currentExecutions.isDone());
        try {
            FlowNode outer = (FlowNode)this.getContext().get(FlowNode.class);
            block2: for (StepExecution exec1 : (List)currentExecutions.get()) {
                FlowNode inner = (FlowNode)exec1.getContext().get(FlowNode.class);
                LinearBlockHoppingScanner scanner = new LinearBlockHoppingScanner();
                scanner.setup(inner);
                for (FlowNode enclosing : scanner) {
                    if (!enclosing.equals((Object)outer)) continue;
                    exec1.getContext().onFailure(death);
                    continue block2;
                }
            }
        }
        catch (IOException | InterruptedException | ExecutionException x) {
            LOGGER.log(Level.WARNING, null, x);
        }
    }

    private class Callback
    extends BodyExecutionCallback.TailCall {
        private static final long serialVersionUID = 1L;

        private Callback() {
        }

        protected void finished(StepContext context) throws Exception {
            if (TimeoutStepExecution.this.killer != null) {
                TimeoutStepExecution.this.killer.cancel(true);
                TimeoutStepExecution.this.killer = null;
            }
        }

        public void onFailure(StepContext context, Throwable t) {
            if (t instanceof FlowInterruptedException && !forceInterruption) {
                FlowNode flowNode = null;
                try {
                    flowNode = (FlowNode)TimeoutStepExecution.this.getContext().get(FlowNode.class);
                }
                catch (IOException | InterruptedException e) {
                    LOGGER.log(Level.WARNING, null, e);
                }
                if (flowNode != null) {
                    String nodeId = flowNode.getId();
                    for (CauseOfInterruption cause : ((FlowInterruptedException)t).getCauses()) {
                        ExceededTimeout exceededTimeout;
                        if (!(cause instanceof ExceededTimeout) || !nodeId.equals((exceededTimeout = (ExceededTimeout)cause).getNodeId())) continue;
                        ((FlowInterruptedException)t).setActualInterruption(false);
                    }
                }
            }
            super.onFailure(context, t);
        }
    }

    private static class ConsoleLogFilterImpl2
    extends ConsoleLogFilter
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @NonNull
        private final String id;
        private final long timeout;
        @CheckForNull
        private transient Channel channel;

        ConsoleLogFilterImpl2(@NonNull String id, long timeout) {
            this.id = id;
            this.timeout = timeout;
        }

        private Object readResolve() {
            this.channel = Channel.current();
            return this;
        }

        public OutputStream decorateLogger(Run build, final OutputStream logger) throws IOException, InterruptedException {
            final AtomicBoolean active = new AtomicBoolean();
            LineTransformationOutputStream decorated = new LineTransformationOutputStream(){

                protected void eol(byte[] b, int len) throws IOException {
                    logger.write(b, 0, len);
                    active.set(true);
                }

                public void flush() throws IOException {
                    super.flush();
                    logger.flush();
                }

                public void close() throws IOException {
                    super.close();
                    logger.close();
                }
            };
            new Tick(active, new WeakReference<1>(decorated), this.timeout, this.channel, this.id).schedule(0L);
            return decorated;
        }
    }

    public static final class ExceededTimeout
    extends CauseOfInterruption {
        private static final long serialVersionUID = 1L;
        private final String nodeId;

        @Deprecated
        public ExceededTimeout() {
            this(null);
        }

        public ExceededTimeout(String nodeId) {
            this.nodeId = nodeId;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public String getShortDescription() {
            return "Timeout has been exceeded";
        }
    }

    @Deprecated
    private static class ConsoleLogFilterImpl
    extends ConsoleLogFilter
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final ResetCallback callback;

        ConsoleLogFilterImpl(ResetCallback callback) {
            this.callback = callback;
        }

        private Object writeReplace() {
            Channel ch = Channel.current();
            return ch == null ? this : new ConsoleLogFilterImpl((ResetCallback)ch.export(ResetCallback.class, (Object)this.callback));
        }

        public OutputStream decorateLogger(Run build, final OutputStream logger) throws IOException, InterruptedException {
            return new LineTransformationOutputStream(){

                protected void eol(byte[] b, int len) throws IOException {
                    logger.write(b, 0, len);
                    callback.logWritten();
                }

                public void flush() throws IOException {
                    super.flush();
                    logger.flush();
                }

                public void close() throws IOException {
                    super.close();
                    logger.close();
                }
            };
        }
    }

    @Deprecated
    private class ResetCallbackImpl
    implements ResetCallback {
        private static final long serialVersionUID = 1L;

        private ResetCallbackImpl() {
        }

        @Override
        public void logWritten() {
            TimeoutStepExecution.this.resetTimer();
        }
    }

    @Deprecated
    public static interface ResetCallback
    extends Serializable {
        public void logWritten();
    }

    private static final class Tick
    implements Runnable {
        private final AtomicBoolean active;
        private final Reference<?> stream;
        private final long timeout;
        @CheckForNull
        private final Channel channel;
        @NonNull
        private final String id;

        Tick(AtomicBoolean active, Reference<?> stream, long timeout, @CheckForNull Channel channel, @NonNull String id) {
            this.active = active;
            this.stream = stream;
            this.timeout = timeout;
            this.channel = channel;
            this.id = id;
        }

        @Override
        public void run() {
            if (this.stream.get() == null) {
                return;
            }
            boolean currentlyActive = this.active.getAndSet(false);
            if (currentlyActive) {
                ResetTimer resetTimer = new ResetTimer(this.id);
                if (this.channel != null) {
                    try {
                        this.channel.call((Callable)resetTimer);
                    }
                    catch (Exception x) {
                        LOGGER.log(Level.WARNING, null, x);
                    }
                } else {
                    resetTimer.call();
                }
                this.schedule(this.timeout / 2L);
            } else {
                this.schedule(this.timeout / 10L);
            }
        }

        private void schedule(long delay) {
            LOGGER.fine(() -> "scheduling tick for " + Util.getTimeSpanString((long)delay));
            Timer.get().schedule(this, delay, TimeUnit.MILLISECONDS);
        }
    }

    private static final class ResetTimer
    extends SlaveToMasterCallable<Void, RuntimeException> {
        private static final long serialVersionUID = 1L;
        @NonNull
        private final String id;

        ResetTimer(@NonNull String id) {
            this.id = id;
        }

        public Void call() throws RuntimeException {
            StepExecution.acceptAll(TimeoutStepExecution.class, e -> {
                if (this.id.equals(e.id)) {
                    e.resetTimer();
                }
            });
            return null;
        }
    }
}

