/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.util.Timer;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public final class SleepStep
extends Step {
    private static final Logger LOGGER = Logger.getLogger(SleepStep.class.getName());
    private final int time;
    private TimeUnit unit = TimeUnit.SECONDS;

    @DataBoundConstructor
    public SleepStep(int time) {
        this.time = time;
    }

    @DataBoundSetter
    public void setUnit(TimeUnit unit) {
        this.unit = unit;
    }

    public int getTime() {
        return this.time;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    public static final class Execution
    extends AbstractStepExecutionImpl {
        private static final long serialVersionUID = 1L;
        private final transient SleepStep step;
        private long end;
        private volatile transient ScheduledFuture<?> task;

        Execution(SleepStep step, StepContext context) {
            super(context);
            this.step = step;
        }

        public boolean start() throws Exception {
            long now = System.currentTimeMillis();
            this.end = now + this.step.unit.toMillis(this.step.time);
            this.setupTimer(now);
            return false;
        }

        private void setupTimer(long now) {
            TaskListener listener;
            try {
                listener = (TaskListener)this.getContext().get(TaskListener.class);
            }
            catch (Exception x) {
                LOGGER.log(Level.WARNING, null, x);
                listener = TaskListener.NULL;
            }
            if (this.end > now) {
                listener.getLogger().println("Sleeping for " + Util.getTimeSpanString((long)(this.end - now)));
                this.task = Timer.get().schedule(() -> this.getContext().onSuccess(null), this.end - now, TimeUnit.MILLISECONDS);
            } else {
                listener.getLogger().println("No need to sleep any longer");
                this.getContext().onSuccess(null);
            }
        }

        public void stop(@NonNull Throwable cause) throws Exception {
            if (this.task != null) {
                this.task.cancel(false);
            }
            super.stop(cause);
        }

        public void onResume() {
            this.setupTimer(System.currentTimeMillis());
        }

        public String getStatus() {
            long now = System.currentTimeMillis();
            if (this.end > now) {
                return "sleeping for another " + Util.getTimeSpanString((long)(this.end - now));
            }
            return "should have stopped sleeping " + Util.getTimeSpanString((long)(now - this.end)) + " ago";
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "sleep";
        }

        @NonNull
        public String getDisplayName() {
            return "Sleep";
        }

        public ListBoxModel doFillUnitItems() {
            ListBoxModel r = new ListBoxModel();
            for (TimeUnit unit : TimeUnit.values()) {
                r.add(unit.name());
            }
            return r;
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.singleton(TaskListener.class);
        }
    }
}

