/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.TaskListener;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.workflow.steps.Messages;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

public final class FileExistsStep
extends Step {
    private final String file;

    @DataBoundConstructor
    public FileExistsStep(String file) {
        this.file = file;
    }

    public String getFile() {
        return this.file;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this.file, context);
    }

    public static final class Execution
    extends SynchronousNonBlockingStepExecution<Boolean> {
        @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Only used when starting.")
        private final transient String file;
        private static final long serialVersionUID = 1L;

        Execution(String file, StepContext context) {
            super(context);
            this.file = file;
        }

        protected Boolean run() throws Exception {
            if (StringUtils.isEmpty((CharSequence)this.file)) {
                ((TaskListener)this.getContext().get(TaskListener.class)).getLogger().println(Messages.FileExistsStep_EmptyString());
                return ((FilePath)this.getContext().get(FilePath.class)).child("").exists();
            }
            return ((FilePath)this.getContext().get(FilePath.class)).child(this.file).exists();
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "fileExists";
        }

        @NonNull
        public String getDisplayName() {
            return "Verify if file exists in workspace";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.singleton(FilePath.class);
        }
    }
}

