/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.log;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.console.AnnotatedLargeText;
import hudson.console.ConsoleAnnotationOutputStream;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.input.NullReader;
import org.apache.commons.io.output.CountingOutputStream;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.log.BrokenLogStorage;
import org.jenkinsci.plugins.workflow.log.ConsoleAnnotators;
import org.jenkinsci.plugins.workflow.log.LogStorage;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;
import org.kohsuke.stapler.framework.io.ByteBuffer;
import org.kohsuke.stapler.framework.io.LargeText;

@Restricted(value={Beta.class})
public final class FileLogStorage
implements LogStorage {
    private static final Logger LOGGER = Logger.getLogger(FileLogStorage.class.getName());
    private static final Map<File, FileLogStorage> openStorages = Collections.synchronizedMap(new HashMap());
    private final File log;
    private final File index;
    private FileOutputStream os;
    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="actually it is always accessed within the monitor")
    private long osStartPosition;
    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="actually it is always accessed within the monitor")
    private CountingOutputStream cos;
    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="we only care about synchronizing writes")
    private OutputStream bos;
    private Writer indexOs;
    private String lastId;

    public static synchronized LogStorage forFile(File log) {
        return openStorages.computeIfAbsent(log, FileLogStorage::new);
    }

    private FileLogStorage(File log) {
        this.log = log;
        this.index = new File(String.valueOf(log) + "-index");
    }

    private synchronized void open() throws IOException {
        if (this.os == null) {
            this.os = new FileOutputStream(this.log, true);
            this.osStartPosition = this.log.length();
            this.cos = new CountingOutputStream((OutputStream)this.os);
            this.bos = LogStorage.wrapWithAutoFlushingBuffer((OutputStream)this.cos);
            if (this.index.isFile()) {
                try (BufferedReader r = Files.newBufferedReader(this.index.toPath(), StandardCharsets.UTF_8);){
                    String line;
                    String lastLine = null;
                    while ((line = r.readLine()) != null) {
                        lastLine = line;
                    }
                    if (lastLine != null) {
                        int space = lastLine.indexOf(32);
                        this.lastId = space == -1 ? null : lastLine.substring(space + 1);
                    }
                }
            }
            this.indexOs = new OutputStreamWriter((OutputStream)new FileOutputStream(this.index, true), StandardCharsets.UTF_8);
        }
    }

    @Override
    @NonNull
    public BuildListener overallListener() throws IOException {
        return LogStorage.wrapWithRemoteAutoFlushingListener(new IndexOutputStream(null));
    }

    @Override
    @NonNull
    public TaskListener nodeListener(@NonNull FlowNode node) throws IOException {
        return LogStorage.wrapWithRemoteAutoFlushingListener(new IndexOutputStream(node.getId()));
    }

    private void checkId(String id) throws IOException {
        assert (Thread.holdsLock(this));
        if (!Objects.equals(id, this.lastId)) {
            this.bos.flush();
            long pos = this.osStartPosition + this.cos.getByteCount();
            if (id == null) {
                this.indexOs.write(pos + "\n");
            } else {
                this.indexOs.write(pos + " " + id + "\n");
            }
            this.indexOs.flush();
            this.lastId = id;
        }
    }

    private void maybeFlush() {
        if (this.bos != null) {
            try {
                this.bos.flush();
            }
            catch (IOException x) {
                LOGGER.log(Level.WARNING, "failed to flush " + String.valueOf(this.log), x);
            }
        }
    }

    @Override
    @NonNull
    public AnnotatedLargeText<FlowExecutionOwner.Executable> overallLog(final @NonNull FlowExecutionOwner.Executable build, boolean complete) {
        this.maybeFlush();
        return new AnnotatedLargeText<FlowExecutionOwner.Executable>(this.log, StandardCharsets.UTF_8, complete, build){

            public long writeHtmlTo(final long start, final Writer w) throws IOException {
                try (final BufferedReader indexBR = FileLogStorage.this.index.isFile() ? Files.newBufferedReader(FileLogStorage.this.index.toPath(), StandardCharsets.UTF_8) : new BufferedReader((Reader)new NullReader(0L));){
                    ConsoleAnnotationOutputStream caos = new ConsoleAnnotationOutputStream(w, ConsoleAnnotators.createAnnotator(build), (Object)build, StandardCharsets.UTF_8);
                    long r = this.writeRawLogTo(start, new FilterOutputStream((OutputStream)caos){
                        long lastTransition;
                        boolean eof;
                        String lastId;
                        long pos;
                        boolean hadLastId;
                        {
                            super(out);
                            this.lastTransition = -1L;
                            this.pos = start;
                        }

                        @Override
                        public void write(int b) throws IOException {
                            while (this.lastTransition < this.pos && !this.eof) {
                                String line = indexBR.readLine();
                                if (line == null) {
                                    this.eof = true;
                                    break;
                                }
                                int space = line.indexOf(32);
                                try {
                                    this.lastTransition = Long.parseLong(space == -1 ? line : line.substring(0, space));
                                }
                                catch (NumberFormatException x) {
                                    LOGGER.warning("Ignoring corrupt index file " + String.valueOf(FileLogStorage.this.index));
                                }
                                this.lastId = space == -1 ? null : line.substring(space + 1);
                            }
                            if (this.pos == this.lastTransition) {
                                if (this.hadLastId) {
                                    w.write(LogStorage.endStep());
                                }
                                boolean bl = this.hadLastId = this.lastId != null;
                                if (this.lastId != null) {
                                    w.write(LogStorage.startStep(this.lastId));
                                }
                            }
                            super.write(b);
                            ++this.pos;
                        }

                        @Override
                        public void flush() throws IOException {
                            if (this.lastId != null) {
                                w.write(LogStorage.endStep());
                            }
                            super.flush();
                        }
                    });
                    ConsoleAnnotators.setAnnotator(caos.getConsoleAnnotator());
                    long l = r;
                    return l;
                }
            }
        };
    }

    @Override
    @NonNull
    public AnnotatedLargeText<FlowNode> stepLog(@NonNull FlowNode node, boolean complete) {
        long rawLogSize;
        String nodeId;
        long stepLogSize;
        block13: {
            this.maybeFlush();
            stepLogSize = 0L;
            nodeId = node.getId();
            try (RandomAccessFile raf = new RandomAccessFile(this.log, "r");){
                rawLogSize = raf.length();
                if (!this.index.isFile()) break block13;
                try (IndexReader idr = new IndexReader(rawLogSize, nodeId);){
                    stepLogSize = idr.getStepLogSize();
                }
            }
            catch (IOException x) {
                return new BrokenLogStorage(x).stepLog(node, complete);
            }
        }
        if (stepLogSize == 0L) {
            return new AnnotatedLargeText(new ByteBuffer(), StandardCharsets.UTF_8, complete, (Object)node);
        }
        return new AnnotatedLargeText((LargeText.Source)new StreamingStepLog(rawLogSize, stepLogSize, nodeId), StandardCharsets.UTF_8, complete, (Object)node);
    }

    @Override
    @Deprecated
    @NonNull
    public File getLogFile(@NonNull FlowExecutionOwner.Executable build, boolean complete) {
        return this.log;
    }

    private final class IndexOutputStream
    extends OutputStream {
        private final String id;

        IndexOutputStream(String id) throws IOException {
            this.id = id;
            FileLogStorage.this.open();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int b) throws IOException {
            FileLogStorage fileLogStorage = FileLogStorage.this;
            synchronized (fileLogStorage) {
                FileLogStorage.this.checkId(this.id);
                FileLogStorage.this.bos.write(b);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(@NonNull byte[] b) throws IOException {
            FileLogStorage fileLogStorage = FileLogStorage.this;
            synchronized (fileLogStorage) {
                FileLogStorage.this.checkId(this.id);
                FileLogStorage.this.bos.write(b);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(@NonNull byte[] b, int off, int len) throws IOException {
            FileLogStorage fileLogStorage = FileLogStorage.this;
            synchronized (fileLogStorage) {
                FileLogStorage.this.checkId(this.id);
                FileLogStorage.this.bos.write(b, off, len);
            }
        }

        @Override
        public void flush() throws IOException {
            FileLogStorage.this.bos.flush();
        }

        @Override
        public void close() throws IOException {
            if (this.id == null) {
                openStorages.remove(FileLogStorage.this.log);
                try {
                    FileLogStorage.this.bos.close();
                }
                finally {
                    FileLogStorage.this.indexOs.close();
                }
            }
        }
    }

    private class IndexReader
    implements AutoCloseable {
        private final String nodeId;
        private final long rawLogSize;
        private boolean done;
        private BufferedReader indexBR = null;
        private long pos = -1L;

        public IndexReader(long rawLogSize, String nodeId) {
            this.rawLogSize = rawLogSize;
            this.nodeId = nodeId;
        }

        @Override
        public void close() throws IOException {
            if (this.indexBR != null) {
                this.indexBR.close();
                this.indexBR = null;
            }
        }

        private void ensureOpen() throws IOException {
            if (this.indexBR == null) {
                this.indexBR = Files.newBufferedReader(FileLogStorage.this.index.toPath(), StandardCharsets.UTF_8);
            }
        }

        public long getStepLogSize() throws IOException {
            long stepLogSize = 0L;
            Next next = new Next();
            while (this.readNext(next)) {
                stepLogSize += next.end - next.start;
            }
            return stepLogSize;
        }

        public boolean readNext(Next next) throws IOException {
            if (this.done) {
                return false;
            }
            this.ensureOpen();
            while (!this.done) {
                long nextTransition;
                String line = this.indexBR.readLine();
                if (line == null) {
                    this.done = true;
                    break;
                }
                int space = line.indexOf(32);
                try {
                    nextTransition = Long.parseLong(space == -1 ? line : line.substring(0, space));
                }
                catch (NumberFormatException x) {
                    LOGGER.warning("Ignoring corrupt index file " + String.valueOf(FileLogStorage.this.index));
                    this.pos = -1L;
                    continue;
                }
                if (nextTransition >= this.rawLogSize) {
                    nextTransition = this.rawLogSize;
                    this.done = true;
                }
                if (this.pos == -1L) {
                    if (space == -1 || !line.substring(space + 1).equals(this.nodeId)) continue;
                    this.pos = nextTransition;
                    continue;
                }
                if (nextTransition > this.pos) {
                    next.start = this.pos;
                    next.end = nextTransition;
                    this.pos = -1L;
                    return true;
                }
                this.pos = -1L;
            }
            if (this.pos != -1L && this.rawLogSize > this.pos) {
                next.start = this.pos;
                next.end = this.rawLogSize;
                return true;
            }
            return false;
        }

        static class Next {
            public long start = -1L;
            public long end = -1L;

            Next() {
            }
        }
    }

    private class StreamingStepLog
    implements LargeText.Source {
        private final String nodeId;
        private final long rawLogSize;
        private final long stepLogSize;

        StreamingStepLog(long rawLogSize, long stepLogSize, String nodeId) {
            this.rawLogSize = rawLogSize;
            this.stepLogSize = stepLogSize;
            this.nodeId = nodeId;
        }

        public boolean exists() {
            return true;
        }

        public long length() {
            return this.stepLogSize;
        }

        public LargeText.Session open() {
            return new StreamingStepLogSession();
        }

        class StreamingStepLogSession
        extends InputStream
        implements LargeText.Session {
            private RandomAccessFile rawLog;
            private final IndexReader.Next next = new IndexReader.Next();
            private IndexReader indexReader;
            private long rawLogPos;
            private long stepLogPos;

            StreamingStepLogSession() {
                this.rawLogPos = this.next.end;
                this.stepLogPos = 0L;
            }

            @Override
            public void close() throws IOException {
                try {
                    if (this.rawLog != null) {
                        this.rawLog.close();
                        this.rawLog = null;
                    }
                }
                finally {
                    if (this.indexReader != null) {
                        this.indexReader.close();
                        this.indexReader = null;
                    }
                }
            }

            @Override
            public long skip(long n) throws IOException {
                long skipped;
                long skip;
                if (this.stepLogPos + n > StreamingStepLog.this.stepLogSize) {
                    return 0L;
                }
                if (n == 0L) {
                    return 0L;
                }
                this.ensureOpen();
                for (skipped = 0L; skipped < n; skipped += skip) {
                    this.advanceNextIfNeeded(false);
                    long remainingInNext = this.next.end - this.rawLogPos;
                    long remainingToSkip = n - skipped;
                    skip = Long.min(remainingInNext, remainingToSkip);
                    this.rawLogPos += skip;
                    this.stepLogPos += skip;
                }
                this.rawLog.seek(this.rawLogPos);
                return skipped;
            }

            @Override
            public int read() throws IOException {
                byte[] b = new byte[1];
                int n = this.read(b, 0, 1);
                if (n != 1) {
                    return -1;
                }
                return b[0];
            }

            @Override
            public int read(@NonNull byte[] b) throws IOException {
                return this.read(b, 0, b.length);
            }

            @Override
            public int read(@NonNull byte[] b, int off, int len) throws IOException {
                if (this.stepLogPos >= StreamingStepLog.this.stepLogSize) {
                    return -1;
                }
                this.ensureOpen();
                this.advanceNextIfNeeded(true);
                long remaining = this.next.end - this.rawLogPos;
                if ((long)len > remaining) {
                    len = (int)remaining;
                }
                int n = this.rawLog.read(b, off, len);
                this.rawLogPos += (long)n;
                this.stepLogPos += (long)n;
                return n;
            }

            private void advanceNextIfNeeded(boolean seek) throws IOException {
                if (this.rawLogPos < this.next.end) {
                    return;
                }
                if (!this.indexReader.readNext(this.next)) {
                    throw new EOFException("index truncated; did not reach previously discovered end of step log");
                }
                if (seek) {
                    this.rawLog.seek(this.next.start);
                }
                this.rawLogPos = this.next.start;
            }

            private void ensureOpen() throws IOException {
                if (this.rawLog == null) {
                    this.rawLog = new RandomAccessFile(FileLogStorage.this.log, "r");
                }
                if (this.indexReader == null) {
                    this.indexReader = new IndexReader(StreamingStepLog.this.rawLogSize, StreamingStepLog.this.nodeId);
                }
            }
        }
    }
}

