/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.graphanalysis;

import com.google.common.base.Predicate;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Iterator;
import net.jcip.annotations.NotThreadSafe;
import org.jenkinsci.plugins.workflow.graphanalysis.Filterator;

@NotThreadSafe
class FilteratorImpl<T>
implements Filterator<T> {
    private boolean hasNext = false;
    private T nextVal = null;
    private Iterator<T> wrapped = null;
    private Predicate<T> matchCondition = null;

    @Override
    @NonNull
    public FilteratorImpl<T> filter(@NonNull Predicate<T> matchCondition) {
        return new FilteratorImpl<T>(this, matchCondition);
    }

    public FilteratorImpl(@NonNull Iterator<T> it, @NonNull Predicate<T> matchCondition) {
        this.wrapped = it;
        this.matchCondition = matchCondition;
        while (it.hasNext()) {
            T val = it.next();
            if (!matchCondition.apply(val)) continue;
            this.nextVal = val;
            this.hasNext = true;
            break;
        }
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public T next() {
        T returnVal = this.nextVal;
        Object nextMatch = null;
        boolean foundMatch = false;
        while (this.wrapped.hasNext()) {
            nextMatch = this.wrapped.next();
            if (!this.matchCondition.apply(nextMatch)) continue;
            foundMatch = true;
            break;
        }
        if (foundMatch) {
            this.nextVal = nextMatch;
            this.hasNext = true;
        } else {
            this.nextVal = null;
            this.hasNext = false;
        }
        return returnVal;
    }

    @Override
    public void remove() {
        this.wrapped.remove();
    }
}

