/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.log;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.StreamBuildListener;
import hudson.model.TaskListener;
import hudson.util.LogTaskListener;
import hudson.util.StreamTaskListener;
import java.io.FilterOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.util.BuildListenerAdapter;
import org.apache.commons.io.output.ClosedOutputStream;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;

@Restricted(value={Beta.class})
public interface OutputStreamTaskListener
extends TaskListener {
    @NonNull
    public OutputStream getOutputStream();

    @NonNull
    public static OutputStream getOutputStream(@NonNull TaskListener listener) {
        OutputStream os;
        Field printStreamDelegate;
        if (listener instanceof OutputStreamTaskListener) {
            return ((OutputStreamTaskListener)listener).getOutputStream();
        }
        PrintStream ps = listener.getLogger();
        if (ps.getClass() != PrintStream.class) {
            Logger.getLogger(OutputStreamTaskListener.class.getName()).warning(() -> "Unexpected PrintStream subclass " + ps.getClass().getName() + " which might override write(\u2026); error handling is degraded unless OutputStreamTaskListener is used: " + listener.getClass().getName());
            return ps;
        }
        if (Runtime.version().compareToIgnoreOptional(Runtime.Version.parse("17")) >= 0) {
            boolean core = listener == TaskListener.NULL || listener.getClass() == StreamTaskListener.class || listener.getClass() == LogTaskListener.class || listener.getClass() == StreamBuildListener.class || listener.getClass() == BuildListenerAdapter.class;
            Logger.getLogger(OutputStreamTaskListener.class.getName()).log(core ? Level.FINE : Level.WARNING, () -> "On Java 17+ error handling is degraded unless OutputStreamTaskListener is used: " + listener.getClass().getName());
            return ps;
        }
        try {
            printStreamDelegate = FilterOutputStream.class.getDeclaredField("out");
        }
        catch (NoSuchFieldException x) {
            Logger.getLogger(OutputStreamTaskListener.class.getName()).log(Level.WARNING, "PrintStream.out defined in Java Platform and protected, so should not happen.", x);
            return ps;
        }
        try {
            printStreamDelegate.setAccessible(true);
        }
        catch (InaccessibleObjectException x) {
            Logger.getLogger(OutputStreamTaskListener.class.getName()).warning(() -> "Using --illegal-access=deny? Error handling is degraded unless OutputStreamTaskListener is used: " + listener.getClass().getName());
            return ps;
        }
        try {
            os = (OutputStream)printStreamDelegate.get(ps);
        }
        catch (IllegalAccessException x) {
            Logger.getLogger(OutputStreamTaskListener.class.getName()).log(Level.WARNING, "Unexpected failure to access PrintStream.out", x);
            return ps;
        }
        if (os == null) {
            return ClosedOutputStream.CLOSED_OUTPUT_STREAM;
        }
        return os;
    }

    public static abstract class Default
    implements OutputStreamTaskListener {
        private transient PrintStream ps;

        public synchronized PrintStream getLogger() {
            if (this.ps == null) {
                this.ps = new PrintStream(this.getOutputStream(), false, StandardCharsets.UTF_8);
            }
            return this.ps;
        }
    }
}

