/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.graphanalysis;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.jcip.annotations.NotThreadSafe;
import org.jenkinsci.plugins.workflow.graph.BlockStartNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graphanalysis.AbstractFlowScanner;

@NotThreadSafe
public class DepthFirstScanner
extends AbstractFlowScanner {
    protected ArrayDeque<FlowNode> queue;
    protected HashSet<FlowNode> visited = new HashSet();

    @Override
    protected void reset() {
        if (this.queue == null) {
            this.queue = new ArrayDeque();
        } else {
            this.queue.clear();
        }
        this.visited.clear();
        this.myCurrent = null;
        this.myNext = null;
    }

    @Override
    protected void setHeads(@NonNull Collection<FlowNode> heads) {
        if (heads.isEmpty()) {
            return;
        }
        ArrayList<FlowNode> nodes = new ArrayList<FlowNode>(heads);
        for (int i = nodes.size() - 1; i >= 0; --i) {
            this.queue.push(nodes.get(i));
        }
        this.myNext = this.myCurrent = this.queue.pop();
    }

    protected boolean possibleParallelStart(FlowNode f) {
        return f instanceof BlockStartNode;
    }

    protected boolean testCandidate(FlowNode f, Collection<FlowNode> blackList) {
        return !blackList.contains((Object)f) && (!this.possibleParallelStart(f) || !this.visited.contains((Object)f));
    }

    @Override
    protected FlowNode next(@NonNull FlowNode current, @NonNull Collection<FlowNode> blackList) {
        FlowNode output = null;
        List<FlowNode> parents = current.getParents();
        if (parents.size() == 1) {
            FlowNode f = parents.get(0);
            if (this.testCandidate(f, blackList)) {
                output = f;
            }
        } else if (parents.size() > 1) {
            for (int i = parents.size() - 1; i >= 0; --i) {
                FlowNode f = parents.get(i);
                if (!this.testCandidate(f, blackList)) continue;
                this.queue.push(f);
            }
        }
        if (output == null && this.queue.size() > 0) {
            output = this.queue.pop();
        }
        if (output instanceof BlockStartNode) {
            this.visited.add(output);
        }
        return output;
    }
}

