/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.flow;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.security.Permission;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.workflow.flow.FlowDurabilityHint;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;

public class GlobalDefaultFlowDurabilityLevel
extends AbstractDescribableImpl<GlobalDefaultFlowDurabilityLevel> {
    public static final FlowDurabilityHint SUGGESTED_DURABILITY_HINT = FlowDurabilityHint.MAX_SURVIVABILITY;

    public static FlowDurabilityHint getDefaultDurabilityHint() {
        FlowDurabilityHint hint;
        Jenkins j = Jenkins.getInstanceOrNull();
        if (j != null && (hint = ((DescriptorImpl)((Object)j.getExtensionList(DescriptorImpl.class).get((int)0))).durabilityHint) != null) {
            return hint;
        }
        return SUGGESTED_DURABILITY_HINT;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<GlobalDefaultFlowDurabilityLevel> {
        private FlowDurabilityHint durabilityHint = null;

        public DescriptorImpl() {
            this.load();
        }

        @NonNull
        public String getDisplayName() {
            return "Global Default Pipeline Durability Level";
        }

        @CheckForNull
        public FlowDurabilityHint getDurabilityHint() {
            return this.durabilityHint;
        }

        public void setDurabilityHint(FlowDurabilityHint hint) {
            this.durabilityHint = hint;
            this.save();
        }

        public FormValidation doCheckDurabilityHint(@QueryParameter(value="durabilityHint") String durabilityHint) {
            FlowDurabilityHint flowDurabilityHint = Arrays.stream(FlowDurabilityHint.values()).filter(f -> f.name().equals(durabilityHint)).findFirst().orElse(SUGGESTED_DURABILITY_HINT);
            return FormValidation.ok((String)flowDurabilityHint.getTooltip());
        }

        public boolean configure(StaplerRequest2 req, JSONObject json) {
            Object ob = json.opt("durabilityHint");
            FlowDurabilityHint hint = null;
            if (ob instanceof String) {
                String str = (String)ob;
                for (FlowDurabilityHint maybeHint : FlowDurabilityHint.values()) {
                    if (!maybeHint.name().equals(str)) continue;
                    hint = maybeHint;
                    break;
                }
            }
            this.setDurabilityHint(hint);
            return true;
        }

        public ListBoxModel doFillDurabilityHintItems() {
            ListBoxModel options = new ListBoxModel();
            options.add("None: use pipeline default (" + SUGGESTED_DURABILITY_HINT.getDescription() + ")", "null");
            List mappedOptions = Arrays.stream(FlowDurabilityHint.values()).map(hint -> new ListBoxModel.Option(hint.getDescription(), hint.name())).collect(Collectors.toList());
            options.addAll(mappedOptions);
            return options;
        }

        @NonNull
        public Permission getRequiredGlobalConfigPagePermission() {
            return Jenkins.MANAGE;
        }
    }
}

