/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.flow;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.log.LogStorage;

public abstract class FlowExecutionOwner
implements Serializable {
    private static final long serialVersionUID = 1796027762257567194L;
    private static final Logger LOGGER = Logger.getLogger(FlowExecutionOwner.class.getName());

    @NonNull
    public abstract FlowExecution get() throws IOException;

    @CheckForNull
    public FlowExecution getOrNull() {
        try {
            return this.get();
        }
        catch (IOException x) {
            LOGGER.log(Level.WARNING, null, x);
            return null;
        }
    }

    public abstract File getRootDir() throws IOException;

    public abstract Queue.Executable getExecutable() throws IOException;

    public abstract String getUrl() throws IOException;

    public String getUrlOfExecution() throws IOException {
        return this.getUrl() + "execution/";
    }

    @CheckForNull
    public String getExternalizableId() {
        try {
            Queue.Executable exec = this.getExecutable();
            if (exec instanceof Run) {
                return ((Run)exec).getExternalizableId();
            }
        }
        catch (IOException x) {
            LOGGER.log(Level.WARNING, "cannot look up externalizableId of " + String.valueOf(this), x);
        }
        return null;
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    @NonNull
    public TaskListener getListener() throws IOException {
        try {
            return LogStorage.of(this).overallListener();
        }
        catch (InterruptedException x) {
            throw new IOException(x);
        }
    }

    public static FlowExecutionOwner dummyOwner() {
        return new DummyOwner();
    }

    private static class DummyOwner
    extends FlowExecutionOwner {
        DummyOwner() {
        }

        @Override
        @NonNull
        public FlowExecution get() throws IOException {
            throw new IOException("not implemented");
        }

        @Override
        public File getRootDir() throws IOException {
            throw new IOException("not implemented");
        }

        @Override
        public Queue.Executable getExecutable() throws IOException {
            throw new IOException("not implemented");
        }

        @Override
        public String getUrl() throws IOException {
            throw new IOException("not implemented");
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof DummyOwner;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        @NonNull
        public TaskListener getListener() {
            return TaskListener.NULL;
        }
    }

    public static interface Executable
    extends Queue.Executable {
        @CheckForNull
        public FlowExecutionOwner asFlowExecutionOwner();
    }
}

