/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.warnings.axivion;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import edu.hm.hafner.analysis.Report;
import io.jenkins.plugins.analysis.warnings.axivion.AxIssueKind;
import io.jenkins.plugins.analysis.warnings.axivion.AxRawIssue;
import java.util.stream.StreamSupport;

class AxivionParser {
    private final Config config;

    AxivionParser(Config config) {
        this.config = config;
    }

    void parse(Report report, AxIssueKind kind, JsonObject payload) {
        this.checkForDashboardErrors(report, kind, payload);
        JsonArray jsonArray = payload.getAsJsonArray("rows");
        if (jsonArray != null) {
            report.logInfo("Importing %s %s", new Object[]{jsonArray.size(), kind.plural()});
            StreamSupport.stream(jsonArray.spliterator(), false).filter(JsonObject.class::isInstance).map(JsonObject.class::cast).map(issueAsJson -> new AxRawIssue(this.config.projectUrl, this.config.baseDir, (JsonObject)issueAsJson, kind)).filter(issue -> !this.config.ignoreSuppressedOrJustified || !issue.isSuppressedOrJustified()).map(kind::transform).forEach(arg_0 -> ((Report)report).add(arg_0));
        }
    }

    private void checkForDashboardErrors(Report report, AxIssueKind kind, JsonObject payload) {
        JsonPrimitive version = payload.getAsJsonPrimitive("dashboardVersionNumber");
        JsonPrimitive errorType = payload.getAsJsonPrimitive("type");
        JsonPrimitive message = payload.getAsJsonPrimitive("message");
        if (version != null && errorType != null && message != null) {
            report.logError("Dashboard '%s' threw '%s' with message '%s' ('%s').", new Object[]{version, errorType, message, kind});
        }
    }

    static class Config {
        private final String projectUrl;
        private final String baseDir;
        private final boolean ignoreSuppressedOrJustified;

        Config(String projectUrl, String baseDir, boolean ignoreSuppressedOrJustified) {
            this.baseDir = baseDir;
            this.projectUrl = projectUrl;
            this.ignoreSuppressedOrJustified = ignoreSuppressedOrJustified;
        }
    }
}

