/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.steps;

import com.google.errorprone.annotations.FormatMethod;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.util.Ensure;
import edu.hm.hafner.util.FilteredLog;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import io.jenkins.plugins.analysis.core.restapi.IssueApi;
import io.jenkins.plugins.analysis.core.restapi.ReportApi;
import io.jenkins.plugins.forensics.blame.Blames;
import io.jenkins.plugins.forensics.miner.RepositoryStatistics;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;

public class AnnotatedReport
implements Serializable {
    private static final long serialVersionUID = -4797152016409014028L;
    private final String id;
    private Report aggregatedReport = new Report();
    private final Blames aggregatedBlames = new Blames();
    private final RepositoryStatistics aggregatedRepositoryStatistics = new RepositoryStatistics();
    private final Map<String, Integer> sizeOfOrigin = new HashMap<String, Integer>();

    public AnnotatedReport(String id) {
        Ensure.that((String)id).isNotBlank("The ID of the report must not be empty", new Object[0]);
        this.id = id;
    }

    public AnnotatedReport(String id, Report report) {
        this(id, report, new Blames(), new RepositoryStatistics());
    }

    public AnnotatedReport(String id, Report report, Blames blames) {
        this(id, report, blames, new RepositoryStatistics());
    }

    public AnnotatedReport(String id, Report report, Blames blames, RepositoryStatistics statistics) {
        this(id);
        this.aggregatedReport = report;
        this.addBlames(id, blames, statistics, report.size());
    }

    public AnnotatedReport(@CheckForNull String id, List<AnnotatedReport> reports) {
        this(id);
        this.aggregatedReport = new Report();
        this.addAllReports(reports);
    }

    public AnnotatedReport(@CheckForNull String id, Iterable<AnnotatedReport> reports) {
        this(id);
        this.aggregatedReport = new Report();
        this.addAllReports(reports);
    }

    private void addAllReports(Iterable<AnnotatedReport> reports) {
        for (AnnotatedReport report : reports) {
            this.addReport(report.getId(), report);
        }
    }

    private void addReport(String reportId, AnnotatedReport report) {
        this.addReport(reportId, report.getReport(), report.getBlames(), report.getStatistics());
    }

    public Map<String, Integer> getSizeOfOrigin() {
        return new HashMap<String, Integer>(this.sizeOfOrigin);
    }

    @Whitelisted
    public List<IssueApi> getIssues() {
        return new ReportApi(this.getReport(), this.getBlames()).getIssues();
    }

    public Report getReport() {
        return this.aggregatedReport;
    }

    public Blames getBlames() {
        return this.aggregatedBlames;
    }

    public RepositoryStatistics getStatistics() {
        return this.aggregatedRepositoryStatistics;
    }

    @Whitelisted
    public String getId() {
        return this.id;
    }

    @Whitelisted
    public int size() {
        return this.aggregatedReport.size();
    }

    @FormatMethod
    public void logInfo(String format, Object ... args) {
        this.aggregatedReport.logInfo(format, args);
    }

    public void addAll(Collection<AnnotatedReport> reports) {
        this.addAllReports(reports);
    }

    public void add(AnnotatedReport other, String actualId) {
        this.addReport(actualId, other);
    }

    public void add(AnnotatedReport other) {
        this.add(other, this.getId());
    }

    private void addReport(String actualId, Report report, Blames blames, RepositoryStatistics statistics) {
        this.aggregatedReport.addAll(new Report[]{report});
        this.addBlames(actualId, blames, statistics, report.size());
    }

    private void addBlames(String actualId, Blames blames, RepositoryStatistics statistics, int size) {
        this.sizeOfOrigin.merge(actualId, size, Integer::sum);
        this.aggregatedBlames.addAll(blames);
        this.aggregatedRepositoryStatistics.addAll(statistics);
    }

    public void addRepositoryStatistics(RepositoryStatistics statistics) {
        this.aggregatedRepositoryStatistics.addAll(statistics);
    }

    public FilteredLog getLogger() {
        FilteredLog log = new FilteredLog();
        this.aggregatedReport.getInfoMessages().forEach(arg_0 -> ((FilteredLog)log).logInfo(arg_0));
        this.aggregatedReport.getErrorMessages().forEach(arg_0 -> ((FilteredLog)log).logError(arg_0));
        return log;
    }
}

