/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.model;

import hudson.model.Run;
import io.jenkins.plugins.analysis.core.model.LabelProviderFactory;
import io.jenkins.plugins.analysis.core.model.ResultAction;
import io.jenkins.plugins.analysis.core.model.StaticAnalysisLabelProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;

public class ToolNameRegistry {
    private final Map<String, String> idToNameMap;

    public ToolNameRegistry() {
        this(new HashMap<String, String>());
    }

    public ToolNameRegistry(Map<String, String> idToNameMap) {
        this.idToNameMap = new HashMap<String, String>(idToNameMap);
    }

    public static ToolNameRegistry fromBuild(Run<?, ?> build) {
        HashMap<String, String> mapping = new HashMap<String, String>();
        LabelProviderFactory factory = new LabelProviderFactory();
        for (ResultAction action : build.getActions(ResultAction.class)) {
            String id = action.getId();
            String name = action.getName();
            if (StringUtils.isBlank((CharSequence)name)) {
                name = factory.create(id).getName();
            }
            mapping.put(id, StringEscapeUtils.escapeHtml4((String)name));
        }
        return new ToolNameRegistry(mapping);
    }

    public String getName(String id) {
        if (this.idToNameMap.containsKey(id)) {
            return this.idToNameMap.get(id);
        }
        StaticAnalysisLabelProvider labelProvider = new LabelProviderFactory().create(id);
        return StringEscapeUtils.escapeHtml4((String)labelProvider.getName());
    }

    public void register(String id, String name) {
        this.idToNameMap.put(id, StringEscapeUtils.escapeHtml4((String)name));
    }

    public boolean contains(String id) {
        return this.idToNameMap.containsKey(id);
    }

    public int size() {
        return this.idToNameMap.size();
    }

    public Map<String, String> asMap() {
        return Collections.unmodifiableMap(this.idToNameMap);
    }
}

