/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.model;

import edu.hm.hafner.util.VisibleForTesting;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Run;
import hudson.security.AccessControlled;
import io.jenkins.plugins.analysis.core.model.ResetReferenceAction;
import io.jenkins.plugins.analysis.core.model.ResultAction;
import io.jenkins.plugins.util.JenkinsFacade;
import java.io.IOException;
import java.util.List;

public class ResetQualityGateCommand {
    private JenkinsFacade jenkinsFacade = new JenkinsFacade();

    @VisibleForTesting
    void setJenkinsFacade(JenkinsFacade jenkinsFacade) {
        this.jenkinsFacade = jenkinsFacade;
    }

    public void execute(Run<?, ?> selectedBuild, String id) {
        if (this.isEnabled(selectedBuild, id)) {
            this.resetReferenceBuild(selectedBuild, id);
        }
    }

    @VisibleForTesting
    public void resetReferenceBuild(Run<?, ?> selectedBuild, String id) {
        try {
            selectedBuild.addAction((Action)new ResetReferenceAction(id));
            selectedBuild.save();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isEnabled(Run<?, ?> selectedBuild, String id) {
        if (!this.hasConfigurePermission(selectedBuild)) {
            return false;
        }
        if (selectedBuild.getNextBuild() != null) {
            return false;
        }
        List actions = selectedBuild.getActions(ResetReferenceAction.class);
        if (actions.stream().map(ResetReferenceAction::getId).anyMatch(id::equals)) {
            return false;
        }
        return selectedBuild.getActions(ResultAction.class).stream().filter(action -> action.getId().equals(id)).findAny().filter(action -> !action.getResult().getQualityGateResult().isSuccessful()).isPresent();
    }

    @VisibleForTesting
    boolean hasConfigurePermission(Run<?, ?> selectedBuild) {
        if (selectedBuild.hasPermission(Item.CONFIGURE)) {
            return true;
        }
        Job parent = selectedBuild.getParent();
        while (parent instanceof Item) {
            Item item = (Item)parent;
            if (this.jenkinsFacade.hasPermission(Item.CONFIGURE, (AccessControlled)item)) {
                return true;
            }
            ItemGroup itemParent = item.getParent();
            if (!(itemParent instanceof Item)) break;
            parent = itemParent;
        }
        return false;
    }
}

