/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Run;
import io.jenkins.plugins.analysis.core.model.ResultAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jenkins.model.TransientActionFactory;

@Extension
public final class MissingResultFallbackHandler
extends TransientActionFactory<Job<?, ?>> {
    public static final int MAX_BUILDS_TO_CONSIDER = 5;

    public Class<Job<?, ?>> type() {
        return Job.class;
    }

    @NonNull
    public Collection<? extends Action> createFor(@NonNull Job<?, ?> target) {
        Run currentBuild = target.getLastBuild();
        if (currentBuild == null || currentBuild.isBuilding()) {
            return Collections.emptyList();
        }
        if (this.hasResults(currentBuild)) {
            return Collections.emptyList();
        }
        Run previousSuccessfulBuild = currentBuild.getPreviousSuccessfulBuild();
        if (previousSuccessfulBuild != null && this.hasResults(previousSuccessfulBuild)) {
            return Collections.emptyList();
        }
        return this.selectActionFromHistoricalResults(currentBuild);
    }

    private List<Action> selectActionFromHistoricalResults(Run<?, ?> currentBuild) {
        int count = 0;
        for (Run previousBuild = currentBuild.getPreviousBuild(); previousBuild != null && count < 5; previousBuild = previousBuild.getPreviousBuild(), ++count) {
            List resultActions = previousBuild.getActions(ResultAction.class);
            ArrayList<Action> actions = new ArrayList<Action>();
            for (ResultAction action : resultActions) {
                actions.addAll(action.getProjectActions());
            }
            if (resultActions.isEmpty()) continue;
            return actions;
        }
        return Collections.emptyList();
    }

    private boolean hasResults(Run<?, ?> currentBuild) {
        return !currentBuild.getActions(ResultAction.class).isEmpty();
    }
}

