/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.steps;

import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.FilteredLog;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.BuildableItem;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.AccessControlled;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.ComboBoxModel;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.analysis.core.filter.RegexpFilter;
import io.jenkins.plugins.analysis.core.model.AnalysisResult;
import io.jenkins.plugins.analysis.core.model.ResultAction;
import io.jenkins.plugins.analysis.core.model.Tool;
import io.jenkins.plugins.analysis.core.steps.AnnotatedReport;
import io.jenkins.plugins.analysis.core.steps.IssuesPublisher;
import io.jenkins.plugins.analysis.core.steps.IssuesScanner;
import io.jenkins.plugins.analysis.core.steps.Messages;
import io.jenkins.plugins.analysis.core.steps.ToolProxy;
import io.jenkins.plugins.analysis.core.steps.WarningChecksPublisher;
import io.jenkins.plugins.analysis.core.util.HealthDescriptor;
import io.jenkins.plugins.analysis.core.util.ModelValidation;
import io.jenkins.plugins.analysis.core.util.TrendChartType;
import io.jenkins.plugins.analysis.core.util.WarningsQualityGate;
import io.jenkins.plugins.checks.steps.ChecksInfo;
import io.jenkins.plugins.forensics.delta.DeltaCalculator;
import io.jenkins.plugins.forensics.delta.DeltaCalculatorFactory;
import io.jenkins.plugins.prism.SourceCodeDirectory;
import io.jenkins.plugins.prism.SourceCodeRetention;
import io.jenkins.plugins.util.JenkinsFacade;
import io.jenkins.plugins.util.LogHandler;
import io.jenkins.plugins.util.ResultHandler;
import io.jenkins.plugins.util.RunResultHandler;
import io.jenkins.plugins.util.ValidationUtilities;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class IssuesRecorder
extends Recorder {
    private static final ValidationUtilities VALIDATION_UTILITIES = new ValidationUtilities();
    static final String DEFAULT_ID = "analysis";
    private List<Tool> analysisTools = new ArrayList<Tool>();
    private String sourceCodeEncoding = "";
    private Set<SourceCodeDirectory> sourceDirectories = new HashSet<SourceCodeDirectory>();
    private SourceCodeRetention sourceCodeRetention = SourceCodeRetention.EVERY_BUILD;
    private boolean ignoreQualityGate;
    private boolean failOnError;
    private int healthy;
    private int unhealthy;
    private Severity minimumSeverity = Severity.WARNING_LOW;
    private List<RegexpFilter> filters = new ArrayList<RegexpFilter>();
    private boolean isEnabledForFailure;
    private boolean isAggregatingResults;
    private boolean quiet;
    private boolean isBlameDisabled;
    private boolean skipPublishingChecks;
    private WarningChecksPublisher.ChecksAnnotationScope checksAnnotationScope = WarningChecksPublisher.ChecksAnnotationScope.NEW;
    private transient boolean publishAllIssues;
    private boolean skipPostProcessing;
    private boolean skipDeltaCalculation;
    @CheckForNull
    private ChecksInfo checksInfo;
    private String id = "";
    private String name = "";
    private String icon = "";
    private List<WarningsQualityGate> qualityGates = new ArrayList<WarningsQualityGate>();
    private TrendChartType trendChartType = TrendChartType.AGGREGATION_TOOLS;
    private String scm = "";
    private String sourcePathPrefix = "";
    private String targetPathPrefix = "";

    @DataBoundConstructor
    public IssuesRecorder() {
    }

    protected Object readResolve() {
        if (this.sourceDirectories == null) {
            this.sourceDirectories = new HashSet<SourceCodeDirectory>();
        }
        if (this.trendChartType == null) {
            this.trendChartType = TrendChartType.AGGREGATION_TOOLS;
        }
        if (this.analysisTools == null) {
            this.analysisTools = new ArrayList<Tool>();
        }
        if (this.qualityGates == null) {
            this.qualityGates = new ArrayList<WarningsQualityGate>();
        }
        if (this.scm == null) {
            this.scm = "";
        }
        if (this.sourceCodeRetention == null) {
            this.sourceCodeRetention = SourceCodeRetention.EVERY_BUILD;
        }
        if (this.checksAnnotationScope == null) {
            WarningChecksPublisher.ChecksAnnotationScope checksAnnotationScope = this.checksAnnotationScope = this.publishAllIssues ? WarningChecksPublisher.ChecksAnnotationScope.ALL : WarningChecksPublisher.ChecksAnnotationScope.NEW;
        }
        if (this.icon == null) {
            this.icon = "";
        }
        if (this.sourcePathPrefix == null) {
            this.sourcePathPrefix = "";
        }
        if (this.targetPathPrefix == null) {
            this.targetPathPrefix = "";
        }
        return this;
    }

    @DataBoundSetter
    public void setScm(String scm) {
        this.scm = scm;
    }

    public String getScm() {
        return this.scm;
    }

    @DataBoundSetter
    public void setQualityGates(List<WarningsQualityGate> qualityGates) {
        this.qualityGates = qualityGates;
    }

    public List<WarningsQualityGate> getQualityGates() {
        return this.qualityGates;
    }

    @DataBoundSetter
    public void setId(String id) {
        VALIDATION_UTILITIES.ensureValidId(id);
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    @DataBoundSetter
    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @DataBoundSetter
    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getIcon() {
        return this.icon;
    }

    @Deprecated
    @CheckForNull
    public List<ToolProxy> getToolProxies() {
        return this.analysisTools.stream().map(ToolProxy::new).collect(Collectors.toList());
    }

    @DataBoundSetter
    @Deprecated
    public void setToolProxies(List<ToolProxy> toolProxies) {
        this.analysisTools = toolProxies.stream().map(ToolProxy::getTool).collect(Collectors.toList());
    }

    @DataBoundSetter
    public void setTools(List<Tool> tools) {
        this.analysisTools = new ArrayList<Tool>(tools);
    }

    public void setTools(Tool tool, Tool ... additionalTools) {
        this.analysisTools = new ArrayList<Tool>();
        this.analysisTools.add(tool);
        Collections.addAll(this.analysisTools, additionalTools);
    }

    public List<Tool> getTools() {
        return new ArrayList<Tool>(this.analysisTools);
    }

    @CheckForNull
    public String getSourceCodeEncoding() {
        return this.sourceCodeEncoding;
    }

    @DataBoundSetter
    public void setSourceCodeEncoding(String sourceCodeEncoding) {
        this.sourceCodeEncoding = sourceCodeEncoding;
    }

    @DataBoundSetter
    public void setSourceDirectories(List<SourceCodeDirectory> sourceDirectories) {
        this.sourceDirectories = new HashSet<SourceCodeDirectory>(sourceDirectories);
    }

    public List<SourceCodeDirectory> getSourceDirectories() {
        return new ArrayList<SourceCodeDirectory>(this.sourceDirectories);
    }

    @DataBoundSetter
    public void setSourceCodeRetention(SourceCodeRetention sourceCodeRetention) {
        this.sourceCodeRetention = sourceCodeRetention;
    }

    public SourceCodeRetention getSourceCodeRetention() {
        return this.sourceCodeRetention;
    }

    @DataBoundSetter
    public void setSourcePathPrefix(String sourcePathPrefix) {
        this.sourcePathPrefix = sourcePathPrefix;
    }

    public String getSourcePathPrefix() {
        return this.sourcePathPrefix;
    }

    @DataBoundSetter
    public void setTargetPathPrefix(String targetPathPrefix) {
        this.targetPathPrefix = targetPathPrefix;
    }

    public String getTargetPathPrefix() {
        return this.targetPathPrefix;
    }

    public boolean getAggregatingResults() {
        return this.isAggregatingResults;
    }

    @DataBoundSetter
    public void setAggregatingResults(boolean aggregatingResults) {
        this.isAggregatingResults = aggregatingResults;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    @DataBoundSetter
    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public boolean getBlameDisabled() {
        return this.isBlameDisabled;
    }

    @DataBoundSetter
    public void setBlameDisabled(boolean blameDisabled) {
        this.isBlameDisabled = blameDisabled;
    }

    public boolean isSkipBlames() {
        return this.isBlameDisabled;
    }

    @DataBoundSetter
    public void setSkipBlames(boolean skipBlames) {
        this.isBlameDisabled = skipBlames;
    }

    public boolean isSkipPublishingChecks() {
        return this.skipPublishingChecks;
    }

    @DataBoundSetter
    public void setSkipPublishingChecks(boolean skipPublishingChecks) {
        this.skipPublishingChecks = skipPublishingChecks;
    }

    @DataBoundSetter
    public void setChecksAnnotationScope(WarningChecksPublisher.ChecksAnnotationScope checksAnnotationScope) {
        this.checksAnnotationScope = checksAnnotationScope;
    }

    public WarningChecksPublisher.ChecksAnnotationScope getChecksAnnotationScope() {
        return this.checksAnnotationScope;
    }

    public boolean isSkipPostProcessing() {
        return this.skipPostProcessing;
    }

    @DataBoundSetter
    public void setSkipPostProcessing(boolean skipPostProcessing) {
        this.skipPostProcessing = skipPostProcessing;
    }

    public boolean isSkipDeltaCalculation() {
        return this.skipDeltaCalculation;
    }

    @DataBoundSetter
    public void setSkipDeltaCalculation(boolean skipDeltaCalculation) {
        this.skipDeltaCalculation = skipDeltaCalculation;
    }

    @DataBoundSetter
    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public boolean getFailOnError() {
        return this.failOnError;
    }

    public boolean getEnabledForFailure() {
        return this.isEnabledForFailure;
    }

    @DataBoundSetter
    public void setEnabledForFailure(boolean enabledForFailure) {
        this.isEnabledForFailure = enabledForFailure;
    }

    @DataBoundSetter
    public void setIgnoreQualityGate(boolean ignoreQualityGate) {
        this.ignoreQualityGate = ignoreQualityGate;
    }

    public boolean getIgnoreQualityGate() {
        return this.ignoreQualityGate;
    }

    public int getHealthy() {
        return this.healthy;
    }

    @DataBoundSetter
    public void setHealthy(int healthy) {
        this.healthy = healthy;
    }

    public int getUnhealthy() {
        return this.unhealthy;
    }

    @DataBoundSetter
    public void setUnhealthy(int unhealthy) {
        this.unhealthy = unhealthy;
    }

    @CheckForNull
    public String getMinimumSeverity() {
        return this.minimumSeverity.getName();
    }

    @DataBoundSetter
    public void setTrendChartType(TrendChartType trendChartType) {
        this.trendChartType = trendChartType;
    }

    public TrendChartType getTrendChartType() {
        return this.trendChartType;
    }

    @DataBoundSetter
    public void setMinimumSeverity(String minimumSeverity) {
        this.minimumSeverity = Severity.valueOf((String)minimumSeverity, (Severity)Severity.WARNING_LOW);
    }

    public List<RegexpFilter> getFilters() {
        return new ArrayList<RegexpFilter>(this.filters);
    }

    @DataBoundSetter
    public void setFilters(List<RegexpFilter> filters) {
        this.filters = new ArrayList<RegexpFilter>(filters);
    }

    public void setChecksInfo(@CheckForNull ChecksInfo checksInfo) {
        this.checksInfo = checksInfo;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public Descriptor getDescriptor() {
        return (Descriptor)super.getDescriptor();
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        FilePath workspace = build.getWorkspace();
        if (workspace == null) {
            throw new IOException("No workspace found for " + String.valueOf(build));
        }
        this.perform((Run<?, ?>)build, workspace, (TaskListener)listener, (ResultHandler)new RunResultHandler(build));
        return true;
    }

    List<AnalysisResult> perform(Run<?, ?> run, FilePath workspace, TaskListener listener, ResultHandler resultHandler) throws InterruptedException, IOException {
        LogHandler logHandler = new LogHandler(listener, DEFAULT_ID);
        logHandler.setQuiet(this.quiet);
        Result overallResult = run.getResult();
        if (this.isEnabledForFailure || overallResult == null || overallResult.isBetterOrEqualTo(Result.UNSTABLE)) {
            return this.record(run, workspace, listener, resultHandler, logHandler);
        }
        logHandler.log("Skipping execution of recorder since overall result is '%s'", new Object[]{overallResult});
        return Collections.emptyList();
    }

    private List<AnalysisResult> record(Run<?, ?> run, FilePath workspace, TaskListener listener, ResultHandler resultHandler, LogHandler logHandler) throws IOException, InterruptedException {
        if (this.analysisTools.isEmpty()) {
            throw new IllegalStateException("No tools configured to record issues");
        }
        ArrayList<AnalysisResult> results = new ArrayList<AnalysisResult>();
        if (this.analysisTools.size() == 1) {
            Tool tool = this.analysisTools.get(0);
            String customId = (String)StringUtils.defaultIfBlank((CharSequence)this.getId(), (CharSequence)tool.getActualId());
            String customName = (String)StringUtils.defaultIfBlank((CharSequence)this.getName(), (CharSequence)tool.getActualName());
            String customIcon = (String)StringUtils.defaultIfBlank((CharSequence)this.getIcon(), (CharSequence)tool.getIcon());
            AnnotatedReport report = new AnnotatedReport(customId);
            report.add(this.scanWithTool(run, workspace, listener, tool), tool.getActualId());
            results.add(this.publishResult(run, workspace, listener, customName, report, customName, customIcon, resultHandler));
            if (this.isAggregatingResults) {
                logHandler.log("Ignoring property 'aggregatingResults' since only a single tool is defined.", new Object[0]);
            }
            if (this.isNotUnique(tool)) {
                logHandler.log("Do not set id, name, or icon for both the tool and the recorder", new Object[0]);
            }
        } else if (this.isAggregatingResults) {
            AnnotatedReport report = new AnnotatedReport((String)StringUtils.defaultIfBlank((CharSequence)this.getId(), (CharSequence)DEFAULT_ID));
            for (Tool tool : this.analysisTools) {
                report.add(this.scanWithTool(run, workspace, listener, tool), tool.getActualId());
            }
            results.add(this.publishResult(run, workspace, listener, this.getCustomName(), report, this.getCustomName(), this.getIcon(), resultHandler));
        } else {
            for (Tool tool : this.analysisTools) {
                AnnotatedReport report = new AnnotatedReport(tool.getActualId());
                report.add(this.scanWithTool(run, workspace, listener, tool));
                results.add(this.publishResult(run, workspace, listener, tool.getActualName(), report, this.getReportName(tool), tool.getIcon(), resultHandler));
            }
            if (StringUtils.isNotBlank((CharSequence)this.getId()) || StringUtils.isNotBlank((CharSequence)this.getName()) || StringUtils.isNotBlank((CharSequence)this.getIcon())) {
                logHandler.log("Do not set id, name, or icon of recorder when multiple tools are defined", new Object[0]);
            }
        }
        return results;
    }

    private String getCustomName() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.getName(), (CharSequence)Messages.Tool_Default_Name());
    }

    private boolean isNotUnique(Tool tool) {
        if (StringUtils.isNotBlank((CharSequence)this.getId()) && StringUtils.isNotBlank((CharSequence)tool.getId())) {
            return true;
        }
        return StringUtils.isNotBlank((CharSequence)this.getName()) && StringUtils.isNotBlank((CharSequence)tool.getName()) || StringUtils.isNotBlank((CharSequence)this.getIcon()) && StringUtils.isNotBlank((CharSequence)tool.getIcon());
    }

    private String getReportName(Tool tool) {
        if (StringUtils.isBlank((CharSequence)tool.getName())) {
            return "";
        }
        return tool.getActualName();
    }

    private AnnotatedReport scanWithTool(Run<?, ?> run, FilePath workspace, TaskListener listener, Tool tool) throws IOException, InterruptedException {
        IssuesScanner issuesScanner = new IssuesScanner(tool, this.getFilters(), this.getSourceCodeCharset(), workspace, this.getSourceCodePaths(), this.getSourceCodeRetention(), run, new FilePath(run.getRootDir()), listener, this.scm, this.isBlameDisabled ? IssuesScanner.BlameMode.DISABLED : IssuesScanner.BlameMode.ENABLED, this.skipPostProcessing ? IssuesScanner.PostProcessingMode.DISABLED : IssuesScanner.PostProcessingMode.ENABLED, this.quiet, this.sourcePathPrefix, this.targetPathPrefix);
        return issuesScanner.scan();
    }

    private Set<String> getSourceCodePaths() {
        return this.getSourceDirectories().stream().map(SourceCodeDirectory::getPath).collect(Collectors.toSet());
    }

    private Charset getSourceCodeCharset() {
        return this.getCharset(this.sourceCodeEncoding);
    }

    private Charset getCharset(String encoding) {
        return VALIDATION_UTILITIES.getCharset(encoding);
    }

    AnalysisResult publishResult(Run<?, ?> run, FilePath workspace, TaskListener listener, String loggerName, AnnotatedReport annotatedReport, String customName, String customIcon, ResultHandler resultHandler) {
        LogHandler logHandler = new LogHandler(listener, loggerName, annotatedReport.getLogger());
        logHandler.setQuiet(this.quiet);
        Report report = annotatedReport.getReport();
        logHandler.logInfoMessages(report.getInfoMessages());
        logHandler.logErrorMessages(report.getErrorMessages());
        DeltaCalculator.NullDeltaCalculator deltaCalculator = this.isSkipDeltaCalculation() ? new DeltaCalculator.NullDeltaCalculator() : DeltaCalculatorFactory.findDeltaCalculator((String)this.scm, run, (FilePath)workspace, (TaskListener)listener, (FilteredLog)new FilteredLog());
        IssuesPublisher publisher = new IssuesPublisher(run, annotatedReport, (DeltaCalculator)deltaCalculator, new HealthDescriptor(this.healthy, this.unhealthy, this.minimumSeverity), this.qualityGates, customName, customIcon, this.ignoreQualityGate, this.getSourceCodeCharset(), logHandler, resultHandler, this.failOnError);
        ResultAction action = publisher.attachAction(this.trendChartType);
        if (!this.skipPublishingChecks) {
            WarningChecksPublisher checksPublisher = new WarningChecksPublisher(action, listener, this.checksInfo);
            checksPublisher.publishChecks(this.getChecksAnnotationScope());
        }
        return action.getResult();
    }

    @Extension
    @Symbol(value={"recordIssues"})
    public static class Descriptor
    extends BuildStepDescriptor<Publisher> {
        private static final JenkinsFacade JENKINS = new JenkinsFacade();
        private final ModelValidation model = new ModelValidation();

        @Initializer(before=InitMilestone.PLUGINS_STARTED)
        public static void addAliases() {
            Run.XSTREAM2.addCompatibilityAlias("io.jenkins.plugins.analysis.core.views.ResultAction", ResultAction.class);
        }

        public String getDefaultId() {
            return IssuesRecorder.DEFAULT_ID;
        }

        public String getDefaultName() {
            return Messages.Tool_Default_Name();
        }

        public String getDefaultIcon() {
            return "symbol-solid/triangle-exclamation plugin-font-awesome-api";
        }

        @NonNull
        public String getDisplayName() {
            return Messages.ScanAndPublishIssues_DisplayName();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        @POST
        public FormValidation doCheckId(@AncestorInPath BuildableItem project, @QueryParameter String id) {
            if (!JENKINS.hasPermission(Item.CONFIGURE, (AccessControlled)project)) {
                return FormValidation.ok();
            }
            return VALIDATION_UTILITIES.validateId(id);
        }

        @POST
        public ComboBoxModel doFillSourceCodeEncodingItems(@AncestorInPath BuildableItem project) {
            if (JENKINS.hasPermission(Item.CONFIGURE, (AccessControlled)project)) {
                return VALIDATION_UTILITIES.getAllCharsets();
            }
            return new ComboBoxModel();
        }

        @POST
        public ListBoxModel doFillSourceCodeRetentionItems() {
            if (JENKINS.hasPermission(Jenkins.READ)) {
                return SourceCodeRetention.fillItems();
            }
            return new ListBoxModel();
        }

        @POST
        public ListBoxModel doFillMinimumSeverityItems() {
            if (JENKINS.hasPermission(Jenkins.READ)) {
                return this.model.getAllSeverityFilters();
            }
            return new ListBoxModel();
        }

        @POST
        public FormValidation doCheckReportEncoding(@AncestorInPath BuildableItem project, @QueryParameter String reportEncoding) {
            if (!JENKINS.hasPermission(Item.CONFIGURE, (AccessControlled)project)) {
                return FormValidation.ok();
            }
            return VALIDATION_UTILITIES.validateCharset(reportEncoding);
        }

        @POST
        public FormValidation doCheckSourceCodeEncoding(@AncestorInPath BuildableItem project, @QueryParameter String sourceCodeEncoding) {
            if (!JENKINS.hasPermission(Item.CONFIGURE, (AccessControlled)project)) {
                return FormValidation.ok();
            }
            return VALIDATION_UTILITIES.validateCharset(sourceCodeEncoding);
        }

        @POST
        public FormValidation doCheckHealthy(@AncestorInPath BuildableItem project, @QueryParameter int healthy, @QueryParameter int unhealthy) {
            if (!JENKINS.hasPermission(Item.CONFIGURE, (AccessControlled)project)) {
                return FormValidation.ok();
            }
            return this.model.validateHealthy(healthy, unhealthy);
        }

        @POST
        public FormValidation doCheckUnhealthy(@AncestorInPath BuildableItem project, @QueryParameter int healthy, @QueryParameter int unhealthy) {
            if (!JENKINS.hasPermission(Item.CONFIGURE, (AccessControlled)project)) {
                return FormValidation.ok();
            }
            return this.model.validateUnhealthy(healthy, unhealthy);
        }

        @POST
        public ListBoxModel doFillTrendChartTypeItems() {
            if (JENKINS.hasPermission(Jenkins.READ)) {
                return this.model.getAllTrendChartTypes();
            }
            return new ListBoxModel();
        }

        @POST
        public ListBoxModel doFillChecksAnnotationScopeItems() {
            if (JENKINS.hasPermission(Jenkins.READ)) {
                return WarningChecksPublisher.ChecksAnnotationScope.fillItems();
            }
            return new ListBoxModel();
        }
    }
}

