/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.model;

import edu.hm.hafner.util.VisibleForTesting;
import hudson.model.Run;
import io.jenkins.plugins.analysis.core.model.AnalysisResult;
import io.jenkins.plugins.analysis.core.model.LabelProviderFactory;
import io.jenkins.plugins.analysis.core.model.Messages;
import io.jenkins.plugins.analysis.core.model.ResetQualityGateCommand;
import io.jenkins.plugins.analysis.core.model.ResetReferenceAction;
import io.jenkins.plugins.analysis.core.model.StaticAnalysisLabelProvider;
import io.jenkins.plugins.forensics.reference.ReferenceBuild;
import io.jenkins.plugins.util.QualityGateStatus;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.collections.api.list.ImmutableList;

public class SummaryModel {
    private final StaticAnalysisLabelProvider labelProvider;
    private final AnalysisResult analysisResult;
    private final LabelProviderFactoryFacade facade;
    private ResetQualityGateCommand resetQualityGateCommand = new ResetQualityGateCommand();

    public SummaryModel(StaticAnalysisLabelProvider labelProvider, AnalysisResult result) {
        this(labelProvider, result, new LabelProviderFactoryFacade());
    }

    @VisibleForTesting
    SummaryModel(StaticAnalysisLabelProvider labelProvider, AnalysisResult result, LabelProviderFactoryFacade facade) {
        this.labelProvider = labelProvider;
        this.analysisResult = result;
        this.facade = facade;
    }

    @VisibleForTesting
    void setResetQualityGateCommand(ResetQualityGateCommand resetQualityGateCommand) {
        this.resetQualityGateCommand = resetQualityGateCommand;
    }

    public String getId() {
        return this.labelProvider.getId();
    }

    public String getName() {
        return this.labelProvider.getName();
    }

    public String getTitle() {
        int totalSize = this.analysisResult.getTotalSize();
        if (totalSize == 0) {
            return Messages.Tool_NoIssues();
        }
        if (totalSize == 1) {
            return Messages.Tool_OneIssue();
        }
        return Messages.Tool_MultipleIssues(totalSize);
    }

    public int getAnalysesCount() {
        return this.analysisResult.getIssues().getOriginReportFiles().size();
    }

    public ImmutableList<String> getErrors() {
        return this.analysisResult.getErrorMessages();
    }

    public int getTotalSize() {
        return this.analysisResult.getTotalSize();
    }

    public int getNewSize() {
        return this.analysisResult.getNewSize();
    }

    public int getFixedSize() {
        return this.analysisResult.getFixedSize();
    }

    public int getModifiedSize() {
        return this.analysisResult.getTotals().getTotalModifiedSize();
    }

    public int getModifiedNewSize() {
        return this.analysisResult.getTotals().getNewModifiedSize();
    }

    public int getModifiedOutstandingSize() {
        return this.getModifiedSize() - this.getModifiedNewSize();
    }

    public List<StaticAnalysisLabelProvider> getTools() {
        return this.analysisResult.getSizePerOrigin().keySet().stream().map(this.facade::get).collect(Collectors.toList());
    }

    public int totalSize(String origin) {
        return this.analysisResult.getSizePerOrigin().get(origin);
    }

    public QualityGateStatus getQualityGateStatus() {
        return this.analysisResult.getQualityGateResult().getOverallStatus();
    }

    public boolean isResetQualityGateVisible() {
        return this.resetQualityGateCommand.isEnabled(this.analysisResult.getOwner(), this.analysisResult.getId());
    }

    public Optional<Run<?, ?>> getReferenceBuild() {
        return this.analysisResult.getReferenceBuild();
    }

    public String getReferenceBuildLink() {
        return this.facade.getReferenceLink(this.analysisResult.getReferenceBuild().map(Run::getExternalizableId).orElse("-"));
    }

    public boolean isZeroIssuesHighscore() {
        return this.getNoIssuesSinceBuild() > 0 && this.analysisResult.getOwner().getNumber() > this.getNoIssuesSinceBuild();
    }

    public int getNoIssuesSinceBuild() {
        return this.analysisResult.getNoIssuesSinceBuild();
    }

    public String getZeroIssuesHighscoreMessage() {
        return Messages.Summary_NoIssuesSinceBuild(this.analysisResult.getOwner().getNumber() - this.analysisResult.getNoIssuesSinceBuild() + 1);
    }

    public Optional<ResetReferenceAction> getResetReferenceAction() {
        Run<?, ?> owner = this.analysisResult.getOwner();
        return owner.getActions(ResetReferenceAction.class).stream().filter(action -> action.getId().equals(this.analysisResult.getId())).findFirst();
    }

    public boolean isQualityGateReset() {
        return this.getResetReferenceAction().isPresent();
    }

    public String getResetBy() {
        return this.getResetReferenceAction().map(ResetReferenceAction::getUserName).orElse("");
    }

    public String getResetUserId() {
        return this.getResetReferenceAction().map(ResetReferenceAction::getUserId).orElse("");
    }

    public String getResetTimestamp() {
        return this.getResetReferenceAction().map(ResetReferenceAction::getFormattedTimestamp).orElse("");
    }

    static class LabelProviderFactoryFacade {
        LabelProviderFactoryFacade() {
        }

        public StaticAnalysisLabelProvider get(String id) {
            return new LabelProviderFactory().create(id);
        }

        public String getReferenceLink(String id) {
            return ReferenceBuild.getReferenceBuildLink((String)id);
        }
    }
}

