/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.model;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Util;
import hudson.model.Action;
import hudson.model.User;
import java.io.Serializable;

public class ResetReferenceAction
implements Action,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String userId;
    private final long timestamp;

    ResetReferenceAction(String id) {
        this(id, ResetReferenceAction.getCurrentUserId(), System.currentTimeMillis());
    }

    ResetReferenceAction(String id, String userId, long timestamp) {
        this.id = id;
        this.userId = userId;
        this.timestamp = timestamp;
    }

    private static String getCurrentUserId() {
        User current = User.current();
        return current != null ? current.getId() : "anonymous";
    }

    public String getId() {
        return this.id;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getUserName() {
        try {
            User user = User.getById((String)this.userId, (boolean)false);
            return user != null ? user.getFullName() : this.userId;
        }
        catch (IllegalStateException e) {
            return this.userId;
        }
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getFormattedTimestamp() {
        return Util.getTimeSpanString((long)(System.currentTimeMillis() - this.timestamp));
    }

    @CheckForNull
    public String getIconFileName() {
        return null;
    }

    @CheckForNull
    public String getDisplayName() {
        return null;
    }

    @CheckForNull
    public String getUrlName() {
        return null;
    }
}

